/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core;

import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.tuple.Tuple2;
import org.aya.core.term.CallTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.generic.Constants;
import org.aya.ref.Var;
import org.aya.tyck.TyckState;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Meta
implements Var {
    @NotNull
    public final ImmutableSeq<Term.Param> contextTele;
    @NotNull
    public final ImmutableSeq<Term.Param> telescope;
    @NotNull
    public final String name;
    @Nullable
    public final Term result;
    @NotNull
    public final SourcePos sourcePos;
    @NotNull
    public final MutableList<Tuple2<Subst, Term>> conditions = MutableList.create();

    public SeqView<Term.Param> fullTelescope() {
        return this.contextTele.view().concat(this.telescope);
    }

    public boolean solve(@NotNull TyckState state, @NotNull Term t) {
        if (t.findUsages(this) > 0) {
            return false;
        }
        state.metas().put((Object)this, (Object)t);
        return true;
    }

    private Meta(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull String name, @Nullable Term result, @NotNull SourcePos sourcePos) {
        this.contextTele = contextTele;
        this.telescope = telescope;
        this.name = name;
        this.result = result;
        this.sourcePos = sourcePos;
    }

    @NotNull
    public static Meta from(@NotNull ImmutableSeq<Term.Param> contextTele, @NotNull String name, @Nullable Term result, @NotNull SourcePos sourcePos) {
        if (result instanceof FormTerm.Pi) {
            FormTerm.Pi pi = (FormTerm.Pi)result;
            MutableList buf = MutableList.create();
            Term r = pi.parameters((MutableList<Term.Param>)buf);
            return new Meta(contextTele, (ImmutableSeq<Term.Param>)buf.toImmutableSeq(), name, r, sourcePos);
        }
        return new Meta(contextTele, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), name, result, sourcePos);
    }

    @NotNull
    public FormTerm.Pi asPi(@NotNull String domName, @NotNull String codName, boolean explicit, int ulift, @NotNull ImmutableSeq<Arg<Term>> contextArgs) {
        assert (this.telescope.isEmpty());
        Meta domVar = Meta.from(this.contextTele, domName, this.result, this.sourcePos);
        Meta codVar = Meta.from(this.contextTele, codName, this.result, this.sourcePos);
        CallTerm.Hole dom = new CallTerm.Hole(domVar, ulift, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        CallTerm.Hole cod = new CallTerm.Hole(codVar, ulift, contextArgs, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        Term.Param domParam = new Term.Param(Constants.randomlyNamed(this.sourcePos), dom, explicit);
        return new FormTerm.Pi(domParam, cod);
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }
}

