/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.value.Ref;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.Decl;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.PatToTerm;
import org.aya.core.term.CallTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.distill.BaseDistiller;
import org.aya.distill.CoreDistiller;
import org.aya.generic.Arg;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.Tycker;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.env.SeqLocalCtx;
import org.aya.util.distill.AyaDocile;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Debug.Renderer(text="toTerm().toDoc(DistillerOptions.DEBUG).debugRender()")
public interface Pat
extends AyaDocile {
    public boolean explicit();

    @NotNull
    default public Term toTerm() {
        return PatToTerm.INSTANCE.visit(this);
    }

    @NotNull
    public Expr toExpr(@NotNull SourcePos var1);

    @NotNull
    default public Arg<Term> toArg() {
        return new Arg<Term>(this.toTerm(), this.explicit());
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new CoreDistiller(options).pat(this, BaseDistiller.Outer.Free);
    }

    @NotNull
    public Pat rename(@NotNull Subst var1, @NotNull LocalCtx var2, boolean var3);

    @NotNull
    public Pat zonk(@NotNull Tycker var1);

    @NotNull
    public Pat inline();

    public void storeBindings(@NotNull LocalCtx var1);

    @NotNull
    public static ImmutableSeq<Term.Param> extractTele(@NotNull SeqLike<Pat> pats) {
        SeqLocalCtx localCtx = new SeqLocalCtx();
        for (Pat pat : pats) {
            pat.storeBindings(localCtx);
        }
        return localCtx.extract();
    }

    public record Preclause<T extends AyaDocile>(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Pat> patterns, @NotNull Option<T> expr) implements AyaDocile
    {
        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            CoreDistiller distiller = new CoreDistiller(options);
            SeqView pats = (Boolean)options.map.get(DistillerOptions.Key.ShowImplicitPats) != false ? this.patterns : this.patterns.view().filter(Pat::explicit);
            Doc doc = Doc.emptyIf((boolean)pats.isEmpty(), () -> Preclause.lambda$toDoc$1((SeqLike)pats, distiller));
            if (this.expr.isDefined()) {
                return Doc.sep((Doc[])new Doc[]{doc, Doc.symbol((String)"=>"), ((AyaDocile)this.expr.get()).toDoc(options)});
            }
            return doc;
        }

        @NotNull
        public static Preclause<Term> weaken(@NotNull Matching clause) {
            return new Preclause<Term>(clause.sourcePos(), clause.patterns(), Option.some((Object)clause.body()));
        }

        @NotNull
        public static @NotNull Option<@NotNull Matching> lift(@NotNull Preclause<Term> clause) {
            return clause.expr.map(term -> new Matching(clause.sourcePos, clause.patterns, (Term)term));
        }

        private static /* synthetic */ Doc lambda$toDoc$1(SeqLike pats, CoreDistiller distiller) {
            return Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.commaList((SeqLike)pats.view().map(p -> distiller.pat((Pat)p, BaseDistiller.Outer.Free)))});
        }
    }

    public record Prim(boolean explicit, @NotNull DefVar<PrimDef, Decl.PrimDecl> ref) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.RefExpr(pos, this.ref);
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            return this;
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return this;
        }

        @Override
        @NotNull
        public Pat inline() {
            return this;
        }
    }

    public record Ctor(boolean explicit, @NotNull DefVar<CtorDef, Decl.DataCtor> ref, @NotNull ImmutableSeq<Pat> params, @NotNull CallTerm.Data type) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            this.params.forEach(pat -> pat.storeBindings(localCtx));
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return (Expr)this.params.foldLeft((Object)new Expr.RefExpr(pos, this.ref), (f, pat) -> new Expr.AppExpr(pos, (Expr)f, new Expr.NamedArg(pat.explicit(), pat.toExpr(pos))));
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            ImmutableSeq params = this.params.map(pat -> pat.rename(subst, localCtx, pat.explicit()));
            return new Ctor(explicit, this.ref, (ImmutableSeq<Pat>)params, (CallTerm.Data)this.type.subst(subst));
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new Ctor(this.explicit, this.ref, (ImmutableSeq<Pat>)this.params.map(pat -> pat.zonk(tycker)), (CallTerm.Data)tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline() {
            return new Ctor(this.explicit, this.ref, (ImmutableSeq<Pat>)this.params.map(Pat::inline), this.type);
        }
    }

    public record Tuple(boolean explicit, @NotNull ImmutableSeq<Pat> pats) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            this.pats.forEach(pat -> pat.storeBindings(localCtx));
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.TupExpr(pos, (ImmutableSeq<Expr>)this.pats.map(pat -> pat.toExpr(pos)));
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            ImmutableSeq params = this.pats.map(pat -> pat.rename(subst, localCtx, pat.explicit()));
            return new Tuple(explicit, (ImmutableSeq<Pat>)params);
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new Tuple(this.explicit, (ImmutableSeq<Pat>)this.pats.map(pat -> pat.zonk(tycker)));
        }

        @Override
        @NotNull
        public Pat inline() {
            return new Tuple(this.explicit, (ImmutableSeq<Pat>)this.pats.map(Pat::inline));
        }
    }

    public record Absurd(boolean explicit) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.RefExpr(pos, new LocalVar("()", SourcePos.NONE));
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return this;
        }

        @Override
        @NotNull
        public Pat inline() {
            return this;
        }
    }

    public record Meta(boolean explicit, @NotNull Ref<Pat> solution, @NotNull LocalVar fakeBind, @NotNull Term type) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.MetaPat(pos, this);
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            throw new IllegalStateException("unreachable");
        }

        @Override
        @NotNull
        public Pat inline() {
            Pat value = (Pat)this.solution.value;
            if (value == null) {
                this.solution.value = new Bind(this.explicit, this.fakeBind, this.type);
                return (Pat)this.solution.value;
            }
            return value;
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            throw new IllegalStateException("unreachable");
        }
    }

    public record Bind(boolean explicit, @NotNull LocalVar bind, @NotNull Term type) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx localCtx) {
            localCtx.put(this.bind, this.type);
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.RefExpr(pos, this.bind);
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            LocalVar newName = new LocalVar(this.bind.name(), this.bind.definition());
            Bind newBind = new Bind(explicit, newName, this.type.subst(subst));
            subst.addDirectly(this.bind, new RefTerm(newName, 0));
            localCtx.put(newName, this.type);
            return newBind;
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new Bind(this.explicit, this.bind, tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline() {
            return this;
        }
    }
}

