/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Result;
import kala.tuple.Tuple2;
import kala.value.Ref;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.ref.Var;
import org.aya.tyck.env.LocalCtx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PatMatcher(@NotNull Subst subst, @Nullable LocalCtx localCtx) {
    public static Result<Subst, Boolean> tryBuildSubstArgs(@Nullable LocalCtx localCtx, @NotNull @NotNull ImmutableSeq<@NotNull Pat> pats, @NotNull @NotNull SeqLike<@NotNull Arg<@NotNull Term>> terms) {
        return PatMatcher.tryBuildSubstTerms(localCtx, pats, (SeqView<Term>)terms.view().map(Arg::term));
    }

    public static Result<Subst, Boolean> tryBuildSubstTerms(@Nullable LocalCtx localCtx, @NotNull @NotNull ImmutableSeq<@NotNull Pat> pats, @NotNull @NotNull SeqView<@NotNull Term> terms) {
        PatMatcher matchy = new PatMatcher(new Subst((MutableMap<Var, Term>)new MutableHashMap()), localCtx);
        try {
            for (Tuple2 pat : pats.zip(terms)) {
                matchy.match((Tuple2<Pat, Term>)pat);
            }
            return Result.ok((Object)matchy.subst());
        }
        catch (Mismatch mismatch) {
            return Result.err((Object)mismatch.isBlocked);
        }
    }

    private void match(@NotNull Pat pat, @NotNull Term term) throws Mismatch {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Bind.class, Pat.Absurd.class, Pat.Prim.class, Pat.Ctor.class, Pat.Tuple.class, Pat.Meta.class}, (Object)pat3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Pat.Bind bind = (Pat.Bind)pat3;
                this.subst.addDirectly(bind.bind(), term);
                break;
            }
            case 1: {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                throw new IllegalStateException("unreachable");
            }
            case 2: {
                Pat.Prim prim = (Pat.Prim)pat3;
                PrimDef core = (PrimDef)prim.ref().core;
                assert (PrimDef.Factory.INSTANCE.leftOrRight(core));
                Term term2 = term;
                Objects.requireNonNull(term2);
                Term term3 = term2;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CallTerm.Prim.class, RefTerm.MetaPat.class}, (Object)term3, n2)) {
                    case 0: {
                        CallTerm.Prim primCall = (CallTerm.Prim)term3;
                        if (primCall.ref() == prim.ref()) break block0;
                        throw new Mismatch(false);
                    }
                    case 1: {
                        RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term3;
                        this.solve(pat, metaPat);
                        break block0;
                    }
                    default: {
                        throw new Mismatch(true);
                    }
                }
            }
            case 3: {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                Term term4 = term;
                Objects.requireNonNull(term4);
                Term term5 = term4;
                int n3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CallTerm.Con.class, RefTerm.MetaPat.class}, (Object)term5, n3)) {
                    case 0: {
                        CallTerm.Con conCall = (CallTerm.Con)term5;
                        if (ctor.ref() != conCall.ref()) {
                            throw new Mismatch(false);
                        }
                        this.visitList(ctor.params(), (SeqLike<Term>)conCall.conArgs().view().map(Arg::term));
                        break block0;
                    }
                    case 1: {
                        RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term5;
                        this.solve(pat, metaPat);
                        break block0;
                    }
                }
                throw new Mismatch(true);
            }
            case 4: {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                Term term6 = term;
                Objects.requireNonNull(term6);
                Term term7 = term6;
                int conCall = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntroTerm.Tuple.class, RefTerm.MetaPat.class}, (Object)term7, conCall)) {
                    case 0: {
                        IntroTerm.Tuple tup = (IntroTerm.Tuple)term7;
                        this.visitList(tuple.pats(), (SeqLike<Term>)tup.items());
                        break block0;
                    }
                    case 1: {
                        RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term7;
                        this.solve(pat, metaPat);
                        break block0;
                    }
                }
                throw new Mismatch(true);
            }
            case 5: {
                Pat.Meta meta = (Pat.Meta)pat3;
                Pat sol = (Pat)meta.solution().value;
                assert (sol != null) : "Unsolved pattern " + meta;
                this.match(sol, term);
            }
        }
    }

    private void solve(@NotNull Pat pat, @NotNull RefTerm.MetaPat metaPat) throws Mismatch {
        Pat.Meta referee = metaPat.ref();
        Ref<Pat> todo = referee.solution();
        if (todo.value != null) {
            throw new UnsupportedOperationException("unsure what to do, please file an issue with reproduction if you see this!");
        }
        if (this.localCtx == null) {
            throw new Mismatch(true);
        }
        todo.value = pat.rename(this.subst, this.localCtx, referee.explicit());
    }

    private void visitList(ImmutableSeq<Pat> lpats, SeqLike<Term> terms) throws Mismatch {
        assert (lpats.sizeEquals(terms));
        lpats.view().zip(terms).forEachChecked(this::match);
    }

    private void match(@NotNull Tuple2<Pat, Term> pp) throws Mismatch {
        this.match((Pat)pp._1, (Term)pp._2);
    }

    private static final class Mismatch
    extends Exception {
        public final boolean isBlocked;

        private Mismatch(boolean isBlocked) {
            this.isBlocked = isBlocked;
        }
    }
}

