/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.runtime.SwitchBootstraps;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.pat.Pat;
import org.aya.core.visitor.Subst;
import org.aya.pretty.doc.Doc;
import org.aya.ref.LocalVar;
import org.aya.tyck.env.LocalCtx;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;

public record PatUnify(@NotNull Subst lhsSubst, @NotNull Subst rhsSubst, @NotNull LocalCtx ctx) {
    private void unify(@NotNull Pat lhs, @NotNull Pat rhs) {
        Pat pat = lhs;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Bind.class, Pat.Meta.class, Pat.Tuple.class, Pat.Prim.class, Pat.Ctor.class}, (Object)pat, n)) {
            default: {
                throw new IllegalStateException();
            }
            case 0: {
                Pat.Bind bind = (Pat.Bind)pat;
                this.visitAs(bind.bind(), rhs);
                break;
            }
            case 1: {
                Pat.Meta meta = (Pat.Meta)pat;
                this.visitAs(meta.fakeBind(), rhs);
                break;
            }
            case 2: {
                Pat.Tuple tuple = (Pat.Tuple)pat;
                if (rhs instanceof Pat.Tuple) {
                    Pat.Tuple tuple1 = (Pat.Tuple)rhs;
                    this.visitList(tuple.pats(), tuple1.pats());
                    break;
                }
                this.reportError(lhs, rhs);
                break;
            }
            case 3: {
                Pat.Prim prim = (Pat.Prim)pat;
                if (!(rhs instanceof Pat.Prim)) {
                    this.reportError(lhs, rhs);
                    break;
                }
                Pat.Prim prim1 = (Pat.Prim)rhs;
                assert (prim.ref() == prim1.ref());
                break;
            }
            case -1: 
            case 4: {
                Pat.Ctor ctor = (Pat.Ctor)pat;
                if (rhs instanceof Pat.Ctor) {
                    Pat.Ctor ctor1 = (Pat.Ctor)rhs;
                    assert (ctor.ref() == ctor1.ref());
                    this.visitList(ctor.params(), ctor1.params());
                    break;
                }
                this.reportError(lhs, rhs);
            }
        }
    }

    private void visitList(ImmutableSeq<Pat> lpats, ImmutableSeq<Pat> rpats) {
        assert (rpats.sizeEquals(lpats.size()));
        lpats.zip(rpats).forEach(pp -> PatUnify.unifyPat((Pat)pp._1, (Pat)pp._2, this.lhsSubst, this.rhsSubst, this.ctx));
    }

    private void visitAs(@NotNull LocalVar as, Pat rhs) {
        if (rhs instanceof Pat.Bind) {
            Pat.Bind bind = (Pat.Bind)rhs;
            this.ctx.put(bind.bind(), bind.type());
        } else {
            rhs.storeBindings(this.ctx);
        }
        this.lhsSubst.add(as, rhs.toTerm());
    }

    private void reportError(@NotNull Pat lhs, @NotNull Pat pat) {
        Doc doc = Doc.sep((Doc[])new Doc[]{lhs.toDoc(DistillerOptions.debug()), Doc.plain((String)"and"), pat.toDoc(DistillerOptions.debug())});
        throw new IllegalArgumentException(doc.debugRender() + " are patterns of different types!");
    }

    private static void unifyPat(Pat lhs, Pat rhs, Subst lhsSubst, Subst rhsSubst, LocalCtx ctx) {
        if (rhs instanceof Pat.Bind) {
            PatUnify unify = new PatUnify(rhsSubst, lhsSubst, ctx);
            unify.unify(rhs, lhs);
        } else {
            PatUnify unify = new PatUnify(lhsSubst, rhsSubst, ctx);
            unify.unify(lhs, rhs);
        }
    }

    @NotNull
    public static LocalCtx unifyPat(@NotNull SeqLike<Pat> lpats, @NotNull SeqLike<Pat> rpats, @NotNull Subst lhsSubst, @NotNull Subst rhsSubst, @NotNull LocalCtx ctx) {
        assert (rpats.sizeEquals(lpats));
        lpats.view().zip(rpats).forEach(pp -> PatUnify.unifyPat((Pat)pp._1, (Pat)pp._2, lhsSubst, rhsSubst, ctx));
        return ctx;
    }
}

