/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Unit;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.StructDef;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerTerm;
import org.aya.core.serde.Serializer;
import org.aya.ref.DefVar;
import org.aya.ref.Var;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.ModNotFoundError;
import org.aya.resolve.error.UnknownOperatorError;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record CompiledAya(@NotNull ImmutableSeq<ImmutableSeq<String>> imports, @NotNull ImmutableSeq<SerDef.QName> exports, @NotNull ImmutableSeq<ImmutableSeq<String>> reExports, @NotNull ImmutableSeq<SerDef> serDefs, @NotNull ImmutableSeq<SerDef.SerOp> serOps) implements Serializable
{
    @NotNull
    public static CompiledAya from(@NotNull ResolveInfo resolveInfo, @NotNull ImmutableSeq<Def> defs, @NotNull Serializer.State state) {
        ModuleContext moduleContext = resolveInfo.thisModule();
        if (!(moduleContext instanceof PhysicalModuleContext)) {
            throw new UnsupportedOperationException();
        }
        PhysicalModuleContext ctx = (PhysicalModuleContext)moduleContext;
        Serialization serialization = new Serialization(state, (MutableList<SerDef>)MutableList.create(), (MutableList<SerDef.SerOp>)MutableList.create());
        serialization.ser(defs);
        ImmutableSeq<String> modName = ctx.moduleName();
        ImmutableSeq exports = ctx.exports.view().map((k, vs) -> {
            ImmutableSeq qnameMod = modName.appendedAll((Iterable)k);
            return vs.view().map((n, v) -> new SerDef.QName((ImmutableSeq<String>)qnameMod, (String)n));
        }).flatMap(Function.identity()).toImmutableSeq();
        ImmutableSeq imports = resolveInfo.imports().valuesView().map(i -> i.thisModule().moduleName()).toImmutableSeq();
        return new CompiledAya((ImmutableSeq<ImmutableSeq<String>>)imports, (ImmutableSeq<SerDef.QName>)exports, (ImmutableSeq<ImmutableSeq<String>>)resolveInfo.reExports().toImmutableSeq(), (ImmutableSeq<SerDef>)serialization.serDefs.toImmutableSeq(), (ImmutableSeq<SerDef.SerOp>)serialization.serOps.toImmutableSeq());
    }

    private static SerDef.QName nameOf(@NotNull SerDef def) {
        SerDef serDef = def;
        Objects.requireNonNull(serDef);
        SerDef serDef2 = serDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Fn.class, SerDef.Struct.class, SerDef.Field.class, SerDef.Data.class, SerDef.Ctor.class, SerDef.Prim.class}, (Object)serDef2, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                SerDef.Fn fn = (SerDef.Fn)serDef2;
                yield fn.name();
            }
            case 1 -> {
                SerDef.Struct struct = (SerDef.Struct)serDef2;
                yield struct.name();
            }
            case 2 -> {
                SerDef.Field field = (SerDef.Field)serDef2;
                yield field.self();
            }
            case 3 -> {
                SerDef.Data data = (SerDef.Data)serDef2;
                yield data.name();
            }
            case 4 -> {
                SerDef.Ctor ctor = (SerDef.Ctor)serDef2;
                yield ctor.self();
            }
            case 5 -> {
                SerDef.Prim prim = (SerDef.Prim)serDef2;
                yield new SerDef.QName((ImmutableSeq<String>)ImmutableSeq.empty(), prim.name().name());
            }
        };
    }

    @NotNull
    public ResolveInfo toResolveInfo(@NotNull ModuleLoader loader, @NotNull PhysicalModuleContext context, @NotNull SerTerm.DeState state) {
        ResolveInfo resolveInfo = new ResolveInfo(context, (ImmutableSeq<Stmt>)ImmutableSeq.empty(), new AyaBinOpSet(context.reporter()));
        this.shallowResolve(loader, resolveInfo);
        this.serDefs.forEach(serDef -> this.de(context, (SerDef)serDef, state));
        this.deOp(state, resolveInfo.opSet());
        return resolveInfo;
    }

    private void shallowResolve(@NotNull ModuleLoader loader, @NotNull ResolveInfo thisResolve) {
        for (ImmutableSeq modName : this.imports) {
            ResolveInfo success = loader.load((ImmutableSeq<String>)modName);
            if (success == null) {
                thisResolve.thisModule().reportAndThrow(new ModNotFoundError((Seq<String>)modName, SourcePos.SER));
            }
            thisResolve.imports().put(success.thisModule().moduleName(), (Object)success);
            PhysicalModuleContext mod = (PhysicalModuleContext)success.thisModule();
            thisResolve.thisModule().importModules((ImmutableSeq<String>)modName, Stmt.Accessibility.Private, mod.exports, SourcePos.SER);
            if (this.reExports.contains((Object)modName)) {
                thisResolve.thisModule().openModule((ImmutableSeq<String>)modName, Stmt.Accessibility.Public, s -> true, (Map<String, String>)MutableHashMap.create(), SourcePos.SER);
            }
            thisResolve.opSet().importBind(success.opSet(), SourcePos.SER);
        }
    }

    private void deOp(@NotNull SerTerm.DeState state, @NotNull AyaBinOpSet opSet) {
        this.serOps.forEach(serOp -> {
            DefVar defVar = state.resolve(serOp.name());
            OpDecl.OpInfo opInfo = new OpDecl.OpInfo(serOp.name().name(), serOp.assoc(), serOp.argc());
            defVar.opDecl = new SerDef.SerOpDecl(opInfo);
        });
        this.serOps.view().forEach(serOp -> {
            DefVar defVar = state.resolve(serOp.name());
            OpDecl opDecl = defVar.opDecl;
            assert (opDecl != null);
            SerDef.SerBind bind = serOp.bind();
            opSet.ensureHasElem(opDecl);
            bind.loosers().forEach(looser -> {
                OpDecl target = this.resolveOp(opSet, state, (SerDef.QName)looser);
                opSet.bind(opDecl, OpDecl.BindPred.Looser, target, SourcePos.SER);
            });
            bind.tighters().forEach(tighter -> {
                OpDecl target = this.resolveOp(opSet, state, (SerDef.QName)tighter);
                opSet.bind(opDecl, OpDecl.BindPred.Tighter, target, SourcePos.SER);
            });
        });
    }

    @NotNull
    private OpDecl resolveOp(@NotNull AyaBinOpSet opSet, @NotNull SerTerm.DeState state, @NotNull SerDef.QName name) {
        OpDecl opDecl = state.resolve((SerDef.QName)name).opDecl;
        if (opDecl != null) {
            return opDecl;
        }
        opSet.reporter.report((Problem)new UnknownOperatorError(SourcePos.SER, name.name()));
        throw new Context.ResolvingInterruptedException();
    }

    private void de(@NotNull PhysicalModuleContext context, @NotNull SerDef serDef, @NotNull SerTerm.DeState state) {
        ImmutableSeq<String> mod = context.moduleName();
        int drop = mod.size();
        Def def = serDef.de(state);
        assert (def.ref().core != null);
        SerDef serDef2 = serDef;
        Objects.requireNonNull(serDef2);
        SerDef serDef3 = serDef2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Fn.class, SerDef.Data.class, SerDef.Struct.class, SerDef.Prim.class}, (Object)serDef3, n)) {
            case 0: {
                SerDef.Fn fn = (SerDef.Fn)serDef3;
                if (!this.isExported(fn.name())) break;
                this.export(context, drop, fn.name(), def.ref());
                this.export(context, fn.name().name(), def.ref());
                break;
            }
            case 1: {
                SerDef.Data data = (SerDef.Data)serDef3;
                PhysicalModuleContext innerCtx = context.derive(data.name().name());
                if (this.isExported(data.name())) {
                    this.export(context, data.name().name(), def.ref());
                }
                data.bodies().view().zip(((DataDef)def).body).forEach(tup -> {
                    if (this.isExported(((SerDef.Ctor)tup._1).self())) {
                        this.export(context, drop, ((SerDef.Ctor)tup._1).self(), ((CtorDef)tup._2).ref);
                    }
                    this.export(innerCtx, ((SerDef.Ctor)tup._1).self().name(), ((CtorDef)tup._2).ref);
                });
                context.importModules((ImmutableSeq<String>)innerCtx.moduleName().drop(drop), Stmt.Accessibility.Public, innerCtx.exports, SourcePos.SER);
                break;
            }
            case 2: {
                SerDef.Struct struct = (SerDef.Struct)serDef3;
                PhysicalModuleContext innerCtx = context.derive(struct.name().name());
                if (this.isExported(struct.name())) {
                    this.export(context, struct.name().name(), def.ref());
                }
                struct.fields().view().zip(((StructDef)def).fields).forEach(tup -> {
                    if (this.isExported(((SerDef.Field)tup._1).self())) {
                        this.export(context, drop, ((SerDef.Field)tup._1).self(), ((FieldDef)tup._2).ref);
                    }
                    this.export(innerCtx, ((SerDef.Field)tup._1).self().name(), ((FieldDef)tup._2).ref);
                });
                context.importModules((ImmutableSeq<String>)innerCtx.moduleName().drop(drop), Stmt.Accessibility.Public, innerCtx.exports, SourcePos.SER);
                break;
            }
            case 3: {
                SerDef.Prim prim = (SerDef.Prim)serDef3;
                this.export(context, prim.name().id, def.ref());
                break;
            }
        }
    }

    private void export(@NotNull PhysicalModuleContext context, int dropMod, @NotNull SerDef.QName qname, DefVar<?, ?> ref) {
        this.export(context, (ImmutableSeq<String>)qname.mod().drop(dropMod), qname.name(), ref);
    }

    private void export(@NotNull PhysicalModuleContext context, @NotNull String name, @NotNull Var var) {
        this.export(context, (ImmutableSeq<String>)ImmutableSeq.empty(), name, var);
    }

    private void export(@NotNull PhysicalModuleContext context, @NotNull ImmutableSeq<String> mod, @NotNull String name, @NotNull Var var) {
        ((MutableMap)context.exports.getOrPut((Object)ImmutableSeq.empty(), MutableMap::create)).put((Object)name, (Object)var);
        ((MutableMap)context.exports.getOrPut(mod, MutableMap::create)).put((Object)name, (Object)var);
    }

    private boolean isExported(@NotNull SerDef.QName qname) {
        return this.exports.contains((Object)qname);
    }

    private record Serialization(@NotNull Serializer.State state, @NotNull MutableList<SerDef> serDefs, @NotNull MutableList<SerDef.SerOp> serOps) {
        private void ser(@NotNull ImmutableSeq<Def> defs) {
            defs.forEach(this::serDef);
        }

        private void serDef(@NotNull Def def) {
            SerDef serDef = def.accept(new Serializer(this.state), Unit.unit());
            this.serDefs.append((Object)serDef);
            this.serOp(serDef, def);
            SerDef serDef2 = serDef;
            Objects.requireNonNull(serDef2);
            SerDef serDef3 = serDef2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SerDef.Data.class, SerDef.Struct.class}, (Object)serDef3, n)) {
                case 0: {
                    SerDef.Data data = (SerDef.Data)serDef3;
                    data.bodies().view().zip(((DataDef)def).body).forEach(tup -> this.serOp((SerDef)tup._1, (Def)tup._2));
                    break;
                }
                case 1: {
                    SerDef.Struct struct = (SerDef.Struct)serDef3;
                    struct.fields().view().zip(((StructDef)def).fields).forEach(tup -> this.serOp((SerDef)tup._1, (Def)tup._2));
                    break;
                }
            }
        }

        private void serOp(@NotNull SerDef serDef, @NotNull Def def) {
            Object concrete = def.ref().concrete;
            OpDecl.OpInfo opInfo = ((Signatured)concrete).opInfo;
            if (opInfo != null) {
                this.serOps.append((Object)new SerDef.SerOp(CompiledAya.nameOf(serDef), opInfo.assoc(), opInfo.argc(), this.serBind(((Signatured)concrete).bindBlock)));
            }
        }

        @NotNull
        private SerDef.SerBind serBind(@NotNull BindBlock bindBlock) {
            if (bindBlock == BindBlock.EMPTY) {
                return SerDef.SerBind.EMPTY;
            }
            ImmutableSeq loosers = ((ImmutableSeq)bindBlock.resolvedLoosers().value).map(this.state::def);
            ImmutableSeq tighters = ((ImmutableSeq)bindBlock.resolvedTighters().value).map(this.state::def);
            return new SerDef.SerBind((ImmutableSeq<SerDef.QName>)loosers, (ImmutableSeq<SerDef.QName>)tighters);
        }
    }
}

