/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Signatured;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.PrimDef;
import org.aya.core.serde.SerDef;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerTerm
extends Serializable {
    @NotNull
    public Term de(@NotNull DeState var1);

    public record FieldRef(@NotNull SerDef.QName name, int ulift) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm.Field(state.resolve(this.name), this.ulift);
        }
    }

    public record Access(@NotNull SerTerm of, @NotNull SerDef.QName ref, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> structArgs, @NotNull @NotNull ImmutableSeq<@NotNull SerArg> fieldArgs) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Access(this.of.de(state), state.resolve(this.ref), (ImmutableSeq<Arg<Term>>)this.structArgs.map(arg -> arg.de(state)), (ImmutableSeq<Arg<Term>>)this.fieldArgs.map(arg -> arg.de(state)));
        }
    }

    public record Tup(@NotNull ImmutableSeq<SerTerm> components) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.Tuple((ImmutableSeq<Term>)this.components.map(t -> t.de(state)));
        }
    }

    public record ConCall(@NotNull SerDef.QName dataRef, @NotNull SerDef.QName selfRef, @NotNull CallData dataArgs, @NotNull ImmutableSeq<SerArg> args) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Con(state.resolve(this.dataRef), state.resolve(this.selfRef), this.dataArgs.de(state), this.dataArgs.ulift, (ImmutableSeq<Arg<Term>>)this.args.map(arg -> arg.de(state)));
        }
    }

    public record PrimCall(@NotNull SerDef.QName name, @NotNull PrimDef.ID id, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Prim(state.resolve(this.name), this.id, this.data.ulift, this.data.de(state));
        }
    }

    public record DataCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public CallTerm.Data de(@NotNull DeState state) {
            return new CallTerm.Data(state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record FnCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new CallTerm.Fn(state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record StructCall(@NotNull SerDef.QName name, @NotNull CallData data) implements SerTerm
    {
        @Override
        @NotNull
        public CallTerm.Struct de(@NotNull DeState state) {
            return new CallTerm.Struct(state.resolve(this.name), this.data.ulift, this.data.de(state));
        }
    }

    public record CallData(int ulift, @NotNull ImmutableSeq<SerArg> args) implements Serializable
    {
        @NotNull
        public ImmutableSeq<Arg<Term>> de(@NotNull DeState state) {
            return this.args.map(arg -> arg.de(state));
        }
    }

    public record App(@NotNull SerTerm of, @NotNull SerArg arg) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.App(this.of.de(state), this.arg.de(state));
        }
    }

    public record SerArg(@NotNull SerTerm arg, boolean explicit) implements Serializable
    {
        @NotNull
        public Arg<Term> de(@NotNull DeState state) {
            return new Arg<Term>(this.arg.de(state), this.explicit);
        }
    }

    public record Proj(@NotNull SerTerm of, int ix) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new ElimTerm.Proj(this.of.de(state), this.ix);
        }
    }

    public record New(@NotNull StructCall call, @NotNull ImmutableMap<SerDef.QName, SerTerm> map) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.New(this.call.de(state), (ImmutableMap<DefVar<FieldDef, Decl.StructField>, Term>)ImmutableMap.from((Iterable)this.map.view().map((k, v) -> Tuple.of(state.resolve((SerDef.QName)k), (Object)v.de(state)))));
        }
    }

    public record Lam(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new IntroTerm.Lambda(this.param.de(state), this.body.de(state));
        }
    }

    public record Ref(@NotNull SimpVar var, int ulift) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new RefTerm(state.var(this.var), this.ulift);
        }
    }

    public record Univ(int ulift) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Univ(this.ulift);
        }
    }

    public record Sigma(@NotNull ImmutableSeq<SerParam> params) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Sigma((ImmutableSeq<Term.Param>)this.params.map(p -> p.de(state)));
        }
    }

    public record Pi(@NotNull SerParam param, @NotNull SerTerm body) implements SerTerm
    {
        @Override
        @NotNull
        public Term de(@NotNull DeState state) {
            return new FormTerm.Pi(this.param.de(state), this.body.de(state));
        }
    }

    public record SerParam(boolean explicit, boolean pattern, @NotNull SimpVar var, @NotNull SerTerm term) implements Serializable
    {
        @NotNull
        public Term.Param de(@NotNull DeState state) {
            return new Term.Param(state.var(this.var), this.term.de(state), this.pattern, this.explicit);
        }
    }

    public record SimpVar(int var, @NotNull String name) implements Serializable
    {
    }

    public record DeState(@NotNull MutableMap<Seq<String>, MutableMap<String, DefVar<?, ?>>> defCache, @NotNull MutableMap<Integer, LocalVar> localCache) {
        public DeState() {
            this(MutableMap.create(), (MutableMap<Integer, LocalVar>)MutableMap.create());
        }

        @NotNull
        public LocalVar var(@NotNull SimpVar var) {
            return (LocalVar)this.localCache.getOrPut((Object)var.var, () -> new LocalVar(var.name));
        }

        @NotNull
        public <Core extends Def, Concrete extends Signatured> DefVar<Core, Concrete> resolve(@NotNull SerDef.QName name) {
            DefVar dv = (DefVar)((MutableMap)this.defCache.getOrThrow(name.mod(), () -> new SerDef.DeserializeException("Unable to find module: " + name.mod()))).getOrThrow((Object)name.name(), () -> new SerDef.DeserializeException("Unable to find DefVar: " + name));
            assert (Objects.equals(name.name(), dv.name()));
            return dv;
        }

        @NotNull
        <Core extends Def, Concrete extends Signatured> DefVar<Core, Concrete> newDef(@NotNull SerDef.QName name) {
            DefVar defVar = DefVar.empty(name.name());
            Option old = ((MutableMap)this.defCache.getOrPut(name.mod(), MutableHashMap::new)).put((Object)name.name(), defVar);
            if (old.isDefined()) {
                throw new SerDef.DeserializeException("Same definition deserialized twice: " + name);
            }
            defVar.module = name.mod();
            return defVar;
        }

        public void putPrim(@NotNull ImmutableSeq<String> mod, @NotNull PrimDef.ID id, @NotNull DefVar<?, ?> defVar) {
            Option old = ((MutableMap)this.defCache.getOrPut(mod, MutableHashMap::new)).put((Object)id.id, defVar);
            if (old.isDefined()) {
                throw new SerDef.DeserializeException("Same prim deserialized twice: " + id.id);
            }
            defVar.module = mod;
        }
    }
}

