/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Unit;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerPat;
import org.aya.core.serde.SerTerm;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Serializer(@NotNull State state) implements Term.Visitor<Unit, SerTerm>,
Def.Visitor<Unit, SerDef>
{
    @NotNull
    private SerTerm serialize(@NotNull Term term) {
        return term.accept(this, Unit.unit());
    }

    @NotNull
    private SerPat serialize(@NotNull Pat pat) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Absurd.class, Pat.Ctor.class, Pat.Prim.class, Pat.Tuple.class, Pat.Bind.class, Pat.Meta.class}, (Object)pat3, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                yield new SerPat.Absurd(absurd.explicit());
            }
            case 1 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                yield new SerPat.Ctor(ctor.explicit(), this.state.def(ctor.ref()), this.serializePats(ctor.params()), this.visitDataCall(ctor.type(), Unit.unit()));
            }
            case 2 -> {
                Pat.Prim prim = (Pat.Prim)pat3;
                yield new SerPat.Prim(prim.explicit(), this.state.def(prim.ref()));
            }
            case 3 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                yield new SerPat.Tuple(tuple.explicit(), this.serializePats(tuple.pats()));
            }
            case 4 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield new SerPat.Bind(bind.explicit(), this.state.local(bind.bind()), this.serialize(bind.type()));
            }
            case 5 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                throw new IllegalArgumentException(meta.toString());
            }
        };
    }

    @NotNull
    private SerPat.Matchy serialize(@NotNull Matching matchy) {
        return new SerPat.Matchy(this.serializePats(matchy.patterns()), this.serialize(matchy.body()));
    }

    private SerTerm.SerArg serialize(@NotNull @NotNull Arg<@NotNull Term> termArg) {
        return new SerTerm.SerArg(this.serialize(termArg.term()), termArg.explicit());
    }

    @Contract(value="_ -> new")
    private SerTerm.SerParam serialize(@NotNull Term.Param param) {
        return new SerTerm.SerParam(param.explicit(), param.pattern(), this.state.local(param.ref()), this.serialize(param.type()));
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerParam> serializeParams(ImmutableSeq<@NotNull Term.Param> params) {
        return params.map(this::serialize);
    }

    @Override
    public SerTerm visitError(@NotNull ErrorTerm term, Unit unit) {
        throw new AssertionError((Object)"Shall not have error term serialized.");
    }

    @Override
    public SerTerm visitMetaPat(@NotNull RefTerm.MetaPat metaPat, Unit unit) {
        throw new AssertionError((Object)"Shall not have metaPats serialized.");
    }

    @Override
    public SerTerm visitHole( @NotNull CallTerm.Hole term, Unit unit) {
        throw new AssertionError((Object)"Shall not have holes serialized.");
    }

    @Override
    public SerTerm visitFieldRef(@NotNull RefTerm.Field term, Unit unit) {
        return new SerTerm.FieldRef(this.state.def(term.ref()), term.lift());
    }

    @Override
    public SerTerm visitRef(@NotNull RefTerm term, Unit unit) {
        return new SerTerm.Ref(this.state.local(term.var()), term.lift());
    }

    @Override
    public SerTerm visitLam( @NotNull IntroTerm.Lambda term, Unit unit) {
        return new SerTerm.Lam(this.serialize(term.param()), this.serialize(term.body()));
    }

    @Override
    public SerTerm visitPi( @NotNull FormTerm.Pi term, Unit unit) {
        return new SerTerm.Pi(this.serialize(term.param()), this.serialize(term.body()));
    }

    @Override
    public SerTerm visitSigma( @NotNull FormTerm.Sigma term, Unit unit) {
        return new SerTerm.Sigma(this.serializeParams(term.params()));
    }

    @Override
    public SerTerm visitUniv( @NotNull FormTerm.Univ term, Unit unit) {
        return new SerTerm.Univ(term.lift());
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerArg> serializeArgs(@NotNull ImmutableSeq<Arg<Term>> args) {
        return args.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerPat> serializePats(@NotNull ImmutableSeq<Pat> pats) {
        return pats.map(this::serialize);
    }

    @Override
    public SerTerm visitApp( @NotNull ElimTerm.App term, Unit unit) {
        return new SerTerm.App(this.serialize(term.of()), this.serialize(term.arg()));
    }

    @NotNull
    private SerTerm.CallData serializeCall(int ulift, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
        return new SerTerm.CallData(ulift, this.serializeArgs(args));
    }

    @Override
    public SerTerm visitFnCall(@NotNull CallTerm.Fn fnCall, Unit unit) {
        return new SerTerm.FnCall(this.state.def((DefVar<?, ?>)fnCall.ref()), this.serializeCall(fnCall.ulift(), fnCall.args()));
    }

    @Override
    public SerTerm.DataCall visitDataCall(@NotNull CallTerm.Data dataCall, Unit unit) {
        return new SerTerm.DataCall(this.state.def((DefVar<?, ?>)dataCall.ref()), this.serializeCall(dataCall.ulift(), dataCall.args()));
    }

    @Override
    public SerTerm visitConCall(@NotNull CallTerm.Con conCall, Unit unit) {
        return new SerTerm.ConCall(this.state.def(conCall.head().dataRef()), this.state.def(conCall.head().ref()), this.serializeCall(conCall.head().ulift(), conCall.head().dataArgs()), this.serializeArgs(conCall.args()));
    }

    @Override
    public SerTerm.StructCall visitStructCall(@NotNull CallTerm.Struct structCall, Unit unit) {
        return new SerTerm.StructCall(this.state.def((DefVar<?, ?>)structCall.ref()), this.serializeCall(structCall.ulift(), structCall.args()));
    }

    @Override
    public SerTerm visitPrimCall( @NotNull CallTerm.Prim prim, Unit unit) {
        return new SerTerm.PrimCall(this.state.def((DefVar<?, ?>)prim.ref()), prim.id(), this.serializeCall(prim.ulift(), prim.args()));
    }

    @Override
    public SerTerm visitTup( @NotNull IntroTerm.Tuple term, Unit unit) {
        return new SerTerm.Tup((ImmutableSeq<SerTerm>)term.items().map(this::serialize));
    }

    @Override
    public SerTerm visitNew( @NotNull IntroTerm.New newTerm, Unit unit) {
        return new SerTerm.New(this.visitStructCall(newTerm.struct(), unit), (ImmutableMap<SerDef.QName, SerTerm>)ImmutableMap.from((Iterable)newTerm.params().view().map((k, v) -> Tuple.of((Object)this.state.def((DefVar<?, ?>)k), (Object)this.serialize((Term)v)))));
    }

    @Override
    public SerTerm visitProj( @NotNull ElimTerm.Proj term, Unit unit) {
        return new SerTerm.Proj(this.serialize(term.of()), term.ix());
    }

    @Override
    public SerTerm visitAccess( @NotNull CallTerm.Access term, Unit unit) {
        return new SerTerm.Access(this.serialize(term.of()), this.state.def((DefVar<?, ?>)term.ref()), this.serializeArgs(term.structArgs()), this.serializeArgs(term.fieldArgs()));
    }

    @Override
    public SerDef visitFn(@NotNull FnDef def, Unit unit) {
        return new SerDef.Fn(this.state.def(def.ref), this.serializeParams((ImmutableSeq<Term.Param>)def.telescope), (Either<SerTerm, ImmutableSeq<SerPat.Matchy>>)def.body.map(this::serialize, matchings -> matchings.map(this::serialize)), def.modifiers, this.serialize(def.result));
    }

    @Override
    public SerDef visitData(@NotNull DataDef def, Unit unit) {
        return new SerDef.Data(this.state.def(def.ref), this.serializeParams((ImmutableSeq<Term.Param>)def.telescope), def.resultLevel, (ImmutableSeq<SerDef.Ctor>)def.body.map(ctor -> this.visitCtor((CtorDef)ctor, Unit.unit())));
    }

    @Override
    public SerDef.Ctor visitCtor(@NotNull CtorDef def, Unit unit) {
        return new SerDef.Ctor(this.state.def(def.dataRef), this.state.def(def.ref), this.serializePats(def.pats), this.serializeParams((ImmutableSeq<Term.Param>)def.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)def.selfTele), (ImmutableSeq<SerPat.Matchy>)def.clauses.map(this::serialize), this.serialize(def.result), def.coerce);
    }

    @Override
    public SerDef visitStruct(@NotNull StructDef def, Unit unit) {
        return new SerDef.Struct(this.state.def(def.ref()), this.serializeParams((ImmutableSeq<Term.Param>)def.telescope), def.resultLevel, (ImmutableSeq<SerDef.Field>)def.fields.map(field -> this.visitField((FieldDef)field, Unit.unit())));
    }

    @Override
    public SerDef.Field visitField(@NotNull FieldDef def, Unit unit) {
        return new SerDef.Field(this.state.def(def.structRef), this.state.def(def.ref), this.serializeParams((ImmutableSeq<Term.Param>)def.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)def.selfTele), this.serialize(def.result), (ImmutableSeq<SerPat.Matchy>)def.clauses.map(this::serialize), (Option<SerTerm>)def.body.map(this::serialize), def.coerce);
    }

    @Override
    public SerDef visitPrim(@NotNull PrimDef def, Unit unit) {
        assert (def.ref.module != null);
        return new SerDef.Prim(def.ref.module, def.id);
    }

    public record State(@NotNull MutableMap<LocalVar, Integer> localCache, @NotNull MutableMap<DefVar<?, ?>, Integer> defCache) {
        public State() {
            this((MutableMap<LocalVar, Integer>)MutableMap.create(), MutableMap.create());
        }

        @NotNull
        public SerTerm.SimpVar local(@NotNull LocalVar var) {
            return new SerTerm.SimpVar((Integer)this.localCache.getOrPut((Object)var, () -> this.localCache.size()), var.name());
        }

        @NotNull
        public SerDef.QName def(@NotNull DefVar<?, ?> var) {
            assert (var.module != null);
            return new SerDef.QName(var.module, var.name());
        }
    }
}

