/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.ref.Var;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ElimTerm
extends Term {
    @NotNull
    public Term of();

    @NotNull
    public static Term unapp(@NotNull Term term, MutableList<Arg<@NotNull Term>> args) {
        while (term instanceof App) {
            App app = (App)term;
            args.append(app.arg);
            term = app.of;
        }
        args.reverse();
        return term;
    }

    public record App(@NotNull Term of, @NotNull @NotNull Arg<@NotNull Term> arg) implements ElimTerm
    {
        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitApp(this, p);
        }
    }

    public record Proj(@NotNull Term of, int ix) implements ElimTerm
    {
        @NotNull
        public static Subst projSubst(@NotNull Term term, int index, ImmutableSeq<Term.Param> telescope) {
            Subst subst = new Subst((MutableMap<Var, Term>)MutableMap.create());
            telescope.view().take(index).reversed().forEachIndexed((i, param) -> subst.add(param.ref(), new Proj(term, i + 1)));
            return subst;
        }

        @Override
        public <P, R> R doAccept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return visitor.visitProj(this, p);
        }
    }
}

