/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Unit;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermConsumer;
import org.jetbrains.annotations.NotNull;

public interface DefConsumer<P>
extends Def.Visitor<P, Unit>,
TermConsumer<P> {
    private void tele(@NotNull ImmutableSeq<Term.Param> tele, P p) {
        tele.forEach(param -> param.type().accept(this, p));
    }

    private void visitDef(@NotNull Def def, P p) {
        this.tele(def.telescope(), p);
        def.result().accept(this, p);
    }

    default public void visitMatching(@NotNull Matching matching, P p) {
        matching.patterns().forEach(pat -> this.visitPat((Pat)pat, p));
        matching.body().accept(this, p);
    }

    default public void visitPat(@NotNull Pat pat, P p) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Ctor.class, Pat.Tuple.class}, (Object)pat3, n)) {
            case 0: {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                ctor.params().forEach(param -> this.visitPat((Pat)param, p));
                break;
            }
            case 1: {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                tuple.pats().forEach(param -> this.visitPat((Pat)param, p));
                break;
            }
        }
    }

    @Override
    default public Unit visitFn(@NotNull FnDef def, P p) {
        this.visitDef(def, p);
        def.body.forEach(body -> body.accept(this, p), matchings -> matchings.forEach(m -> this.visitMatching((Matching)m, p)));
        return Unit.unit();
    }

    @Override
    default public Unit visitData(@NotNull DataDef def, P p) {
        this.visitDef(def, p);
        def.body.forEach(ctor -> this.visitCtor((CtorDef)ctor, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitStruct(@NotNull StructDef def, P p) {
        this.visitDef(def, p);
        def.fields.forEach(field -> field.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitCtor(@NotNull CtorDef def, P p) {
        def.pats.forEach(pat -> this.visitPat((Pat)pat, p));
        this.tele((ImmutableSeq<Term.Param>)def.selfTele, p);
        def.result.accept(this, p);
        def.clauses.forEach(m -> this.visitMatching((Matching)m, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitField(@NotNull FieldDef def, P p) {
        this.tele((ImmutableSeq<Term.Param>)def.selfTele, p);
        def.result.accept(this, p);
        def.clauses.forEach(m -> this.visitMatching((Matching)m, p));
        def.body.forEach(body -> body.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitPrim(@NotNull PrimDef def, P p) {
        this.visitDef(def, p);
        return Unit.unit();
    }
}

