/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.util.function.BiFunction;
import kala.collection.View;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.Decl;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.generic.ParamLike;
import org.aya.ref.DefVar;
import org.jetbrains.annotations.NotNull;

public interface TermFixpoint<P>
extends Term.Visitor<P, Term> {
    @Override
    @NotNull
    default public Term visitHole(@NotNull CallTerm.Hole term, P p) {
        ImmutableSeq contextArgs = term.contextArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq args = term.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (this.ulift() == 0 && term.contextArgs().sameElements((Iterable)contextArgs, true) && term.args().sameElements((Iterable)args, true)) {
            return term;
        }
        return new CallTerm.Hole(term.ref(), this.ulift() + term.ulift(), (ImmutableSeq<Arg<Term>>)contextArgs, (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public Term visitFieldRef(@NotNull RefTerm.Field term, P p) {
        return term;
    }

    default public int ulift() {
        return 0;
    }

    @Override
    @NotNull
    default public Term visitDataCall(@NotNull CallTerm.Data dataCall, P p) {
        ImmutableSeq args = dataCall.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (this.ulift() == 0 && dataCall.args().sameElements((Iterable)args, true)) {
            return dataCall;
        }
        return new CallTerm.Data((DefVar<DataDef, Decl.DataDecl>)dataCall.ref(), this.ulift() + dataCall.ulift(), (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public ErrorTerm visitError(@NotNull ErrorTerm term, P p) {
        return term;
    }

    @Override
    @NotNull
    default public Term visitMetaPat(@NotNull RefTerm.MetaPat metaPat, P p) {
        return metaPat;
    }

    @Override
    @NotNull
    default public Term visitConCall(@NotNull CallTerm.Con conCall, P p) {
        ImmutableSeq dataArgs = conCall.head().dataArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq conArgs = conCall.conArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (this.ulift() == 0 && conCall.head().dataArgs().sameElements((Iterable)dataArgs, true) && conCall.conArgs().sameElements((Iterable)conArgs, true)) {
            return conCall;
        }
        CallTerm.ConHead head = new CallTerm.ConHead(conCall.head().dataRef(), conCall.head().ref(), this.ulift() + conCall.ulift(), (ImmutableSeq<Arg<Term>>)dataArgs);
        return new CallTerm.Con(head, (ImmutableSeq<Arg<Term>>)conArgs);
    }

    @Override
    @NotNull
    default public Term visitStructCall(@NotNull CallTerm.Struct structCall, P p) {
        ImmutableSeq args = structCall.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (this.ulift() == 0 && structCall.args().sameElements((Iterable)args, true)) {
            return structCall;
        }
        return new CallTerm.Struct((DefVar<StructDef, Decl.StructDecl>)structCall.ref(), this.ulift() + structCall.ulift(), (ImmutableSeq<Arg<Term>>)args);
    }

    private <T> T visitParameterized(@NotNull Term.Param theParam, @NotNull Term theBody, @NotNull P p, @NotNull T original, @NotNull @NotNull BiFunction<@NotNull Term.Param, @NotNull Term, T> callback) {
        Term.Param param = new Term.Param(theParam, (Term)theParam.type().accept(this, p));
        Term body = (Term)theBody.accept(this, p);
        if (param.type() == theParam.type() && body == theBody) {
            return original;
        }
        return callback.apply(param, body);
    }

    @Override
    @NotNull
    default public Term visitLam(@NotNull IntroTerm.Lambda term, P p) {
        return this.visitParameterized(term.param(), term.body(), p, term, IntroTerm.Lambda::new);
    }

    @Override
    @NotNull
    default public Term visitUniv(@NotNull FormTerm.Univ term, P p) {
        if (this.ulift() == 0) {
            return term;
        }
        return new FormTerm.Univ(this.ulift() + term.lift());
    }

    @Override
    @NotNull
    default public Term visitPi(@NotNull FormTerm.Pi term, P p) {
        return this.visitParameterized(term.param(), term.body(), p, term, FormTerm.Pi::new);
    }

    @Override
    @NotNull
    default public Term visitSigma(@NotNull FormTerm.Sigma term, P p) {
        ImmutableSeq params = term.params().map(param -> new Term.Param((ParamLike<?>)param, (Term)param.type().accept(this, p)));
        if (params.sameElements(term.params(), true)) {
            return term;
        }
        return new FormTerm.Sigma((ImmutableSeq<Term.Param>)params);
    }

    @Override
    @NotNull
    default public Term visitRef(@NotNull RefTerm term, P p) {
        return term;
    }

    @NotNull
    default public Arg<Term> visitArg(@NotNull Arg<Term> arg, P p) {
        Term term = (Term)arg.term().accept(this, p);
        if (term == arg.term()) {
            return arg;
        }
        return new Arg<Term>(term, arg.explicit());
    }

    @Override
    @NotNull
    default public Term visitApp(@NotNull ElimTerm.App term, P p) {
        Term function = (Term)term.of().accept(this, p);
        Arg<Term> arg = this.visitArg(term.arg(), p);
        if (function == term.of() && arg == term.arg()) {
            return term;
        }
        return CallTerm.make(function, arg);
    }

    @Override
    @NotNull
    default public Term visitFnCall(@NotNull CallTerm.Fn fnCall, P p) {
        ImmutableSeq args = fnCall.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (this.ulift() == 0 && fnCall.args().sameElements((Iterable)args, true)) {
            return fnCall;
        }
        return new CallTerm.Fn((DefVar<FnDef, Decl.FnDecl>)fnCall.ref(), this.ulift() + fnCall.ulift(), (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public Term visitPrimCall(@NotNull CallTerm.Prim prim, P p) {
        ImmutableSeq args = prim.args().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (this.ulift() == 0 && prim.args().sameElements((Iterable)args, true)) {
            return prim;
        }
        return new CallTerm.Prim((DefVar<PrimDef, Decl.PrimDecl>)prim.ref(), this.ulift() + prim.ulift(), (ImmutableSeq<Arg<Term>>)args);
    }

    @Override
    @NotNull
    default public Term visitTup(@NotNull IntroTerm.Tuple term, P p) {
        ImmutableSeq items = term.items().map(x -> (Term)x.accept(this, p));
        if (term.items().sameElements((Iterable)items, true)) {
            return term;
        }
        return new IntroTerm.Tuple((ImmutableSeq<Term>)items);
    }

    @Override
    @NotNull
    default public Term visitNew(@NotNull IntroTerm.New struct, P p) {
        View itemsView = struct.params().view().map((k, v) -> Tuple.of((Object)k, (Object)((Term)v.accept(this, p))));
        ImmutableMap items = ImmutableMap.from((Iterable)itemsView);
        return new IntroTerm.New((CallTerm.Struct)struct.struct().accept(this, p), (ImmutableMap<DefVar<FieldDef, Decl.StructField>, Term>)items);
    }

    @Override
    @NotNull
    default public Term visitProj(@NotNull ElimTerm.Proj term, P p) {
        Term tuple = (Term)term.of().accept(this, p);
        if (this.ulift() == 0 && tuple == term.of()) {
            return term;
        }
        return new ElimTerm.Proj(tuple, term.ix());
    }

    @Override
    @NotNull
    default public Term visitAccess(@NotNull CallTerm.Access term, P p) {
        Term tuple = (Term)term.of().accept(this, p);
        ImmutableSeq args = term.fieldArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        ImmutableSeq structArgs = term.structArgs().map(arg -> this.visitArg((Arg<Term>)arg, p));
        if (term.fieldArgs().sameElements((Iterable)args, true) && term.structArgs().sameElements((Iterable)structArgs, true) && tuple == term.of()) {
            return term;
        }
        return new CallTerm.Access(tuple, (DefVar<FieldDef, Decl.StructField>)term.ref(), (ImmutableSeq<Arg<Term>>)structArgs, (ImmutableSeq<Arg<Term>>)args);
    }
}

