/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Result;
import org.aya.concrete.stmt.Decl;
import org.aya.core.Matching;
import org.aya.core.Meta;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.PatMatcher;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.TermView;
import org.aya.generic.Arg;
import org.aya.generic.Modifier;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.tyck.TyckState;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TermOps
extends TermView {
    @NotNull
    public TermView view();

    @Override
    @NotNull
    default public Term initial() {
        return this.view().initial();
    }

    @Override
    default public Term pre(Term term) {
        return this.view().pre(term);
    }

    @Override
    default public Term post(Term term) {
        return this.view().post(term);
    }

    public record Normalizer(@NotNull TermView view, TyckState state) implements TermOps
    {
        @NotNull
        private static Subst buildSubst(@NotNull @NotNull SeqLike<@NotNull Term.Param> params, @NotNull @NotNull SeqLike<@NotNull Arg<@NotNull Term>> args) {
            Subst subst = new Subst((MutableMap<Var, Term>)MutableMap.create());
            params.view().zip(args).forEach(t -> subst.add(((Term.Param)t._1).ref(), (Term)((Arg)t._2).term()));
            return subst;
        }

        @Nullable
        private WithPos<Term> unfoldClauses(boolean orderIndependent, SeqLike<Arg<Term>> args, @NotNull ImmutableSeq<Matching> clauses) {
            return this.unfoldClauses(orderIndependent, args, new Subst((MutableMap<Var, Term>)MutableMap.create()), clauses);
        }

        @Nullable
        private WithPos<Term> unfoldClauses(boolean orderIndependent, SeqLike<Arg<Term>> args, @NotNull Subst subst, @NotNull ImmutableSeq<Matching> clauses) {
            for (Matching match : clauses) {
                Result<Subst, Boolean> result = PatMatcher.tryBuildSubstArgs(null, match.patterns(), args);
                if (result.isOk()) {
                    subst.add((Subst)result.get());
                    Term body = match.body().view().subst(subst).normalize(this.state).commit();
                    return new WithPos(match.sourcePos(), (Object)body);
                }
                if (orderIndependent || !((Boolean)result.getErr()).booleanValue()) continue;
                return null;
            }
            return null;
        }

        @Override
        public Term post(Term term) {
            Term term2 = this.view.post(term);
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ElimTerm.App.class, ElimTerm.Proj.class, CallTerm.Con.class, CallTerm.Fn.class, CallTerm.Access.class, CallTerm.Prim.class, CallTerm.Hole.class, RefTerm.MetaPat.class, Term.class}, (Object)term2, n)) {
                case 0 -> {
                    ElimTerm.App app = (ElimTerm.App)term2;
                    Term fn = app.of();
                    if (fn instanceof IntroTerm.Lambda) {
                        IntroTerm.Lambda lambda = (IntroTerm.Lambda)fn;
                        yield CallTerm.make(lambda, app.arg());
                    }
                    yield app;
                }
                case 1 -> {
                    ElimTerm.Proj proj = (ElimTerm.Proj)term2;
                    Term tup = proj.of();
                    int ix = proj.ix();
                    if (tup instanceof IntroTerm.Tuple) {
                        IntroTerm.Tuple tuple = (IntroTerm.Tuple)tup;
                        if (!($assertionsDisabled || tuple.items().sizeGreaterThanOrEquals(ix) && ix > 0)) {
                            throw new AssertionError((Object)proj.toDoc(DistillerOptions.debug()).debugRender());
                        }
                        yield (Term)tuple.items().get(ix - 1);
                    }
                    yield proj;
                }
                case 2 -> {
                    CallTerm.Con con = (CallTerm.Con)term2;
                    CtorDef def = (CtorDef)((DefVar)con.ref()).core;
                    if (def == null) {
                        yield con;
                    }
                    WithPos<Term> unfolded = this.unfoldClauses(true, (SeqLike<Arg<Term>>)con.conArgs(), (ImmutableSeq<Matching>)def.clauses);
                    if (unfolded != null) {
                        yield (Term)unfolded.data();
                    }
                    yield con;
                }
                case 3 -> {
                    CallTerm.Fn fn = (CallTerm.Fn)term2;
                    FnDef def = (FnDef)((DefVar)fn.ref()).core;
                    if (def == null) {
                        yield fn;
                    }
                    if (def.modifiers.contains((Object)Modifier.Opaque)) {
                        yield fn;
                    }
                    yield (Term)def.body.fold(lamBody -> lamBody.view().subst(Normalizer.buildSubst(def.telescope(), fn.args())).normalize(this.state).commit(), patBody -> {
                        boolean orderIndependent = def.modifiers.contains((Object)Modifier.Overlap);
                        WithPos<Term> unfolded = this.unfoldClauses(orderIndependent, (SeqLike<Arg<Term>>)fn.args(), (ImmutableSeq<Matching>)patBody);
                        return unfolded != null ? (Term)unfolded.data() : fn;
                    });
                }
                case 4 -> {
                    CallTerm.Access access = (CallTerm.Access)term2;
                    FieldDef fieldDef = (FieldDef)((DefVar)access.ref()).core;
                    Term var11_19 = access.of();
                    if (var11_19 instanceof IntroTerm.New) {
                        IntroTerm.New n = (IntroTerm.New)var11_19;
                        Term fieldBody = (Term)access.fieldArgs().foldLeft((Object)((Term)n.params().get((Object)access.ref())), CallTerm::make);
                        yield fieldBody.view().subst(Normalizer.buildSubst((SeqLike<Term.Param>)fieldDef.ownerTele, access.structArgs())).normalize(this.state).commit();
                    }
                    Subst subst = Normalizer.buildSubst(fieldDef.fullTelescope(), access.args());
                    for (FieldDef field : ((StructDef)fieldDef.structRef.core).fields) {
                        if (field == fieldDef) continue;
                        ImmutableSeq fieldArgs = field.telescope().map(Term.Param::toArg);
                        CallTerm.Access acc = new CallTerm.Access(access.of(), field.ref, access.structArgs(), (ImmutableSeq<Arg<Term>>)fieldArgs);
                        subst.add(field.ref, IntroTerm.Lambda.make(field.telescope(), acc));
                    }
                    WithPos<Term> unfolded = this.unfoldClauses(true, (SeqLike<Arg<Term>>)access.fieldArgs(), subst, (ImmutableSeq<Matching>)fieldDef.clauses);
                    if (unfolded != null) {
                        yield (Term)unfolded.data();
                    }
                    yield access;
                }
                case 5 -> {
                    CallTerm.Prim prim = (CallTerm.Prim)term2;
                    yield PrimDef.Factory.INSTANCE.unfold(prim.id(), prim, this.state);
                }
                case 6 -> {
                    CallTerm.Hole hole = (CallTerm.Hole)term2;
                    Meta def = hole.ref();
                    if (this.state == null || !this.state.metas().containsKey((Object)def)) {
                        yield hole;
                    }
                    Term body = (Term)this.state.metas().get((Object)def);
                    yield body.view().subst(Normalizer.buildSubst(def.fullTelescope(), hole.fullArgs())).normalize(this.state).commit();
                }
                case 7 -> {
                    RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term2;
                    yield metaPat.inline();
                }
                default -> {
                    Term t;
                    yield t = term2;
                }
            };
        }
    }

    public record Elevator(@NotNull TermView view, int ulift, MutableList<Var> boundVars) implements TermOps
    {
        public Elevator(@NotNull TermView view, int ulift) {
            this(view, ulift, (MutableList<Var>)MutableList.create());
        }

        @Override
        @NotNull
        public TermView lift(int shift) {
            return new Elevator(this.view, this.ulift + shift, this.boundVars);
        }

        @Override
        public Term pre(Term term) {
            Term term2 = term;
            Objects.requireNonNull(term2);
            Term term3 = term2;
            int n = 0;
            return this.view.pre(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntroTerm.Lambda.class, FormTerm.Pi.class, FormTerm.Sigma.class}, (Object)term3, n)) {
                case 0 -> {
                    IntroTerm.Lambda lambda = (IntroTerm.Lambda)term3;
                    this.boundVars.append((Object)lambda.param().ref());
                    yield lambda;
                }
                case 1 -> {
                    FormTerm.Pi pi = (FormTerm.Pi)term3;
                    this.boundVars.append((Object)pi.param().ref());
                    yield pi;
                }
                case 2 -> {
                    FormTerm.Sigma sigma = (FormTerm.Sigma)term3;
                    this.boundVars.appendAll((Iterable)sigma.params().map(Term.Param::ref));
                    yield sigma;
                }
                default -> term;
            });
        }

        @Override
        public Term post(Term term) {
            Term term2 = this.view.post(term);
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Univ.class, CallTerm.Struct.class, CallTerm.Data.class, CallTerm.Con.class, CallTerm.Fn.class, CallTerm.Prim.class, CallTerm.Hole.class, RefTerm.class, RefTerm.Field.class, Term.class}, (Object)term2, n)) {
                case 0 -> {
                    FormTerm.Univ univ = (FormTerm.Univ)term2;
                    yield new FormTerm.Univ(univ.lift() + this.ulift);
                }
                case 1 -> {
                    CallTerm.Struct struct = (CallTerm.Struct)term2;
                    yield new CallTerm.Struct((DefVar<StructDef, Decl.StructDecl>)struct.ref(), struct.ulift() + this.ulift, struct.args());
                }
                case 2 -> {
                    CallTerm.Data data = (CallTerm.Data)term2;
                    yield new CallTerm.Data((DefVar<DataDef, Decl.DataDecl>)data.ref(), data.ulift() + this.ulift, data.args());
                }
                case 3 -> {
                    CallTerm.Con con = (CallTerm.Con)term2;
                    CallTerm.ConHead head = con.head();
                    head = new CallTerm.ConHead(head.dataRef(), head.ref(), head.ulift() + this.ulift, head.dataArgs());
                    yield new CallTerm.Con(head, con.conArgs());
                }
                case 4 -> {
                    CallTerm.Fn fn = (CallTerm.Fn)term2;
                    yield new CallTerm.Fn((DefVar<FnDef, Decl.FnDecl>)fn.ref(), fn.ulift() + this.ulift, fn.args());
                }
                case 5 -> {
                    CallTerm.Prim prim = (CallTerm.Prim)term2;
                    yield new CallTerm.Prim((DefVar<PrimDef, Decl.PrimDecl>)prim.ref(), prim.ulift() + this.ulift, prim.args());
                }
                case 6 -> {
                    CallTerm.Hole hole = (CallTerm.Hole)term2;
                    yield new CallTerm.Hole(hole.ref(), hole.ulift() + this.ulift, hole.contextArgs(), hole.args());
                }
                case 7 -> {
                    RefTerm ref = (RefTerm)term2;
                    if (this.boundVars.contains((Object)ref.var())) {
                        yield ref;
                    }
                    yield new RefTerm(ref.var(), ref.lift() + this.ulift);
                }
                case 8 -> {
                    RefTerm.Field field = (RefTerm.Field)term2;
                    if (this.boundVars.contains(field.ref())) {
                        yield field;
                    }
                    yield new RefTerm.Field(field.ref(), field.lift() + this.ulift);
                }
                default -> {
                    Term misc;
                    yield misc = term2;
                }
            };
        }
    }

    public record Renamer(@NotNull TermView view, Subst subst) implements TermOps
    {
        public Renamer(@NotNull TermView view) {
            this(view, new Subst((MutableMap<Var, Term>)MutableMap.create()));
        }

        @NotNull
        private Term.Param handleBinder(@NotNull Term.Param param) {
            LocalVar v = param.renameVar();
            this.subst.addDirectly(param.ref(), new RefTerm(v, 0));
            return new Term.Param(v, param.type(), param.pattern(), param.explicit());
        }

        @Override
        public Term pre(Term term) {
            Term term2 = term;
            int n = 0;
            return this.view.pre(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntroTerm.Lambda.class, FormTerm.Pi.class, FormTerm.Sigma.class, Term.class}, (Object)term2, n)) {
                case 0 -> {
                    IntroTerm.Lambda lambda = (IntroTerm.Lambda)term2;
                    yield new IntroTerm.Lambda(this.handleBinder(lambda.param()), lambda.body());
                }
                case 1 -> {
                    FormTerm.Pi pi = (FormTerm.Pi)term2;
                    yield new FormTerm.Pi(this.handleBinder(pi.param()), pi.body());
                }
                case 2 -> {
                    FormTerm.Sigma sigma = (FormTerm.Sigma)term2;
                    yield new FormTerm.Sigma((ImmutableSeq<Term.Param>)sigma.params().map(this::handleBinder));
                }
                default -> {
                    Term misc;
                    yield misc = term2;
                }
            });
        }

        @Override
        public Term post(Term term) {
            Term term2 = this.view.post(term);
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, RefTerm.Field.class, Term.class}, (Object)term2, n)) {
                case 0 -> {
                    RefTerm ref = (RefTerm)term2;
                    yield (Term)this.subst.map().getOrDefault((Object)ref.var(), (Object)ref);
                }
                case 1 -> {
                    RefTerm.Field field = (RefTerm.Field)term2;
                    yield (Term)this.subst.map().getOrDefault(field.ref(), (Object)field);
                }
                default -> {
                    Term misc;
                    yield misc = term2;
                }
            };
        }
    }

    public record Subster(@NotNull TermView view, @NotNull Subst subst) implements TermOps
    {
        @Override
        @NotNull
        public TermView subst(@NotNull Subst subst) {
            return new Subster(this.view, subst.add(subst));
        }

        @Override
        public Term post(Term term) {
            Term term2 = this.view.post(term);
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, RefTerm.Field.class, Term.class}, (Object)term2, n)) {
                case 0 -> {
                    RefTerm ref = (RefTerm)term2;
                    yield (Term)this.subst.map().getOption((Object)ref.var()).map(Term::rename).getOrDefault((Object)ref);
                }
                case 1 -> {
                    RefTerm.Field field = (RefTerm.Field)term2;
                    yield (Term)this.subst.map().getOption(field.ref()).map(Term::rename).getOrDefault((Object)field);
                }
                default -> {
                    Term misc;
                    yield misc = term2;
                }
            };
        }
    }

    public record Mapper(@NotNull TermView view, @NotNull @NotNull Function<@NotNull Term, @NotNull Term> pre, @NotNull @NotNull Function<@NotNull Term, @NotNull Term> post) implements TermOps
    {
        @Override
        public TermView preMap(Function<Term, Term> f) {
            return new Mapper(this.view, this.pre.compose(f), this.post);
        }

        @Override
        public TermView postMap(Function<Term, Term> f) {
            return new Mapper(this.view, this.pre, f.compose(this.post));
        }

        @Override
        public Term pre(Term term) {
            return this.view.pre(this.pre.apply(term));
        }

        @Override
        public Term post(Term term) {
            return this.post.apply(this.view.post(term));
        }
    }
}

