/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.Decl;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.TermOps;
import org.aya.generic.Arg;
import org.aya.ref.DefVar;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.NotNull;

public interface TermView {
    @NotNull
    public Term initial();

    default public Term pre(Term term) {
        return term;
    }

    default public Term post(Term term) {
        return term;
    }

    private Term commit(Term term) {
        return this.post(this.traverse(this.pre(term)));
    }

    private Term.Param commit(Term.Param param) {
        Term type = this.commit(param.type());
        if (type == param.type()) {
            return param;
        }
        return new Term.Param(param, type);
    }

    private Arg<Term> commit(Arg<Term> arg) {
        Term term = this.commit(arg.term());
        if (term == arg.term()) {
            return arg;
        }
        return new Arg<Term>(term, arg.explicit());
    }

    private CallTerm.ConHead commit(CallTerm.ConHead head) {
        ImmutableSeq args = head.dataArgs().map(this::commit);
        if (args.sameElements(head.dataArgs(), true)) {
            return head;
        }
        return new CallTerm.ConHead(head.dataRef(), head.ref(), head.ulift(), (ImmutableSeq<Arg<Term>>)args);
    }

    private Term traverse(Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Pi.class, FormTerm.Sigma.class, FormTerm.Univ.class, IntroTerm.Lambda.class, IntroTerm.Tuple.class, IntroTerm.New.class, ElimTerm.App.class, ElimTerm.Proj.class, CallTerm.Struct.class, CallTerm.Data.class, CallTerm.Con.class, CallTerm.Fn.class, CallTerm.Access.class, CallTerm.Prim.class, CallTerm.Hole.class, RefTerm.Field.class, RefTerm.class, RefTerm.MetaPat.class, ErrorTerm.class}, (Object)term3, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                FormTerm.Pi pi = (FormTerm.Pi)term3;
                Term.Param param = this.commit(pi.param());
                Term body = this.commit(pi.body());
                if (param == pi.param() && body == pi.body()) {
                    yield pi;
                }
                yield new FormTerm.Pi(param, body);
            }
            case 1 -> {
                FormTerm.Sigma sigma = (FormTerm.Sigma)term3;
                ImmutableSeq params = sigma.params().map(this::commit);
                if (params.sameElements(sigma.params(), true)) {
                    yield sigma;
                }
                yield new FormTerm.Sigma((ImmutableSeq<Term.Param>)params);
            }
            case 2 -> {
                FormTerm.Univ univ;
                yield univ = (FormTerm.Univ)term3;
            }
            case 3 -> {
                IntroTerm.Lambda lambda = (IntroTerm.Lambda)term3;
                Term.Param param = this.commit(lambda.param());
                Term body = this.commit(lambda.body());
                if (param == lambda.param() && body == lambda.body()) {
                    yield lambda;
                }
                yield new IntroTerm.Lambda(param, body);
            }
            case 4 -> {
                IntroTerm.Tuple tuple = (IntroTerm.Tuple)term3;
                ImmutableSeq items = tuple.items().map(this::commit);
                if (items.sameElements(tuple.items(), true)) {
                    yield tuple;
                }
                yield new IntroTerm.Tuple((ImmutableSeq<Term>)items);
            }
            case 5 -> {
                IntroTerm.New neu = (IntroTerm.New)term3;
                Term struct = this.commit(neu.struct());
                ImmutableMap fields = ImmutableMap.from((Iterable)neu.params().view().map((k, v) -> Tuple.of((Object)k, (Object)this.commit((Term)v))));
                if (struct == neu.struct() && fields.valuesView().sameElements((Iterable)neu.params().valuesView())) {
                    yield neu;
                }
                yield new IntroTerm.New((CallTerm.Struct)struct, (ImmutableMap<DefVar<FieldDef, Decl.StructField>, Term>)fields);
            }
            case 6 -> {
                ElimTerm.App app = (ElimTerm.App)term3;
                Term function = this.commit(app.of());
                Arg<Term> arg = this.commit(app.arg());
                if (function == app.of() && arg == app.arg()) {
                    yield app;
                }
                yield CallTerm.make(function, arg);
            }
            case 7 -> {
                ElimTerm.Proj proj = (ElimTerm.Proj)term3;
                Term tuple = this.commit(proj.of());
                if (tuple == proj.of()) {
                    yield proj;
                }
                yield new ElimTerm.Proj(tuple, proj.ix());
            }
            case 8 -> {
                CallTerm.Struct struct = (CallTerm.Struct)term3;
                ImmutableSeq args = struct.args().map(this::commit);
                if (args.sameElements(struct.args(), true)) {
                    yield struct;
                }
                yield new CallTerm.Struct((DefVar<StructDef, Decl.StructDecl>)struct.ref(), struct.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 9 -> {
                CallTerm.Data data = (CallTerm.Data)term3;
                ImmutableSeq args = data.args().map(this::commit);
                if (args.sameElements(data.args(), true)) {
                    yield data;
                }
                yield new CallTerm.Data((DefVar<DataDef, Decl.DataDecl>)data.ref(), data.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 10 -> {
                CallTerm.Con con = (CallTerm.Con)term3;
                CallTerm.ConHead head = this.commit(con.head());
                ImmutableSeq args = con.conArgs().map(this::commit);
                if (head == con.head() && args.sameElements(con.conArgs(), true)) {
                    yield con;
                }
                yield new CallTerm.Con(head, (ImmutableSeq<Arg<Term>>)args);
            }
            case 11 -> {
                CallTerm.Fn fn = (CallTerm.Fn)term3;
                ImmutableSeq args = fn.args().map(this::commit);
                if (args.sameElements(fn.args(), true)) {
                    yield fn;
                }
                yield new CallTerm.Fn((DefVar<FnDef, Decl.FnDecl>)fn.ref(), fn.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 12 -> {
                CallTerm.Access access = (CallTerm.Access)term3;
                Term struct = this.commit(access.of());
                ImmutableSeq structArgs = access.structArgs().map(this::commit);
                ImmutableSeq fieldArgs = access.fieldArgs().map(this::commit);
                if (struct == access.of() && structArgs.sameElements(access.structArgs(), true) && fieldArgs.sameElements(access.fieldArgs(), true)) {
                    yield access;
                }
                yield new CallTerm.Access(struct, (DefVar<FieldDef, Decl.StructField>)access.ref(), (ImmutableSeq<Arg<Term>>)structArgs, (ImmutableSeq<Arg<Term>>)fieldArgs);
            }
            case 13 -> {
                CallTerm.Prim prim = (CallTerm.Prim)term3;
                ImmutableSeq args = prim.args().map(this::commit);
                if (args.sameElements(prim.args(), true)) {
                    yield prim;
                }
                yield new CallTerm.Prim((DefVar<PrimDef, Decl.PrimDecl>)prim.ref(), prim.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 14 -> {
                CallTerm.Hole hole = (CallTerm.Hole)term3;
                ImmutableSeq contextArgs = hole.contextArgs().map(this::commit);
                ImmutableSeq args = hole.args().map(this::commit);
                if (contextArgs.sameElements(hole.contextArgs(), true) && args.sameElements(hole.args(), true)) {
                    yield hole;
                }
                yield new CallTerm.Hole(hole.ref(), hole.ulift(), (ImmutableSeq<Arg<Term>>)contextArgs, (ImmutableSeq<Arg<Term>>)args);
            }
            case 15 -> {
                RefTerm.Field field = (RefTerm.Field)term3;
                yield field;
            }
            case 16 -> {
                RefTerm ref = (RefTerm)term3;
                yield ref;
            }
            case 17 -> {
                RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term3;
                yield metaPat;
            }
            case 18 -> {
                ErrorTerm error = (ErrorTerm)term3;
                yield error;
            }
        };
    }

    @NotNull
    default public Term commit() {
        return this.commit(this.initial());
    }

    @NotNull
    default public TermView lift(int shift) {
        return shift == 0 ? this : new TermOps.Elevator(this, shift);
    }

    @NotNull
    default public TermView subst(@NotNull Subst subst) {
        return subst.isEmpty() ? this : new TermOps.Subster(this, subst);
    }

    default public TermView normalize(TyckState state) {
        return new TermOps.Normalizer(this, state);
    }

    default public TermView postMap(Function<Term, Term> f) {
        return new TermOps.Mapper(this, t -> t, f);
    }

    default public TermView preMap(Function<Term, Term> f) {
        return new TermOps.Mapper(this, f, t -> t);
    }

    default public TermView map(Function<Term, Term> pre, Function<Term, Term> post) {
        return new TermOps.Mapper(this, pre, post);
    }

    default public TermView rename() {
        return new TermOps.Renamer(this);
    }
}

