/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.tuple.Unit;
import org.aya.core.term.CallTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermConsumer;
import org.aya.generic.Arg;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public interface VarConsumer<P>
extends TermConsumer<P> {
    @Override
    default public Unit visitRef(@NotNull RefTerm term, P p) {
        this.visitVar(term.var(), p);
        return Unit.unit();
    }

    @Override
    default public Unit visitFieldRef(@NotNull RefTerm.Field term, P p) {
        this.visitVar(term.ref(), p);
        return Unit.unit();
    }

    @Override
    default public Unit visitHole(@NotNull CallTerm.Hole term, P p) {
        this.visitVar(term.ref(), p);
        return TermConsumer.super.visitHole(term, p);
    }

    @Override
    default public Unit visitFnCall(@NotNull CallTerm.Fn fnCall, P p) {
        this.visitVar(fnCall.ref(), p);
        return TermConsumer.super.visitFnCall(fnCall, p);
    }

    @Override
    default public Unit visitPrimCall(@NotNull CallTerm.Prim prim, P p) {
        this.visitVar(prim.ref(), p);
        return TermConsumer.super.visitPrimCall(prim, p);
    }

    @Override
    default public Unit visitDataCall(@NotNull CallTerm.Data dataCall, P p) {
        this.visitVar(dataCall.ref(), p);
        return TermConsumer.super.visitDataCall(dataCall, p);
    }

    @Override
    default public Unit visitConCall(@NotNull CallTerm.Con conCall, P p) {
        this.visitVar(conCall.ref(), p);
        return TermConsumer.super.visitConCall(conCall, p);
    }

    @Override
    default public Unit visitStructCall(@NotNull CallTerm.Struct structCall, P p) {
        this.visitVar(structCall.ref(), p);
        return TermConsumer.super.visitStructCall(structCall, p);
    }

    @Contract(mutates="this,param2")
    public void visitVar(Var var1, P var2);

    public static final class ScopeChecker
    implements VarConsumer<Unit> {
        @NotNull
        public final ImmutableSeq<LocalVar> allowed;
        @NotNull
        public final MutableList<LocalVar> invalid;
        @NotNull
        public final MutableList<LocalVar> confused;
        @NotNull
        private final MutableList<LocalVar> bound = MutableList.create();

        @Contract(pure=true)
        public ScopeChecker(@NotNull ImmutableSeq<LocalVar> allowed) {
            this(allowed, (MutableList<LocalVar>)MutableList.create(), (MutableList<LocalVar>)MutableList.create());
        }

        @Contract(pure=true)
        private ScopeChecker(@NotNull ImmutableSeq<LocalVar> allowed, @NotNull MutableList<LocalVar> confused, @NotNull MutableList<LocalVar> invalid) {
            this.allowed = allowed;
            this.confused = confused;
            this.invalid = invalid;
        }

        @TestOnly
        @VisibleForTesting
        public boolean isCleared() {
            return this.bound.isEmpty();
        }

        @Override
        public Unit visitLam(@NotNull IntroTerm.Lambda term, Unit unit) {
            this.bound.append((Object)term.param().ref());
            VarConsumer.super.visitLam(term, unit);
            this.bound.removeAt(this.bound.size() - 1);
            return unit;
        }

        @Override
        public Unit visitPi(@NotNull FormTerm.Pi term, Unit unit) {
            this.bound.append((Object)term.param().ref());
            VarConsumer.super.visitPi(term, unit);
            this.bound.removeAt(this.bound.size() - 1);
            return unit;
        }

        @Override
        public Unit visitSigma(@NotNull FormTerm.Sigma term, Unit unit) {
            int start = this.bound.size();
            term.params().forEach(param -> {
                this.bound.append((Object)param.ref());
                param.type().accept(this, Unit.unit());
            });
            this.bound.removeInRange(start, start + term.params().size());
            return unit;
        }

        @Override
        public Unit visitHole(@NotNull CallTerm.Hole term, Unit unit) {
            new ScopeChecker((ImmutableSeq<LocalVar>)this.allowed.appendedAll(this.bound), this.confused, this.confused).visitArgs(unit, (SeqLike<Arg<Term>>)term.contextArgs());
            this.visitArgs(unit, (SeqLike<Arg<Term>>)term.args());
            return unit;
        }

        @Override
        @Contract(mutates="this")
        public void visitVar(Var v, Unit unit) {
            LocalVar local;
            if (v instanceof LocalVar && !this.allowed.contains((Object)(local = (LocalVar)v)) && !this.bound.contains((Object)local) && !this.invalid.contains((Object)local)) {
                this.invalid.append((Object)local);
            }
        }
    }

    public static final class UsageCounter
    implements VarConsumer<Unit> {
        @NotNull
        public final Var var;
        private int usageCount = 0;

        @Contract(pure=true)
        public UsageCounter(@NotNull Var var) {
            this.var = var;
        }

        @Contract(pure=true)
        public int usageCount() {
            return this.usageCount;
        }

        @Override
        @Contract(mutates="this")
        public void visitVar(Var usage, Unit unit) {
            if (this.var == usage) {
                ++this.usageCount;
            }
        }
    }
}

