/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.tuple.Unit;
import org.aya.core.Matching;
import org.aya.core.Meta;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.VarConsumer;
import org.aya.distill.BaseDistiller;
import org.aya.generic.Arg;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.ref.DefVar;
import org.aya.ref.Var;
import org.aya.util.distill.AyaDocile;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;

public class CoreDistiller
extends BaseDistiller<Term> {
    public CoreDistiller(@NotNull DistillerOptions options) {
        super(options);
    }

    @Override
    @NotNull
    public Doc term(@NotNull BaseDistiller.Outer outer, @NotNull Term preterm) {
        Term term = preterm;
        Objects.requireNonNull(term);
        Term term2 = term;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.class, CallTerm.Hole.class, IntroTerm.Tuple.class, CallTerm.Con.class, CallTerm.Fn.class, FormTerm.Sigma.class, IntroTerm.Lambda.class, FormTerm.Univ.class, IntroTerm.New.class, CallTerm.Access.class, RefTerm.MetaPat.class, ErrorTerm.class, ElimTerm.App.class, CallTerm.Prim.class, RefTerm.Field.class, ElimTerm.Proj.class, FormTerm.Pi.class, CallTerm.Struct.class, CallTerm.Data.class}, (Object)term2, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                RefTerm term = (RefTerm)term2;
                yield CoreDistiller.varDoc(term.var());
            }
            case 1 -> {
                CallTerm.Hole term = (CallTerm.Hole)term2;
                Meta name = term.ref();
                Doc inner = CoreDistiller.varDoc(name);
                Boolean showImplicits = (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs);
                if (((Boolean)this.options.map.get(DistillerOptions.Key.InlineMetas)).booleanValue()) {
                    yield this.visitCalls(false, inner, term.args().view(), outer, (boolean)showImplicits);
                }
                yield Doc.wrap((String)"{?", (String)"?}", (Doc)this.visitCalls(false, inner, term.args().view(), BaseDistiller.Outer.Free, (boolean)showImplicits));
            }
            case 2 -> {
                IntroTerm.Tuple term = (IntroTerm.Tuple)term2;
                yield Doc.parened((Doc)Doc.commaList((SeqLike)term.items().view().map(t -> this.term(BaseDistiller.Outer.Free, (Term)t))));
            }
            case 3 -> {
                CallTerm.Con conCall = (CallTerm.Con)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)conCall.ref(), CON_CALL, conCall.conArgs(), outer);
            }
            case 4 -> {
                CallTerm.Fn fnCall = (CallTerm.Fn)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)fnCall.ref(), FN_CALL, fnCall.args(), outer);
            }
            case 5 -> {
                FormTerm.Sigma term = (FormTerm.Sigma)term2;
                Term.Param last = (Term.Param)term.params().last();
                Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele(term.params().dropLast(1), last.type(), Term::findUsages), Doc.symbol((String)"**"), this.justType(last, BaseDistiller.Outer.Codomain)});
                yield CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
            }
            case 6 -> {
                Doc bodyDoc;
                CallTerm call;
                Var var17_24;
                IntroTerm.Lambda term = (IntroTerm.Lambda)term2;
                MutableList params = MutableList.of((Object)term.param());
                Term body = IntroTerm.Lambda.unwrap(term.body(), arg_0 -> ((MutableList)params).append(arg_0));
                if (body instanceof CallTerm && (var17_24 = (call = (CallTerm)body).ref()) instanceof DefVar) {
                    DefVar defVar = (DefVar)var17_24;
                    SeqView args = this.visibleArgsOf(call).view();
                    while (params.isNotEmpty() && args.isNotEmpty()) {
                        Term.Param param = (Term.Param)params.last();
                        if (!this.checkUneta((SeqView<Arg<Term>>)args, (Term.Param)params.last())) break;
                        args = args.dropLast(1);
                        params.removeLast();
                    }
                    if (call instanceof CallTerm.Access) {
                        CallTerm.Access access = (CallTerm.Access)call;
                        bodyDoc = this.visitAccessHead(access);
                    } else {
                        Style style = CoreDistiller.chooseStyle(defVar);
                        bodyDoc = style != null ? this.visitArgsCalls(defVar, style, args, BaseDistiller.Outer.Free) : this.visitCalls(false, CoreDistiller.varDoc(defVar), args, BaseDistiller.Outer.Free, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
                    }
                } else {
                    bodyDoc = this.term(BaseDistiller.Outer.Free, body);
                }
                if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue()) {
                    params.retainAll(Term.Param::explicit);
                }
                if (params.isEmpty()) {
                    yield bodyDoc;
                }
                MutableList list = MutableList.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")));
                params.forEach(param -> list.append((Object)this.lambdaParam((ParamLike<?>)param)));
                list.append((Object)Doc.symbol((String)"=>"));
                list.append((Object)bodyDoc);
                Doc doc = Doc.sep((SeqLike)list);
                yield CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.AppSpine);
            }
            case 7 -> {
                FormTerm.Univ term = (FormTerm.Univ)term2;
                Doc fn = Doc.styled((Style)KEYWORD, (String)"Type");
                if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowLevels)).booleanValue()) {
                    yield fn;
                }
                yield this.visitCalls(false, fn, (nest, t) -> t.toDoc(this.options), outer, SeqView.of(new Arg<AyaDocile>(o -> Doc.plain((String)String.valueOf(term.lift())), true)), (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs));
            }
            case 8 -> {
                IntroTerm.New newTerm = (IntroTerm.New)term2;
                yield Doc.cblock((Doc)Doc.styled((Style)KEYWORD, (String)"new"), (int)2, (Doc)Doc.vcat((SeqLike)newTerm.params().view().map((k, v) -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), CoreDistiller.linkRef(k, FIELD_CALL), Doc.symbol((String)"=>"), this.term(BaseDistiller.Outer.Free, (Term)v)})).toImmutableSeq()));
            }
            case 9 -> {
                CallTerm.Access term = (CallTerm.Access)term2;
                yield this.visitCalls(false, this.visitAccessHead(term), term.fieldArgs().view(), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
            }
            case 10 -> {
                RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term2;
                Pat.Meta ref = metaPat.ref();
                if (ref.solution().value == null) {
                    yield CoreDistiller.varDoc(ref.fakeBind());
                }
                yield this.pat(ref, outer);
            }
            case 11 -> {
                ErrorTerm term = (ErrorTerm)term2;
                Doc doc = term.description().toDoc(this.options);
                if (term.isReallyError()) {
                    yield Doc.angled((Doc)doc);
                }
                yield doc;
            }
            case 12 -> {
                ElimTerm.App term = (ElimTerm.App)term2;
                MutableList args = MutableList.of(term.arg());
                Term head = ElimTerm.unapp(term.of(), (MutableList<Arg<Term>>)args);
                if (head instanceof RefTerm.Field) {
                    RefTerm.Field fieldRef = (RefTerm.Field)head;
                    yield this.visitArgsCalls(fieldRef.ref(), FIELD_CALL, args, outer);
                }
                yield this.visitCalls(false, this.term(BaseDistiller.Outer.AppHead, head), args.view(), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
            }
            case 13 -> {
                CallTerm.Prim prim = (CallTerm.Prim)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)prim.ref(), FN_CALL, prim.args(), outer);
            }
            case 14 -> {
                RefTerm.Field term = (RefTerm.Field)term2;
                yield CoreDistiller.linkRef(term.ref(), FIELD_CALL);
            }
            case 15 -> {
                ElimTerm.Proj term = (ElimTerm.Proj)term2;
                yield Doc.cat((Doc[])new Doc[]{this.term(BaseDistiller.Outer.ProjHead, term.of()), Doc.symbol((String)"."), Doc.plain((String)String.valueOf(term.ix()))});
            }
            case 16 -> {
                FormTerm.Pi term = (FormTerm.Pi)term2;
                if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue() && !term.param().explicit()) {
                    yield this.term(outer, term.body());
                }
                if (term.body().findUsages(term.param().ref()) == 0) {
                    yield CoreDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{Doc.bracedUnless((Doc)term.param().type().toDoc(this.options), (boolean)term.param().explicit()), Doc.symbol((String)"->"), this.term(BaseDistiller.Outer.Codomain, term.body())}), BaseDistiller.Outer.BinOp);
                }
                MutableList params = MutableList.of((Object)term.param());
                Term body = FormTerm.unpi(term.body(), (MutableList<Term.Param>)params);
                Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), this.visitTele(params, body, Term::findUsages), Doc.symbol((String)"->"), this.term(BaseDistiller.Outer.Codomain, body)});
                yield CoreDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
            }
            case 17 -> {
                CallTerm.Struct structCall = (CallTerm.Struct)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)structCall.ref(), STRUCT_CALL, structCall.args(), outer);
            }
            case 18 -> {
                CallTerm.Data dataCall = (CallTerm.Data)term2;
                yield this.visitArgsCalls((DefVar<?, ?>)dataCall.ref(), DATA_CALL, dataCall.args(), outer);
            }
        };
    }

    private boolean checkUneta(SeqView<Arg<Term>> args, Term.Param param) {
        Arg arg = (Arg)args.last();
        if (arg.explicit() != param.explicit()) {
            return false;
        }
        Object t2 = arg.term();
        if (!(t2 instanceof RefTerm)) {
            return false;
        }
        RefTerm argRef = (RefTerm)t2;
        if (argRef.var() != param.ref()) {
            return false;
        }
        VarConsumer.UsageCounter counter = new VarConsumer.UsageCounter(param.ref());
        args.dropLast(1).forEach(t -> ((Term)t.term()).accept(counter, Unit.unit()));
        return counter.usageCount() == 0;
    }

    private ImmutableSeq<Arg<Term>> visibleArgsOf(CallTerm call) {
        ImmutableSeq<Arg<Term>> immutableSeq;
        if (call instanceof CallTerm.Con) {
            CallTerm.Con con = (CallTerm.Con)call;
            immutableSeq = con.conArgs();
        } else if (call instanceof CallTerm.Access) {
            CallTerm.Access access = (CallTerm.Access)call;
            immutableSeq = access.fieldArgs();
        } else {
            immutableSeq = call.args();
        }
        return immutableSeq;
    }

    @NotNull
    private Doc visitAccessHead(@NotNull CallTerm.Access term) {
        return Doc.cat((Doc[])new Doc[]{this.term(BaseDistiller.Outer.ProjHead, term.of()), Doc.symbol((String)"."), CoreDistiller.linkRef(term.ref(), FIELD_CALL)});
    }

    @NotNull
    public Doc pat(@NotNull Pat pat, BaseDistiller.Outer outer) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Meta.class, Pat.Bind.class, Pat.Prim.class, Pat.Ctor.class, Pat.Absurd.class, Pat.Tuple.class}, (Object)pat3, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                Pat sol = (Pat)meta.solution().value;
                if (sol != null) {
                    yield this.pat(sol, outer);
                }
                yield Doc.bracedUnless((Doc)CoreDistiller.linkDef(meta.fakeBind()), (boolean)meta.explicit());
            }
            case 1 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield Doc.bracedUnless((Doc)CoreDistiller.linkDef(bind.bind()), (boolean)bind.explicit());
            }
            case 2 -> {
                Pat.Prim prim = (Pat.Prim)pat3;
                yield Doc.bracedUnless((Doc)CoreDistiller.linkRef(prim.ref(), CON_CALL), (boolean)prim.explicit());
            }
            case 3 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                Doc ctorDoc = this.visitCalls(ctor.ref(), CON_CALL, ctor.params().view().map(Pat::toArg), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)));
                yield this.ctorDoc(outer, ctor.explicit(), ctorDoc, null, ctor.params().isEmpty());
            }
            case 4 -> {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                yield Doc.bracedUnless((Doc)Doc.styled((Style)KEYWORD, (String)"()"), (boolean)absurd.explicit());
            }
            case 5 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                yield Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.pats().view().map(sub -> this.pat((Pat)sub, BaseDistiller.Outer.Free))));
            }
        };
    }

    @NotNull
    public Doc def(@NotNull Def predef) {
        Def def = predef;
        Objects.requireNonNull(def);
        Def def2 = def;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FnDef.class, FieldDef.class, PrimDef.class, CtorDef.class, StructDef.class, DataDef.class}, (Object)def2, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                FnDef def = (FnDef)def2;
                MutableList line1 = MutableList.of((Object)Doc.styled((Style)KEYWORD, (String)"def"));
                def.modifiers.forEach(m -> line1.append((Object)Doc.styled((Style)KEYWORD, (String)m.keyword)));
                line1.appendAll((Object[])new Doc[]{CoreDistiller.linkDef(def.ref(), FN_CALL), this.visitTele(def.telescope()), Doc.symbol((String)":"), this.term(BaseDistiller.Outer.Free, def.result())});
                yield (Doc)def.body.fold(term -> Doc.sep((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.symbol((String)"=>"), this.term(BaseDistiller.Outer.Free, (Term)term)}), clauses -> Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)clauses))}));
            }
            case 1 -> {
                FieldDef field = (FieldDef)def2;
                yield Doc.cblock((Doc)Doc.sepNonEmpty((Doc[])new Doc[]{Doc.symbol((String)"|"), CoreDistiller.coe(field.coerce), CoreDistiller.linkDef(field.ref(), FIELD_CALL), this.visitTele(field.selfTele), Doc.symbol((String)":"), this.term(BaseDistiller.Outer.Free, field.result)}), (int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)field.clauses));
            }
            case 2 -> {
                PrimDef def = (PrimDef)def2;
                yield CoreDistiller.primDoc(def.ref());
            }
            case 3 -> {
                Doc line1;
                CtorDef ctor = (CtorDef)def2;
                Doc doc = Doc.sepNonEmpty((Doc[])new Doc[]{CoreDistiller.coe(ctor.coerce), CoreDistiller.linkDef(ctor.ref(), CON_CALL), this.visitTele(ctor.selfTele)});
                if (ctor.pats.isNotEmpty()) {
                    Doc pats = Doc.commaList((SeqLike)ctor.pats.view().map(pat -> this.pat((Pat)pat, BaseDistiller.Outer.Free)));
                    line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.symbol((String)"=>"), doc});
                } else {
                    line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
                }
                yield Doc.cblock((Doc)line1, (int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)ctor.clauses));
            }
            case 4 -> {
                StructDef def = (StructDef)def2;
                yield Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"struct"), CoreDistiller.linkDef(def.ref(), STRUCT_CALL), this.visitTele(def.telescope()), Doc.symbol((String)":"), this.term(BaseDistiller.Outer.Free, def.result())}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.fields.view().map(this::def)))});
            }
            case 5 -> {
                DataDef def = (DataDef)def2;
                MutableList line1 = MutableList.of((Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)CoreDistiller.linkDef(def.ref(), DATA_CALL), (Object)this.visitTele(def.telescope()), (Object)Doc.symbol((String)":"), (Object)this.term(BaseDistiller.Outer.Free, def.result()));
                yield Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.body.view().map(this::def)))});
            }
        };
    }

    @NotNull
    private Doc visitClauses(@NotNull ImmutableSeq<Matching> clauses) {
        return Doc.vcat((SeqLike)clauses.view().map(matching -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), matching.toDoc(this.options)})));
    }
}

