/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic;

import org.aya.ref.LocalVar;
import org.aya.util.error.Global;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Constants {
    @NotNull
    @NonNls
    public static final String ANONYMOUS_PREFIX = "_";
    @NotNull
    @NonNls
    public static final String GENERATED_POSTFIX = "'";
    @NotNull
    @NonNls
    public static final String SCOPE_SEPARATOR = "::";
    @NotNull
    @NonNls
    public static final String AYA_POSTFIX = ".aya";
    @NotNull
    @NonNls
    public static final String AYAC_POSTFIX = ".ayac";
    @NotNull
    @NonNls
    public static final String AYA_JSON = "aya.json";

    @NotNull
    public static LocalVar anonymous() {
        return new LocalVar(ANONYMOUS_PREFIX, SourcePos.NONE);
    }

    @NotNull
    public static LocalVar randomlyNamed(@NotNull SourcePos pos) {
        return new LocalVar(Constants.randomName(pos), pos);
    }

    @NotNull
    public static String randomName(@NotNull Object pos) {
        if (Global.NO_RANDOM_NAME) {
            return ANONYMOUS_PREFIX;
        }
        return ANONYMOUS_PREFIX + Math.abs(pos.hashCode()) % 10;
    }
}

