/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ref;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import org.aya.concrete.stmt.Signatured;
import org.aya.core.def.Def;
import org.aya.ref.Var;
import org.aya.util.binop.OpDecl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class DefVar<Core extends Def, Concrete extends Signatured>
implements Var {
    @NotNull
    private final String name;
    public @UnknownNullability Concrete concrete;
    public @UnknownNullability Core core;
    @Nullable
    public ImmutableSeq<String> module;
    @Nullable
    public OpDecl opDecl;
    @NotNull
    public MutableMap<ImmutableSeq<String>, OpDecl> opDeclRename = MutableMap.create();

    @Contract(pure=true)
    public boolean isInfix() {
        return this.opDecl != null && this.opDecl.opInfo() != null;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String name() {
        return this.name;
    }

    private DefVar(Concrete concrete, Core core, @NotNull String name) {
        this.concrete = concrete;
        this.core = core;
        this.name = name;
    }

    @NotNull
    public static <Core extends Def, Concrete extends Signatured> DefVar<Core, Concrete> concrete(@NotNull Concrete concrete, @NotNull String name) {
        return new DefVar<Object, Concrete>(concrete, null, name);
    }

    @NotNull
    public static <Core extends Def, Concrete extends Signatured> DefVar<Core, Concrete> empty(@NotNull String name) {
        return new DefVar<Object, Object>(null, null, name);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public boolean isInModule(@NotNull ImmutableSeq<String> moduleName) {
        ImmutableSeq<String> maybeSubmodule = this.module;
        if (maybeSubmodule == null) {
            return false;
        }
        if (maybeSubmodule.sizeLessThan(moduleName.size())) {
            return false;
        }
        return maybeSubmodule.sliceView(0, moduleName.size()).sameElements(moduleName);
    }
}

