/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.function.Consumer;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableStack;
import kala.tuple.Tuple2;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Signatured;
import org.aya.generic.ref.GeneralizedVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.resolve.context.BindContext;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.GeneralizedNotAvailableError;
import org.aya.tyck.error.FieldProblem;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ExprResolver(@NotNull Options options, @NotNull MutableMap<GeneralizedVar, Expr.Param> allowedGeneralizes, @NotNull MutableList<TyckOrder> reference, @NotNull MutableStack<Where> where, @Nullable Consumer<TyckUnit> parentAdd) implements Expr.Visitor<Context, Expr>
{
    @NotNull
    public static final Options RESTRICTIVE = new Options(false, false);
    @NotNull
    public static final Options LAX = new Options(true, true);

    public ExprResolver(@NotNull Options options) {
        this(options, (MutableMap<GeneralizedVar, Expr.Param>)MutableLinkedHashMap.of(), (MutableList<TyckOrder>)MutableList.create(), (MutableStack<Where>)MutableStack.create(), null);
    }

    @Override
    @NotNull
    public Expr visitRef(@NotNull Expr.RefExpr expr, Context p) {
        return expr;
    }

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Expr.Param> visitParams(@NotNull @NotNull ImmutableSeq<@NotNull Expr.Param> params, Context p) {
        return params.map(param -> {
            Expr oldType = param.type();
            Expr type = oldType.accept(this, p);
            if (type == oldType) {
                return param;
            }
            return new Expr.Param((Expr.Param)param, type);
        });
    }

    @Override
    @NotNull
    public Expr visitError(@NotNull Expr.ErrorExpr error, Context p) {
        return error;
    }

    @Override
    @NotNull
    public Expr visitRawUniv(@NotNull Expr.RawUnivExpr expr, Context p) {
        return expr;
    }

    @Override
    @NotNull
    public Expr visitMetaPat(@NotNull Expr.MetaPat metaPat, Context p) {
        return metaPat;
    }

    @Override
    @NotNull
    public Expr visitLift(@NotNull Expr.LiftExpr expr, Context p) {
        Expr mapped = expr.expr().accept(this, p);
        if (mapped == expr.expr()) {
            return expr;
        }
        return new Expr.LiftExpr(expr.sourcePos(), mapped, expr.lift());
    }

    @Override
    @NotNull
    public Expr visitUniv(@NotNull Expr.UnivExpr expr, Context p) {
        return expr;
    }

    @Override
    @NotNull
    public Expr visitApp(@NotNull Expr.AppExpr expr, Context p) {
        Expr function = expr.function().accept(this, p);
        Expr.NamedArg argument = expr.argument();
        Expr argExpr = argument.expr().accept(this, p);
        if (function == expr.function() && argExpr == argument.expr()) {
            return expr;
        }
        Expr.NamedArg newArg = new Expr.NamedArg(argument.explicit(), argument.name(), argExpr);
        return new Expr.AppExpr(expr.sourcePos(), function, newArg);
    }

    @Override
    @NotNull
    public Expr visitTup(@NotNull Expr.TupExpr expr, Context p) {
        ImmutableSeq items = expr.items().map(item -> item.accept(this, p));
        if (items.sameElements(expr.items(), true)) {
            return expr;
        }
        return new Expr.TupExpr(expr.sourcePos(), (ImmutableSeq<Expr>)items);
    }

    @Override
    @NotNull
    public Expr visitNew(@NotNull Expr.NewExpr expr, Context p) {
        Expr struct = expr.struct().accept(this, p);
        ImmutableSeq fields = expr.fields().map(t -> this.visitField((Expr.Field)t, p));
        if (expr.struct() == struct && fields.sameElements(expr.fields(), true)) {
            return expr;
        }
        return new Expr.NewExpr(expr.sourcePos(), struct, (ImmutableSeq<Expr.Field>)fields);
    }

    @Override
    @NotNull
    public Expr visitLitInt(@NotNull Expr.LitIntExpr expr, Context p) {
        return expr;
    }

    @Override
    @NotNull
    public Expr visitLitString(@NotNull Expr.LitStringExpr expr, Context p) {
        return expr;
    }

    @Override
    @NotNull
    public Expr visitBinOpSeq(@NotNull Expr.BinOpSeq binOpSeq, Context p) {
        return new Expr.BinOpSeq(binOpSeq.sourcePos(), (ImmutableSeq<Expr.NamedArg>)binOpSeq.seq().map(e -> new Expr.NamedArg(e.explicit(), e.name(), e.expr().accept(this, p))));
    }

    public void enterHead() {
        this.where.push((Object)Where.Head);
        this.reference.clear();
    }

    public void enterBody() {
        this.where.push((Object)Where.Body);
        this.reference.clear();
    }

    private void addReference(@NotNull TyckUnit unit) {
        if (this.parentAdd != null) {
            this.parentAdd.accept(unit);
        }
        if (this.where.isEmpty()) {
            throw new IllegalStateException("where am I?");
        }
        if (this.where.peek() == Where.Head) {
            this.reference.append((Object)new TyckOrder.Head(unit));
            this.reference.append((Object)new TyckOrder.Body(unit));
        } else {
            this.reference.append((Object)new TyckOrder.Body(unit));
        }
    }

    @NotNull
    public ExprResolver member(@NotNull TyckUnit decl) {
        return new ExprResolver(RESTRICTIVE, this.allowedGeneralizes, (MutableList<TyckOrder>)MutableList.of((Object)new TyckOrder.Head(decl)), (MutableStack<Where>)MutableStack.create(), this::addReference);
    }

    @NotNull
    public ExprResolver body() {
        return new ExprResolver(RESTRICTIVE, this.allowedGeneralizes, this.reference, (MutableStack<Where>)MutableStack.create(), this::addReference);
    }

    @Override
    @NotNull
    public Expr visitUnresolved(@NotNull Expr.UnresolvedExpr expr, Context ctx) {
        SourcePos sourcePos = expr.sourcePos();
        Var var = ctx.get(expr.name());
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, Var.class}, (Object)var, n)) {
            case 0 -> {
                GeneralizedVar generalized = (GeneralizedVar)var;
                if (this.options.allowGeneralized) {
                    if (!this.allowedGeneralizes.containsKey((Object)generalized)) {
                        Generalize owner = generalized.owner;
                        if (!$assertionsDisabled && owner == null) {
                            throw new AssertionError((Object)"Sanity check");
                        }
                        this.allowedGeneralizes.put((Object)generalized, (Object)owner.toExpr(false, generalized.toLocal()));
                        this.addReference(owner);
                    }
                } else if (!this.allowedGeneralizes.containsKey((Object)generalized)) {
                    this.generalizedUnavailable(ctx, sourcePos, generalized);
                }
                yield new Expr.RefExpr(sourcePos, ((Expr.Param)this.allowedGeneralizes.get((Object)generalized)).ref());
            }
            case 1 -> {
                DefVar ref = (DefVar)var;
                Object var8_9 = ref.concrete;
                int var9_11 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Signatured.class}, var8_9, var9_11)) {
                    case -1: {
                        if (!$assertionsDisabled && ref.core == null) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    default: {
                        Object unit = var8_9;
                        this.addReference((TyckUnit)unit);
                    }
                }
                yield new Expr.RefExpr(sourcePos, ref);
            }
            default -> {
                Var var = var;
                yield new Expr.RefExpr(sourcePos, var);
            }
        };
    }

    @Override
    @NotNull
    public Expr visitProj(@NotNull Expr.ProjExpr expr, Context context) {
        Expr tup = expr.tup().accept(this, context);
        if (expr.ix().isLeft()) {
            return new Expr.ProjExpr(expr.sourcePos(), tup, expr.ix(), expr.resolvedIx(), expr.theCore());
        }
        QualifiedID projName = (QualifiedID)expr.ix().getRightValue();
        Var resolvedIx = context.getMaybe(projName);
        if (resolvedIx == null) {
            context.reportAndThrow(new FieldProblem.UnknownField(expr, projName.join()));
        }
        return new Expr.ProjExpr(expr.sourcePos(), tup, expr.ix(), resolvedIx, expr.theCore());
    }

    private void generalizedUnavailable(Context ctx, SourcePos refExpr, Var var) {
        ctx.reporter().report((Problem)new GeneralizedNotAvailableError(refExpr, var));
        throw new Context.ResolvingInterruptedException();
    }

    @NotNull
    public Tuple2<Expr.Param, Context> visitParam(@NotNull Expr.Param param, Context ctx) {
        Expr type = param.type().accept(this, ctx);
        return Tuple2.of((Object)new Expr.Param(param, type), (Object)ctx.bind(param.ref(), param.sourcePos()));
    }

    @Contract(pure=true)
    @NotNull
    public Tuple2<SeqView<Expr.Param>, Context> resolveParams(@NotNull SeqLike<Expr.Param> params, Context ctx) {
        if (params.isEmpty()) {
            return Tuple2.of((Object)SeqView.empty(), (Object)ctx);
        }
        Expr.Param first = (Expr.Param)params.first();
        Expr type = first.type().accept(this, ctx);
        BindContext newCtx = ctx.bind(first.ref(), first.sourcePos());
        Tuple2<SeqView<Expr.Param>, Context> result = this.resolveParams((SeqLike<Expr.Param>)params.view().drop(1), newCtx);
        return Tuple2.of((Object)((SeqView)result._1).prepended((Object)new Expr.Param(first, type)), (Object)((Context)result._2));
    }

    @Override
    @NotNull
    public Expr visitLam(@NotNull Expr.LamExpr expr, Context ctx) {
        Tuple2<Expr.Param, Context> param = this.visitParam(expr.param(), ctx);
        Expr body = expr.body().accept(this, (Context)param._2);
        return new Expr.LamExpr(expr.sourcePos(), (Expr.Param)param._1, body);
    }

    public @NotNull Expr.Field visitField(@NotNull Expr.Field t, Context context) {
        for (WithPos binding : t.bindings()) {
            context = context.bind((LocalVar)binding.data(), binding.sourcePos());
        }
        Expr accept = t.body().accept(this, context);
        if (accept == t.body()) {
            return t;
        }
        return new Expr.Field(t.name(), t.bindings(), accept, t.resolvedField());
    }

    @Override
    @NotNull
    public Expr visitPi(@NotNull Expr.PiExpr expr, Context ctx) {
        Tuple2<Expr.Param, Context> param = this.visitParam(expr.param(), ctx);
        Expr last = expr.last().accept(this, (Context)param._2);
        return new Expr.PiExpr(expr.sourcePos(), expr.co(), (Expr.Param)param._1, last);
    }

    @Override
    @NotNull
    public Expr visitSigma(@NotNull Expr.SigmaExpr expr, Context ctx) {
        Tuple2<SeqView<Expr.Param>, Context> params = this.resolveParams((SeqLike<Expr.Param>)expr.params(), ctx);
        return new Expr.SigmaExpr(expr.sourcePos(), expr.co(), (ImmutableSeq<Expr.Param>)((SeqView)params._1).toImmutableSeq());
    }

    @Override
    @NotNull
    public Expr visitHole(@NotNull Expr.HoleExpr expr, Context context) {
        Expr h;
        expr.accessibleLocal().set((Object)context.collect((MutableList<LocalVar>)MutableList.create()).toImmutableSeq());
        Expr expr2 = h = expr.filling() != null ? expr.filling().accept(this, context) : null;
        if (h == expr.filling()) {
            return expr;
        }
        return new Expr.HoleExpr(expr.sourcePos(), expr.explicit(), h);
    }

    public record Options(boolean allowLevels, boolean allowGeneralized) {
    }

    static enum Where {
        Head,
        Body;

    }
}

