/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.value.Ref;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.error.OperatorProblem;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.CtorDef;
import org.aya.core.def.PrimDef;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.UnknownOperatorError;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StmtResolver {
    public static void resolveStmt(@NotNull @NotNull SeqLike<@NotNull Stmt> stmt, @NotNull ResolveInfo info) {
        stmt.forEach(s -> StmtResolver.resolveStmt(s, info));
    }

    public static void resolveStmt(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, Decl.DataDecl.class, Decl.FnDecl.class, Decl.StructDecl.class, Decl.PrimDecl.class, Remark.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveStmt(mod.contents(), info);
                break;
            }
            case 1: {
                Decl.DataDecl decl = (Decl.DataDecl)stmt3;
                Tuple2<ExprResolver, Context> local = StmtResolver.resolveDeclSignature(decl, ExprResolver.LAX);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl), (ExprResolver)local._1);
                ((ExprResolver)local._1).enterBody();
                decl.body.forEach(ctor -> {
                    ExprResolver bodyResolver = ((ExprResolver)local._1).member(decl);
                    bodyResolver.enterHead();
                    Ref localCtxWithPat = new Ref((Object)((Context)local._2));
                    ctor.patterns = ctor.patterns.map(pattern -> StmtResolver.subpatterns((Ref<Context>)localCtxWithPat, pattern));
                    Tuple2<SeqView<Expr.Param>, Context> ctorLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)ctor.telescope, (Context)localCtxWithPat.value);
                    ctor.telescope = ((SeqView)ctorLocal._1).toImmutableSeq();
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head((TyckUnit)ctor), (SeqView<TyckOrder>)bodyResolver.reference().view().appended((Object)new TyckOrder.Head(decl)));
                    bodyResolver.enterBody();
                    ctor.clauses = ctor.clauses.map(clause -> StmtResolver.matchy(clause, (Context)ctorLocal._2, bodyResolver));
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)ctor), bodyResolver);
                });
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl), (SeqView<TyckOrder>)((ExprResolver)local._1).reference().view().concat((SeqLike)decl.body.map(TyckOrder.Body::new)));
                break;
            }
            case 2: {
                Decl.FnDecl decl = (Decl.FnDecl)stmt3;
                Tuple2<ExprResolver, Context> local = StmtResolver.resolveDeclSignature(decl, ExprResolver.LAX);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl), (ExprResolver)local._1);
                ((ExprResolver)local._1).enterBody();
                ExprResolver bodyResolver = ((ExprResolver)local._1).body();
                bodyResolver.enterBody();
                decl.body = decl.body.map(expr -> expr.accept(bodyResolver, local._2), pats -> pats.map(clause -> StmtResolver.matchy(clause, (Context)local._2, bodyResolver)));
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl), (ExprResolver)local._1);
                break;
            }
            case 3: {
                Decl.StructDecl decl = (Decl.StructDecl)stmt3;
                Tuple2<ExprResolver, Context> local = StmtResolver.resolveDeclSignature(decl, ExprResolver.LAX);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl), (ExprResolver)local._1);
                ((ExprResolver)local._1).enterBody();
                decl.fields.forEach(field -> {
                    ExprResolver bodyResolver = ((ExprResolver)local._1).member(decl);
                    bodyResolver.enterHead();
                    Tuple2<SeqView<Expr.Param>, Context> fieldLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)field.telescope, (Context)local._2);
                    field.telescope = ((SeqView)fieldLocal._1).toImmutableSeq();
                    field.result = field.result.accept(bodyResolver, (Context)fieldLocal._2);
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head((TyckUnit)field), (SeqView<TyckOrder>)bodyResolver.reference().view().appended((Object)new TyckOrder.Head(decl)));
                    bodyResolver.enterBody();
                    field.body = field.body.map(e -> e.accept(bodyResolver, fieldLocal._2));
                    field.clauses = field.clauses.map(clause -> StmtResolver.matchy(clause, (Context)fieldLocal._2, bodyResolver));
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)field), bodyResolver);
                });
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl), (SeqView<TyckOrder>)((ExprResolver)local._1).reference().view().concat((SeqLike)decl.fields.map(TyckOrder.Body::new)));
                break;
            }
            case 4: {
                Decl.PrimDecl decl = (Decl.PrimDecl)stmt3;
                ExprResolver resolver = (ExprResolver)StmtResolver.resolveDeclSignature((Decl)decl, (ExprResolver.Options)ExprResolver.RESTRICTIVE)._1;
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl), resolver);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl), (SeqView<TyckOrder>)SeqView.empty());
                break;
            }
            case 5: {
                Remark remark = (Remark)stmt3;
                info.depGraph().sucMut((Object)new TyckOrder.Body(remark)).appendAll(remark.doResolve(info));
                break;
            }
            case 6: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 7: {
                Generalize variables = (Generalize)stmt3;
                ExprResolver resolver = new ExprResolver(ExprResolver.RESTRICTIVE);
                resolver.enterBody();
                variables.type = variables.type.accept(resolver, variables.ctx);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(variables), resolver);
            }
        }
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, SeqView<TyckOrder> refs) {
        info.depGraph().sucMut((Object)decl).appendAll((Iterable)refs.filter(unit -> unit.unit().needTyck(info.thisModule().moduleName())));
        if (decl instanceof TyckOrder.Body) {
            info.depGraph().sucMut((Object)decl).append((Object)new TyckOrder.Head(decl.unit()));
        }
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, ExprResolver resolver) {
        StmtResolver.addReferences(info, decl, (SeqView<TyckOrder>)resolver.reference().view());
    }

    @NotNull
    private static Tuple2<ExprResolver, Context> resolveDeclSignature(@NotNull Decl decl, @NotNull ExprResolver.Options options) {
        ExprResolver resolver = new ExprResolver(options);
        resolver.enterHead();
        Tuple2<SeqView<Expr.Param>, Context> local = resolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = ((SeqView)local._1).prependedAll((Iterable)resolver.allowedGeneralizes().valuesView()).toImmutableSeq();
        decl.result = decl.result.accept(resolver, (Context)local._2);
        return Tuple.of((Object)resolver, (Object)((Context)local._2));
    }

    public static void visitBind(@NotNull DefVar<?, ?> selfDef, @NotNull BindBlock bind, @NotNull ResolveInfo info) {
        AyaBinOpSet opSet = info.opSet();
        OpDecl self = selfDef.opDecl;
        if (self == null && bind != BindBlock.EMPTY) {
            opSet.reporter.report((Problem)new OperatorProblem.NotOperator(((Signatured)selfDef.concrete).sourcePos(), selfDef.name()));
            throw new Context.ResolvingInterruptedException();
        }
        StmtResolver.bind(bind, opSet, self);
    }

    private static void bind(@NotNull BindBlock bindBlock, AyaBinOpSet opSet, OpDecl self) {
        if (bindBlock == BindBlock.EMPTY) {
            return;
        }
        Context ctx = (Context)bindBlock.context().value;
        if (!1.$assertionsDisabled && ctx == null) {
            throw new AssertionError((Object)"no shallow resolver?");
        }
        bindBlock.resolvedLoosers().value = bindBlock.loosers().map(looser -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Looser, looser));
        bindBlock.resolvedTighters().value = bindBlock.tighters().map(tighter -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Tighter, tighter));
    }

    @NotNull
    private static DefVar<?, ?> bind(@NotNull OpDecl self, @NotNull AyaBinOpSet opSet, @NotNull Context ctx, @NotNull OpDecl.BindPred pred, @NotNull QualifiedID id) throws Context.ResolvingInterruptedException {
        Var var = ctx.get(id);
        if (var instanceof DefVar) {
            DefVar defVar = (DefVar)var;
            OpDecl opDecl = defVar.opDecl;
            if (opDecl != null) {
                opSet.bind(self, pred, opDecl, id.sourcePos());
                return defVar;
            }
        }
        opSet.reporter.report((Problem)new UnknownOperatorError(id.sourcePos(), id.join()));
        throw new Context.ResolvingInterruptedException();
    }

    public static void resolveBind(@NotNull @NotNull SeqLike<@NotNull Stmt> contents, @NotNull ResolveInfo info) {
        contents.forEach(s -> StmtResolver.resolveBind(s, info));
        info.bindBlockRename().forEach((opDecl, bindBlock) -> StmtResolver.bind(bindBlock, info.opSet(), opDecl));
    }

    public static void resolveBind(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, Decl.DataDecl.class, Decl.StructDecl.class, Decl.FnDecl.class, Remark.class, Command.class, Decl.PrimDecl.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveBind(mod.contents(), info);
                break;
            }
            case 1: {
                Decl.DataDecl decl = (Decl.DataDecl)stmt3;
                decl.body.forEach(ctor -> StmtResolver.visitBind(ctor.ref, ctor.bindBlock, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 2: {
                Decl.StructDecl decl = (Decl.StructDecl)stmt3;
                decl.fields.forEach(field -> StmtResolver.visitBind(field.ref, field.bindBlock, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 3: {
                Decl.FnDecl decl = (Decl.FnDecl)stmt3;
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 4: {
                Remark remark = (Remark)stmt3;
                break;
            }
            case 5: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 6: {
                Decl.PrimDecl decl = (Decl.PrimDecl)stmt3;
                break;
            }
            case 7: {
                Generalize generalize = (Generalize)stmt3;
            }
        }
    }

    public static Pattern.Clause matchy(@NotNull Pattern.Clause match, @NotNull Context context, @NotNull ExprResolver bodyResolver) {
        Ref ctx = new Ref((Object)context);
        ImmutableSeq pats = match.patterns.map(pat -> StmtResolver.subpatterns((Ref<Context>)ctx, pat));
        return new Pattern.Clause(match.sourcePos, (ImmutableSeq<Pattern>)pats, (Option<Expr>)match.expr.map(e -> e.accept(bodyResolver, ctx.value)));
    }

    @NotNull
    public static Pattern subpatterns(Ref<Context> ctx, Pattern pat) {
        Tuple2<Context, Pattern> res = StmtResolver.resolve(pat, (Context)ctx.value);
        ctx.value = res._1;
        return (Pattern)res._2;
    }

    public static Context bindAs(LocalVar as, Context ctx, SourcePos sourcePos) {
        return as != null ? ctx.bind(as, sourcePos) : ctx;
    }

    public static Tuple2<Context, Pattern> resolve(@NotNull Pattern pattern, Context context) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Tuple.class, Pattern.Bind.class, Pattern.BinOpSeq.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                Ref newCtx = new Ref((Object)context);
                ImmutableSeq patterns = tuple.patterns().map(p -> StmtResolver.subpatterns((Ref<Context>)newCtx, p));
                yield Tuple.of((Object)StmtResolver.bindAs(tuple.as(), (Context)newCtx.value, tuple.sourcePos()), (Object)new Pattern.Tuple(tuple.sourcePos(), tuple.explicit(), (ImmutableSeq<Pattern>)patterns, tuple.as()));
            }
            case 1 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern3;
                DefVar<?, ?> maybe = StmtResolver.findPatternDef(context, bind.sourcePos(), bind.bind().name());
                if (maybe != null) {
                    yield Tuple.of((Object)context, (Object)new Pattern.Ctor(bind, maybe));
                }
                yield Tuple.of((Object)context.bind(bind.bind(), bind.sourcePos(), var -> false), (Object)bind);
            }
            case 2 -> {
                Pattern.BinOpSeq seq = (Pattern.BinOpSeq)pattern3;
                Ref newCtx = new Ref((Object)context);
                ImmutableSeq pats = seq.seq().map(p -> StmtResolver.subpatterns((Ref<Context>)newCtx, p));
                yield Tuple.of((Object)StmtResolver.bindAs(seq.as(), (Context)newCtx.value, seq.sourcePos()), (Object)new Pattern.BinOpSeq(seq.sourcePos(), (ImmutableSeq<Pattern>)pats, seq.as(), seq.explicit()));
            }
            default -> Tuple.of((Object)context, (Object)pattern);
        };
    }

    @Nullable
    public static DefVar<?, ?> findPatternDef(Context context, SourcePos namePos, String name) {
        return context.iterate(c -> {
            Var maybe = c.getUnqualifiedLocalMaybe(name, namePos);
            if (!(maybe instanceof DefVar)) {
                return null;
            }
            DefVar defVar = (DefVar)maybe;
            if (defVar.core instanceof CtorDef || defVar.concrete instanceof Decl.DataCtor) {
                return defVar;
            }
            if (defVar.core instanceof PrimDef || defVar.concrete instanceof Decl.PrimDecl) {
                return defVar;
            }
            return null;
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

