/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.Expr;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.PrimDef;
import org.aya.generic.ref.GeneralizedVar;
import org.aya.ref.Bind;
import org.aya.ref.DefVar;
import org.aya.ref.Var;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.ModNotFoundError;
import org.aya.resolve.error.PrimDependencyError;
import org.aya.resolve.error.RedefinitionPrimError;
import org.aya.resolve.error.UnknownPrimError;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;

public record StmtShallowResolver(@NotNull ModuleLoader loader, @NotNull ResolveInfo resolveInfo) {
    public void resolveStmt(@NotNull SeqLike<Stmt> stmts, ModuleContext context) {
        stmts.forEach(stmt -> this.resolveStmt((Stmt)stmt, context));
    }

    public void resolveStmt(@NotNull Stmt stmt, @NotNull ModuleContext context) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, Command.Import.class, Command.Open.class, Remark.class, Generalize.class, Decl.DataDecl.class, Decl.StructDecl.class, Decl.FnDecl.class, Decl.PrimDecl.class}, (Object)stmt3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                PhysicalModuleContext newCtx = context.derive(mod.name());
                this.resolveStmt((SeqLike<Stmt>)mod.contents(), (ModuleContext)newCtx);
                context.importModules((ImmutableSeq<String>)ImmutableSeq.of((Object)mod.name()), mod.accessibility(), newCtx.exports, mod.sourcePos());
                break;
            }
            case 1: {
                Command.Import cmd = (Command.Import)stmt3;
                ImmutableSeq ids = cmd.path().ids();
                ResolveInfo success = this.loader.load(ids);
                if (success == null) {
                    context.reportAndThrow(new ModNotFoundError((Seq<String>)cmd.path().ids(), cmd.sourcePos()));
                }
                PhysicalModuleContext mod = (PhysicalModuleContext)success.thisModule();
                String as = cmd.asName();
                ImmutableSeq importedName = as != null ? ImmutableSeq.of((Object)as) : ids;
                context.importModules((ImmutableSeq<String>)importedName, Stmt.Accessibility.Private, mod.exports, cmd.sourcePos());
                this.resolveInfo.imports().put((Object)importedName, (Object)success);
                break;
            }
            case 2: {
                Command.Open cmd = (Command.Open)stmt3;
                ImmutableSeq<String> mod = cmd.path().ids();
                Stmt.Accessibility acc = cmd.accessibility();
                Command.Open.UseHide useHide = cmd.useHide();
                ModuleContext ctx = cmd.openExample() ? this.exampleContext(context) : context;
                ctx.openModule(mod, acc, useHide::uses, useHide.renaming(), cmd.sourcePos());
                Option modInfo = this.resolveInfo.imports().getOption(mod);
                if (modInfo.isDefined()) {
                    if (acc == Stmt.Accessibility.Public) {
                        this.resolveInfo.reExports().append(mod);
                    }
                    this.resolveInfo.opSet().importBind(((ResolveInfo)modInfo.get()).opSet(), cmd.sourcePos());
                }
                if (useHide.strategy() != Command.Open.UseHide.Strategy.Using) break;
                useHide.list().forEach(use -> {
                    if (use.asAssoc() == Assoc.Invalid) {
                        return;
                    }
                    Var symbol = ctx.getQualifiedLocalMaybe(mod, use.id(), SourcePos.NONE);
                    assert (symbol instanceof DefVar);
                    DefVar defVar = (DefVar)symbol;
                    int argc = defVar.core != null ? defVar.core.telescope().count(Bind::explicit) : ((Signatured)defVar.concrete).telescope.count(Expr.Param::explicit);
                    OpDecl rename = () -> new OpDecl.OpInfo(use.asName(), use.asAssoc(), argc);
                    defVar.opDeclRename.put(this.resolveInfo.thisModule().moduleName(), (Object)rename);
                    BindBlock bind = use.asBind();
                    if (bind != BindBlock.EMPTY) {
                        bind.context().value = ctx;
                        this.resolveInfo.bindBlockRename().put((Object)rename, (Object)bind);
                    }
                });
                break;
            }
            case 3: {
                Remark remark = (Remark)stmt3;
                remark.ctx = context;
                break;
            }
            case 4: {
                Generalize variables = (Generalize)stmt3;
                variables.ctx = context;
                for (GeneralizedVar variable : variables.variables) {
                    context.addGlobalSimple(variables.accessibility(), variable, variable.sourcePos);
                }
                break;
            }
            case 5: {
                Decl.DataDecl decl = (Decl.DataDecl)stmt3;
                ModuleContext ctx = this.resolveDecl(decl, context);
                ModuleContext innerCtx = this.resolveChildren(decl, ctx, d -> d.body.view(), this::resolveCtor);
                this.resolveOpInfo(decl, innerCtx);
                break;
            }
            case 6: {
                Decl.StructDecl decl = (Decl.StructDecl)stmt3;
                ModuleContext ctx = this.resolveDecl(decl, context);
                ModuleContext innerCtx = this.resolveChildren(decl, ctx, s -> s.fields.view(), this::resolveField);
                this.resolveOpInfo(decl, innerCtx);
                break;
            }
            case 7: {
                Decl.FnDecl decl = (Decl.FnDecl)stmt3;
                ModuleContext ctx = this.resolveDecl(decl, context);
                this.resolveOpInfo(decl, ctx);
                break;
            }
            case 8: {
                Option<ImmutableSeq<PrimDef.ID>> lack;
                Decl.PrimDecl decl = (Decl.PrimDecl)stmt3;
                String name = decl.ref.name();
                SourcePos sourcePos = decl.sourcePos;
                PrimDef.ID primID = PrimDef.ID.find(name);
                if (primID == null) {
                    context.reportAndThrow(new UnknownPrimError(sourcePos, name));
                }
                if ((lack = PrimDef.Factory.INSTANCE.checkDependency(primID)).isNotEmpty() && ((ImmutableSeq)lack.get()).isNotEmpty()) {
                    context.reportAndThrow(new PrimDependencyError(name, (ImmutableSeq<PrimDef.ID>)((ImmutableSeq)lack.get()), sourcePos));
                } else if (PrimDef.Factory.INSTANCE.have(primID)) {
                    context.reportAndThrow(new RedefinitionPrimError(name, sourcePos));
                }
                PrimDef.Factory.INSTANCE.factory(primID, decl.ref);
                this.resolveDecl(decl, context);
            }
        }
    }

    private <D extends Decl, Child extends Signatured> ModuleContext resolveChildren(@NotNull D decl, @NotNull ModuleContext context, @NotNull Function<D, SeqView<Child>> childrenGet, @NotNull BiConsumer<Child, ModuleContext> childResolver) {
        PhysicalModuleContext innerCtx = context.derive(decl.ref().name());
        SeqView children = childrenGet.apply(decl).map(child -> {
            childResolver.accept(child, innerCtx);
            return Tuple.of((Object)child.ref().name(), child.ref());
        });
        context.importModules((ImmutableSeq<String>)ImmutableSeq.of((Object)decl.ref().name()), decl.accessibility(), (MutableMap<ImmutableSeq<String>, MutableMap<String, Var>>)MutableHashMap.of(Context.TOP_LEVEL_MOD_NAME, (Object)MutableHashMap.from((Iterable)children)), decl.sourcePos());
        decl.ctx = innerCtx;
        return innerCtx;
    }

    private void resolveOpInfo(@NotNull Signatured signatured, @NotNull ModuleContext context) {
        BindBlock bind = signatured.bindBlock;
        if (bind != BindBlock.EMPTY) {
            bind.context().value = context;
        }
        if (signatured.opInfo != null) {
            DefVar<?, ?> ref = signatured.ref();
            ref.opDecl = signatured;
        }
    }

    @NotNull
    private ModuleContext resolveDecl(@NotNull Decl decl, @NotNull ModuleContext context) {
        ModuleContext ctx = switch (decl.personality) {
            default -> throw new IncompatibleClassChangeError();
            case Decl.Personality.NORMAL -> context;
            case Decl.Personality.EXAMPLE -> this.exampleContext(context);
            case Decl.Personality.COUNTEREXAMPLE -> this.exampleContext(context).derive(decl.ref().name());
        };
        decl.ctx = ctx;
        decl.ref().module = ctx.moduleName();
        ctx.addGlobalSimple(decl.accessibility(), decl.ref(), decl.sourcePos);
        return ctx;
    }

    @NotNull
    private NoExportContext exampleContext(@NotNull ModuleContext context) {
        if (context instanceof PhysicalModuleContext) {
            PhysicalModuleContext physical = (PhysicalModuleContext)context;
            return physical.exampleContext();
        }
        throw new IllegalArgumentException("Invalid context: " + context);
    }

    private void resolveCtor(@NotNull Decl.DataCtor ctor, @NotNull ModuleContext context) {
        ctor.ref().module = context.moduleName();
        context.addGlobalSimple(Stmt.Accessibility.Public, ctor.ref, ctor.sourcePos);
        this.resolveOpInfo(ctor, context);
    }

    private void resolveField(@NotNull Decl.StructField field, @NotNull ModuleContext context) {
        field.ref().module = context.moduleName();
        context.addGlobalSimple(Stmt.Accessibility.Public, field.ref, field.sourcePos);
        this.resolveOpInfo(field, context);
    }
}

