/*
 * Decompiled with CFR 0.152.
 */
package org.aya.terck;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import kala.value.Ref;
import org.aya.terck.Behavior;
import org.aya.terck.CallMatrix;
import org.aya.terck.Relation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CallGraph<T, P>(@NotNull @NotNull MutableMap<T, @NotNull MutableMap<T, MutableSet<@NotNull CallMatrix<T, P>>>> graph) {
    @NotNull
    public static <T, P> CallGraph<T, P> create() {
        return new CallGraph<T, P>(MutableLinkedHashMap.of());
    }

    public boolean put(@NotNull CallMatrix<T, P> matrix) {
        T caller = matrix.domain();
        T callee = matrix.codomain();
        MutableSet set = (MutableSet)((MutableMap)this.graph.getOrPut(caller, MutableLinkedHashMap::of)).getOrPut(callee, MutableSet::create);
        if (set.contains(matrix)) {
            return false;
        }
        boolean unknown = set.anyMatch(arrow -> arrow.compare(matrix) != Relation.Unknown);
        if (unknown) {
            return false;
        }
        set.removeAll(existing -> matrix.compare((CallMatrix)existing) == Relation.LessThan);
        set.add(matrix);
        return true;
    }

    @NotNull
    private static <T, P> CallGraph<T, P> complete(@NotNull CallGraph<T, P> start) {
        Ref oldGraph = new Ref(start);
        Ref newEdge = new Ref((Object)1);
        int fuel = start.graph.size() + 1;
        while ((Integer)newEdge.value != 0 && fuel-- > 0) {
            newEdge.value = 0;
            Ref newGraph = new Ref(CallGraph.create());
            ((CallGraph)oldGraph.value).graph.forEach((domain, codomains) -> {
                MutableSet out = (MutableSet)codomains.getOrNull(domain);
                if (out != null) {
                    out.forEach(matrix -> ((CallGraph)newGraph.value).put((CallMatrix)matrix));
                }
            });
            ((CallGraph)oldGraph.value).graph.forEach((domain, codomains) -> codomains.forEach((codomain, mats) -> mats.forEach(matrix -> {
                MutableMap indirect = (MutableMap)((CallGraph)oldGraph.value).graph.getOrNull(matrix.codomain());
                if (indirect != null) {
                    indirect.forEach((indCodomain, indMatrices) -> indMatrices.forEach(ind -> {
                        CallMatrix combine = CallMatrix.combine(matrix, ind);
                        if (((CallGraph)newGraph.value).put(combine)) {
                            Integer n = (Integer)newEdge.value;
                            newEdge.value = (Integer)newEdge.value + 1;
                        }
                    }));
                }
            })));
            oldGraph.value = newGraph.value;
        }
        return (CallGraph)oldGraph.value;
    }

    @Nullable
    public ImmutableSeq<Behavior.Diag<T, P>> findNonTerminating() {
        CallGraph<T, P> complete = CallGraph.complete(this);
        for (Object key : complete.graph.keysView()) {
            Behavior behavior;
            ImmutableSeq notDecreasing;
            Option matrix = complete.graph.getOption(key).flatMap(g -> g.getOption(key));
            if (matrix.isEmpty() || !(notDecreasing = (behavior = Behavior.create(key, (MutableSet)matrix.get())).diagonals().filterNot(diag -> diag.diagonal().contains((Object)Relation.LessThan))).isNotEmpty()) continue;
            return notDecreasing;
        }
        return null;
    }
}

