/*
 * Decompiled with CFR 0.152.
 */
package org.aya.terck;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum Relation implements Comparable<Relation>
{
    Unknown("?"),
    Equal("="),
    LessThan("<");

    @NotNull
    public final String text;

    @Contract(pure=true)
    private Relation(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    @Contract(pure=true)
    @NotNull
    public Relation mul(@NotNull Relation rhs) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Unknown -> Unknown;
            case Equal -> rhs;
            case LessThan -> rhs == Unknown ? Unknown : LessThan;
        };
    }

    @Contract(pure=true)
    @NotNull
    public Relation add(@NotNull Relation rhs) {
        return this.lessThanOrEqual(rhs) ? rhs : this;
    }

    public boolean lessThanOrEqual(@NotNull Relation rhs) {
        return this.ordinal() <= rhs.ordinal();
    }
}

