/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Unit;
import org.aya.core.Meta;
import org.aya.core.term.CallTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermConsumer;
import org.aya.core.visitor.VarConsumer;
import org.aya.pretty.doc.Doc;
import org.aya.ref.Var;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.error.HoleProblem;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.unify.DefEq;
import org.aya.util.Ordering;
import org.aya.util.distill.AyaDocile;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TyckState(@NotNull MutableList<Eqn> eqns, @NotNull MutableList<WithPos<Meta>> activeMetas, @NotNull @NotNull MutableMap<@NotNull Meta, @NotNull Term> metas) {
    public TyckState() {
        this((MutableList<Eqn>)MutableList.create(), (MutableList<WithPos<Meta>>)MutableList.create(), (MutableMap<Meta, Term>)MutableMap.create());
    }

    public void solveEqn(@NotNull Reporter reporter, @Nullable Trace.Builder tracer, @NotNull Eqn eqn, boolean trying) {
        new DefEq(eqn.cmp, reporter, !trying, trying, tracer, this, eqn.pos, eqn.localCtx).checkEqn(eqn);
    }

    public boolean simplify(@NotNull Reporter reporter, @Nullable Trace.Builder tracer) {
        MutableList removingMetas = MutableList.create();
        for (WithPos activeMeta : this.activeMetas) {
            if (!this.metas.containsKey((Object)((Meta)activeMeta.data()))) continue;
            this.eqns.filterInPlace(eqn -> {
                VarConsumer.UsageCounter usageCounter = new VarConsumer.UsageCounter((Var)activeMeta.data());
                eqn.accept(usageCounter, Unit.unit());
                if (usageCounter.usageCount() > 0) {
                    this.solveEqn(reporter, tracer, (Eqn)eqn, true);
                    return false;
                }
                return true;
            });
            removingMetas.append((Object)activeMeta);
        }
        this.activeMetas.filterNotInPlace(arg_0 -> ((MutableList)removingMetas).contains(arg_0));
        return removingMetas.isNotEmpty();
    }

    public void solveMetas(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder) {
        while (this.eqns.isNotEmpty()) {
            while (this.simplify(reporter, traceBuilder)) {
            }
            ImmutableSeq eqns = this.eqns.toImmutableSeq();
            if (!eqns.isNotEmpty()) continue;
            for (Eqn eqn : eqns) {
                this.solveEqn(reporter, traceBuilder, eqn, false);
            }
            reporter.report((Problem)new HoleProblem.CannotFindGeneralSolution((ImmutableSeq<Eqn>)eqns));
        }
    }

    public void addEqn(final @NotNull Eqn eqn) {
        this.eqns.append((Object)eqn);
        int currentActiveMetas = this.activeMetas.size();
        eqn.accept(new TermConsumer<Unit>(){

            @Override
            public Unit visitHole(@NotNull CallTerm.Hole term, Unit unit) {
                Meta ref = term.ref();
                if (!TyckState.this.metas.containsKey((Object)ref)) {
                    TyckState.this.activeMetas.append((Object)new WithPos(eqn.pos, (Object)ref));
                }
                return unit;
            }
        }, Unit.unit());
        assert (this.activeMetas.sizeGreaterThan(currentActiveMetas)) : "Adding a bad equation";
    }

    public record Eqn(@NotNull Term lhs, @NotNull Term rhs, @NotNull Ordering cmp, @NotNull SourcePos pos, @NotNull LocalCtx localCtx, @NotNull DefEq.Sub lr, @NotNull DefEq.Sub rl) implements AyaDocile
    {
        public <P, R> Tuple2<R, R> accept(@NotNull Term.Visitor<P, R> visitor, P p) {
            return Tuple.of(this.lhs.accept(visitor, p), this.rhs.accept(visitor, p));
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Doc.stickySep((Doc[])new Doc[]{this.lhs.toDoc(options), Doc.symbol((String)this.cmp.symbol), this.rhs.toDoc(options)});
        }
    }
}

