/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.env;

import java.lang.runtime.SwitchBootstraps;
import java.util.function.Supplier;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple2;
import kala.tuple.Unit;
import org.aya.core.Meta;
import org.aya.core.term.CallTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.tyck.TyckState;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.env.SeqLocalCtx;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses preview features.  Disable with feature flag or --previewfeatures false
 */
@Debug.Renderer(hasChildren="true", childrenArray="extract().toArray()")
public sealed interface LocalCtx
permits MapLocalCtx, SeqLocalCtx {
    @NotNull
    default public Tuple2<CallTerm.Hole, Term> freshHole(@NotNull Term type, @NotNull SourcePos sourcePos) {
        return this.freshHole(type, "_", sourcePos);
    }

    @NotNull
    default public Tuple2<CallTerm.Hole, Term> freshHole(@Nullable Term type, @NotNull String name, @NotNull SourcePos sourcePos) {
        ImmutableSeq<Term.Param> ctxTele = this.extract();
        Meta meta = Meta.from(ctxTele, name, type, sourcePos);
        CallTerm.Hole hole = new CallTerm.Hole(meta, 0, (ImmutableSeq<Arg<Term>>)ctxTele.map(Term.Param::toArg), (ImmutableSeq<Arg<Term>>)meta.telescope.map(Term.Param::toArg));
        return Tuple2.of((Object)hole, (Object)IntroTerm.Lambda.make(meta.telescope, hole));
    }

    default public <T> T with(@NotNull Term.Param param, @NotNull Supplier<T> action) {
        return this.with(param.ref(), param.type(), action);
    }

    public void remove(@NotNull SeqView<LocalVar> var1);

    default public void forward(@NotNull LocalCtx dest, @NotNull Term term, @NotNull TyckState state) {
        term.accept((usage, o) -> {
            Var selector2025$temp = usage;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalVar.class, Meta.class}, (Object)selector2025$temp, n)) {
                case 0: {
                    LocalVar localVar = (LocalVar)selector2025$temp;
                    dest.put(localVar, this.get(localVar));
                    break;
                }
                case 1: {
                    Meta meta = (Meta)selector2025$temp;
                    Term sol = (Term)state.metas().getOrNull((Object)meta);
                    if (sol == null) break;
                    this.forward(dest, sol, state);
                    break;
                }
            }
        }, Unit.unit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T with(@NotNull LocalVar var, @NotNull Term type, @NotNull Supplier<T> action) {
        this.put(var, type);
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.remove((SeqView<LocalVar>)SeqView.of((Object)var));
        }
    }

    @NotNull
    default public ImmutableSeq<Term.Param> extract() {
        MutableList ctx = MutableList.create();
        for (LocalCtx map = this; map != null; map = map.parent()) {
            map.extractToLocal((MutableList<Term.Param>)ctx);
        }
        return ctx.toImmutableSeq();
    }

    @Contract(mutates="param1")
    public void extractToLocal(@NotNull MutableList<Term.Param> var1);

    @Contract(pure=true)
    @NotNull
    default public Term get(@NotNull LocalVar var) {
        for (LocalCtx ctx = this; ctx != null; ctx = ctx.parent()) {
            Term res = ctx.getLocal(var);
            if (res == null) continue;
            return res;
        }
        throw new IllegalArgumentException(var.name());
    }

    @Contract(pure=true)
    @Nullable
    public Term getLocal(@NotNull LocalVar var1);

    default public void put(@NotNull Term.Param param) {
        this.put(param.ref(), param.type());
    }

    public void put(@NotNull LocalVar var1, @NotNull Term var2);

    public boolean isEmpty();

    @Contract(value=" -> new")
    @NotNull
    default public MapLocalCtx deriveMap() {
        return new MapLocalCtx((MutableMap<LocalVar, Term>)MutableLinkedHashMap.of(), this);
    }

    @Contract(value=" -> new")
    @NotNull
    default public SeqLocalCtx deriveSeq() {
        return new SeqLocalCtx((MutableList<SeqLocalCtx.P>)MutableList.create(), this);
    }

    @Nullable
    public LocalCtx parent();
}

