/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Signatured;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record CircularSignatureError(@NotNull ImmutableSeq<TyckUnit> cycles) implements Problem
{
    @NotNull
    public SourcePos sourcePos() {
        return (SourcePos)this.cycles.view().map(SourceNode::sourcePos).max(Comparator.comparingInt(SourcePos::endLine));
    }

    @NotNull
    public Doc describe(@NotNull DistillerOptions options) {
        return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Circular signature dependency found between"), Doc.commaList((SeqLike)this.cycles.view().map(this::nameOf).toImmutableSeq().sorted().view().map(Doc::plain))});
    }

    @NotNull
    private String nameOf(@NotNull TyckUnit stmt) {
        TyckUnit tyckUnit = stmt;
        Objects.requireNonNull(tyckUnit);
        TyckUnit tyckUnit2 = tyckUnit;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Remark.class, Signatured.class}, (Object)tyckUnit2, n)) {
            case 0 -> {
                Decl decl = (Decl)tyckUnit2;
                yield decl.ref().name();
            }
            case 1 -> {
                Remark remark = (Remark)tyckUnit2;
                yield "a remark";
            }
            case 2 -> {
                Signatured signatured = (Signatured)tyckUnit2;
                yield signatured.ref().name();
            }
            default -> throw new IllegalStateException("Unexpected stmt seen in SCCTycker: " + stmt);
        };
    }

    @NotNull
    public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }
}

