/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.order;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Signatured;
import org.aya.core.def.Def;
import org.aya.core.def.FnDef;
import org.aya.core.def.UserDef;
import org.aya.core.term.Term;
import org.aya.generic.util.InterruptException;
import org.aya.ref.DefVar;
import org.aya.resolve.ResolveInfo;
import org.aya.terck.Behavior;
import org.aya.terck.CallGraph;
import org.aya.terck.CallResolver;
import org.aya.terck.error.NonTerminating;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.StmtTycker;
import org.aya.tyck.error.CircularSignatureError;
import org.aya.tyck.error.CounterexampleError;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.tyck.trace.Trace;
import org.aya.util.MutableGraph;
import org.aya.util.reporter.BufferReporter;
import org.aya.util.reporter.CollectingReporter;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.aya.util.tyck.SCCTycker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AyaSccTycker(@NotNull StmtTycker tycker, @NotNull CountingReporter reporter, @NotNull ResolveInfo resolveInfo, @NotNull @NotNull MutableList<@NotNull Def> wellTyped, @NotNull MutableMap<Decl, ExprTycker> tyckerReuse, @NotNull MutableMap<Decl, CollectingReporter> sampleReporters) implements SCCTycker<TyckOrder, SCCTyckingFailed>
{
    @NotNull
    public static AyaSccTycker create(ResolveInfo resolveInfo, @Nullable Trace.Builder builder, @NotNull Reporter outReporter) {
        CountingReporter counting = CountingReporter.delegate((Reporter)outReporter);
        return new AyaSccTycker(new StmtTycker((Reporter)counting, builder), counting, resolveInfo, (MutableList<Def>)MutableList.create(), (MutableMap<Decl, ExprTycker>)MutableMap.create(), (MutableMap<Decl, CollectingReporter>)MutableMap.create());
    }

    @NotNull
    public ImmutableSeq<TyckOrder> tyckSCC(@NotNull ImmutableSeq<TyckOrder> scc) {
        try {
            if (scc.isEmpty()) {
                return ImmutableSeq.empty();
            }
            if (scc.sizeEquals(1)) {
                this.checkUnit((TyckOrder)scc.first());
            } else {
                this.checkMutual(scc);
            }
            return ImmutableSeq.empty();
        }
        catch (SCCTyckingFailed failed) {
            this.reporter.clear();
            return failed.what;
        }
    }

    private void checkMutual(@NotNull ImmutableSeq<TyckOrder> scc) {
        if (scc.allMatch(t -> t instanceof TyckOrder.Head)) {
            this.reporter.report((Problem)new CircularSignatureError((ImmutableSeq<TyckUnit>)scc.map(TyckOrder::unit)));
            throw new SCCTyckingFailed(scc);
        }
        scc.forEach(this::check);
        this.terck((SeqView<TyckOrder>)scc.view());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkUnit(@NotNull TyckOrder order) {
        TyckUnit tyckUnit;
        if (order instanceof TyckOrder.Body && (tyckUnit = order.unit()) instanceof Decl.FnDecl) {
            Decl.FnDecl fn = (Decl.FnDecl)tyckUnit;
            if (fn.body.isLeft()) {
                this.checkSimpleFn(order, fn);
                return;
            }
        }
        this.check(order);
        if (!(order instanceof TyckOrder.Body)) return;
        TyckOrder.Body body = (TyckOrder.Body)order;
        this.terck((SeqView<TyckOrder>)SeqView.of((Object)body));
    }

    private boolean hasSuc(@NotNull MutableGraph<TyckOrder> G, @NotNull MutableSet<TyckOrder> book, @NotNull TyckOrder vertex, @NotNull TyckOrder suc) {
        if (book.contains((Object)vertex)) {
            return false;
        }
        book.add((Object)vertex);
        for (TyckOrder test : G.suc((Object)vertex)) {
            if (test.equals(suc)) {
                return true;
            }
            if (!this.hasSuc(G, book, test, suc)) continue;
            return true;
        }
        return false;
    }

    private boolean isRecursive(@NotNull TyckOrder unit) {
        return this.hasSuc(this.resolveInfo.depGraph(), (MutableSet<TyckOrder>)MutableSet.create(), unit, unit);
    }

    private void checkSimpleFn(@NotNull TyckOrder order, @NotNull Decl.FnDecl fn) {
        if (this.isRecursive(order)) {
            this.reporter.report((Problem)new NonTerminating(fn.sourcePos, fn.ref, null));
            throw new SCCTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
        this.decideTyckResult(fn, this.tycker.simpleFn(this.tycker.newTycker(), fn));
    }

    private void check(@NotNull TyckOrder tyckOrder) {
        TyckOrder tyckOrder2 = tyckOrder;
        Objects.requireNonNull(tyckOrder2);
        TyckOrder tyckOrder3 = tyckOrder2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TyckOrder.Head.class, TyckOrder.Body.class}, (Object)tyckOrder3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                TyckOrder.Head head = (TyckOrder.Head)tyckOrder3;
                this.checkHeader(tyckOrder, head.unit());
                break;
            }
            case 1: {
                TyckOrder.Body body = (TyckOrder.Body)tyckOrder3;
                this.checkBody(tyckOrder, body.unit());
            }
        }
    }

    private void checkHeader(@NotNull TyckOrder order, @NotNull TyckUnit stmt) {
        TyckUnit tyckUnit = stmt;
        Objects.requireNonNull(tyckUnit);
        TyckUnit tyckUnit2 = tyckUnit;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Decl.DataCtor.class, Decl.StructField.class}, (Object)tyckUnit2, n)) {
            case 0: {
                Decl decl = (Decl)tyckUnit2;
                this.tycker.tyckHeader(decl, this.reuse(decl));
                break;
            }
            case 1: {
                Decl.DataCtor ctor = (Decl.DataCtor)tyckUnit2;
                this.tycker.tyckHeader(ctor, this.reuse((Decl)ctor.dataRef.concrete));
                break;
            }
            case 2: {
                Decl.StructField field = (Decl.StructField)tyckUnit2;
                this.tycker.tyckHeader(field, this.reuse((Decl)field.structRef.concrete));
                break;
            }
        }
        if (this.reporter.anyError()) {
            throw new SCCTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
    }

    private void checkBody(@NotNull TyckOrder order, @NotNull TyckUnit stmt) {
        TyckUnit tyckUnit = stmt;
        Objects.requireNonNull(tyckUnit);
        TyckUnit tyckUnit2 = tyckUnit;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Decl.DataCtor.class, Decl.StructField.class, Remark.class}, (Object)tyckUnit2, n)) {
            case 0: {
                Decl decl = (Decl)tyckUnit2;
                this.decideTyckResult(decl, this.tycker.tyck(decl, this.reuse(decl)));
                break;
            }
            case 1: {
                Decl.DataCtor ctor = (Decl.DataCtor)tyckUnit2;
                this.tycker.tyck(ctor, this.reuse((Decl)ctor.dataRef.concrete));
                break;
            }
            case 2: {
                Decl.StructField field = (Decl.StructField)tyckUnit2;
                this.tycker.tyck(field, this.reuse((Decl)field.structRef.concrete));
                break;
            }
            case 3: {
                Remark remark = (Remark)tyckUnit2;
                Option.of((Object)remark.literate).forEach(l -> l.tyck(this.tycker.newTycker()));
                break;
            }
        }
        if (this.reporter.anyError()) {
            throw new SCCTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
    }

    private void decideTyckResult(@NotNull Decl decl, @NotNull Def def) {
        switch (decl.personality) {
            case NORMAL: {
                this.wellTyped.append((Object)def);
                break;
            }
            case COUNTEREXAMPLE: {
                CollectingReporter sampleReporter = (CollectingReporter)this.sampleReporters.getOrPut((Object)decl, BufferReporter::new);
                ImmutableSeq problems = sampleReporter.problems().toImmutableSeq();
                if (problems.isEmpty()) {
                    this.reporter.report((Problem)new CounterexampleError(decl.sourcePos, decl.ref()));
                }
                if (!(def instanceof UserDef)) break;
                UserDef userDef = (UserDef)def;
                userDef.problems = problems;
            }
        }
    }

    @NotNull
    private ExprTycker reuse(@NotNull Decl decl) {
        if (decl.personality == Decl.Personality.COUNTEREXAMPLE) {
            return (ExprTycker)this.tyckerReuse.getOrPut((Object)decl, () -> new ExprTycker((Reporter)this.sampleReporters.getOrPut((Object)decl, BufferReporter::new), this.tycker.traceBuilder()));
        }
        return (ExprTycker)this.tyckerReuse.getOrPut((Object)decl, this.tycker::newTycker);
    }

    private void terck(@NotNull SeqView<TyckOrder> units) {
        SeqView recDefs = units.filterIsInstance(TyckOrder.Body.class).filter(this::isRecursive).map(TyckOrder::unit);
        if (recDefs.isEmpty()) {
            return;
        }
        SeqView fn = recDefs.filterIsInstance(Decl.FnDecl.class).map(f -> (FnDef)f.ref.core);
        this.terckRecursiveFn((SeqView<FnDef>)fn);
    }

    private void terckRecursiveFn(@NotNull SeqView<FnDef> fn) {
        MutableSet targets = MutableSet.from(fn);
        CallGraph graph = CallGraph.create();
        fn.forEach(def -> def.accept(new CallResolver((FnDef)def, (MutableSet<Def>)targets), graph));
        ImmutableSeq failed = graph.findNonTerminating();
        if (failed != null) {
            failed.forEach(f -> {
                DefVar<?, ?> ref = ((Def)f.matrix().domain()).ref();
                this.reporter.report((Problem)new NonTerminating(((Signatured)ref.concrete).sourcePos, ref, (Behavior.Diag<Def, Term.Param>)f));
            });
        }
    }

    public static class SCCTyckingFailed
    extends InterruptException {
        @NotNull
        public final ImmutableSeq<TyckOrder> what;

        public SCCTyckingFailed(@NotNull ImmutableSeq<TyckOrder> what) {
            this.what = what;
        }

        @Override
        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Tycking;
        }
    }
}

