/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Result;
import kala.tuple.Tuple;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.Def;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatMatcher;
import org.aya.core.pat.PatToTerm;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Normalizer;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.generic.util.NormalizeMode;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.pat.ClausesProblem;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public record Conquer(@NotNull ImmutableSeq<Matching> matchings, @NotNull SourcePos sourcePos, @NotNull Def.Signature signature, boolean orderIndependent, @NotNull ExprTycker tycker) {
    public static void against(@NotNull ImmutableSeq<Matching> matchings, boolean orderIndependent, @NotNull ExprTycker tycker, @NotNull SourcePos pos, @NotNull Def.Signature signature) {
        Conquer conquer = new Conquer(matchings, pos, signature, orderIndependent, tycker);
        int size = matchings.size();
        for (int i = 0; i < size; ++i) {
            Matching matching = (Matching)matchings.get(i);
            for (Pat pat : matching.patterns()) {
                conquer.visit(pat, i);
            }
        }
    }

    public void visit(@NotNull Pat pat, int nth) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Prim.class, Pat.Ctor.class, Pat.Tuple.class}, (Object)pat3, n)) {
            case 0: {
                Pat.Prim prim = (Pat.Prim)pat3;
                PrimDef core = (PrimDef)prim.ref().core;
                assert (PrimDef.Factory.INSTANCE.leftOrRight(core));
                break;
            }
            case 1: {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                ImmutableSeq<Pat> params = ctor.params();
                for (Pat sub : params) {
                    this.visit(sub, nth);
                }
                ImmutableSeq conditions = ((CtorDef)ctor.ref().core).clauses;
                int size = conditions.size();
                for (int i = 0; i < size; ++i) {
                    Matching condition = (Matching)conditions.get(i);
                    Result<Subst, Boolean> matchy = PatMatcher.tryBuildSubstTerms(null, params, (SeqView<Term>)condition.patterns().view().map(Pat::toTerm));
                    if (!matchy.isOk()) continue;
                    MapLocalCtx ctx = new MapLocalCtx();
                    condition.patterns().forEach(tern -> tern.storeBindings(ctx));
                    this.checkConditions(ctx, ctor, nth, i + 1, condition.body(), (Subst)matchy.get(), condition.sourcePos());
                }
                break;
            }
            case 2: {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                for (Pat sub : tuple.pats()) {
                    this.visit(sub, nth);
                }
                break;
            }
        }
    }

    private void checkConditions(final LocalCtx ctx, final Pat ctor, int nth, int i, final Term condition, Subst matchy, SourcePos conditionPos) {
        ErrorTerm error;
        Object object;
        Matching currentClause = (Matching)this.matchings.get(nth);
        Term newBody = currentClause.body().subst(matchy);
        ImmutableSeq newArgs = currentClause.patterns().map(pat -> new Arg<Term>(new PatToTerm(){

            @Override
            @NotNull
            public Term visitCtor(@NotNull Pat.Ctor newCtor) {
                return newCtor == ctor ? condition : super.visitCtor(newCtor);
            }

            @Override
            public Term visit(@NotNull Pat pat) {
                if (pat instanceof Pat.Bind) {
                    Pat.Bind bind = (Pat.Bind)pat;
                    ctx.put(bind.bind(), bind.type());
                }
                return super.visit(pat);
            }
        }.visit((Pat)pat), pat.explicit()));
        WithPos<Term> volynskaya = new Normalizer(this.tycker.state).tryUnfoldClauses(NormalizeMode.WHNF, this.orderIndependent, (SeqLike<Arg<Term>>)newArgs, 0, this.matchings);
        if (volynskaya == null) {
            this.tycker.reporter.report((Problem)new ClausesProblem.Conditions(this.sourcePos, nth + 1, i, newBody, null, conditionPos, currentClause.sourcePos(), null));
            return;
        }
        if (newBody instanceof ErrorTerm && (object = (error = (ErrorTerm)newBody).description()) instanceof CallTerm.Hole) {
            CallTerm.Hole hole = (CallTerm.Hole)object;
            hole.ref().conditions.append((Object)Tuple.of((Object)matchy, (Object)((Term)volynskaya.data())));
        } else {
            ErrorTerm error2;
            object = volynskaya.data();
            if (object instanceof ErrorTerm && (object = (error2 = (ErrorTerm)object).description()) instanceof CallTerm.Hole) {
                CallTerm.Hole hole = (CallTerm.Hole)object;
                hole.ref().conditions.append((Object)Tuple.of((Object)matchy, (Object)newBody));
            }
        }
        boolean unification = this.tycker.unifier(this.sourcePos, Ordering.Eq, ctx).compare(newBody, (Term)volynskaya.data(), this.signature.result().subst(matchy));
        if (!unification) {
            this.tycker.reporter.report((Problem)new ClausesProblem.Conditions(this.sourcePos, nth + 1, i, newBody, (Term)volynskaya.data(), conditionPos, currentClause.sourcePos(), volynskaya.sourcePos()));
        }
    }
}

