/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple;
import kala.tuple.primitive.IntObjTuple2;
import kala.value.Ref;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.Decl;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatUnify;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.generic.util.NormalizeMode;
import org.aya.ref.DefVar;
import org.aya.ref.Var;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.TyckState;
import org.aya.tyck.Tycker;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.error.NotYetTyckedError;
import org.aya.tyck.pat.ClausesProblem;
import org.aya.tyck.pat.PatTree;
import org.aya.tyck.pat.PatTycker;
import org.aya.util.Ordering;
import org.aya.util.distill.AyaDocile;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.aya.util.tyck.MCT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PatClassifier(@NotNull Reporter reporter, @NotNull SourcePos pos, @NotNull TyckState state, @NotNull PatTree.Builder builder) {
    @NotNull
    public static MCT<Term, PatErr> classify(@NotNull @NotNull SeqLike<? extends @NotNull Pat.Preclause<?>> clauses, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull Tycker tycker, @NotNull SourcePos pos, boolean coverage) {
        return PatClassifier.classify(clauses, telescope, tycker.state, tycker.reporter, pos, coverage);
    }

    @NotNull
    public static MCT<Term, PatErr> classify(@NotNull @NotNull SeqLike<? extends @NotNull Pat.Preclause<?>> clauses, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull TyckState state, @NotNull Reporter reporter, @NotNull SourcePos pos, boolean coverage) {
        PatClassifier classifier = new PatClassifier(reporter, pos, state, new PatTree.Builder());
        MCT classification = classifier.classifySub((SeqView<Term.Param>)telescope.view(), (ImmutableSeq<MCT.SubPats<Pat>>)clauses.view().mapIndexed((index, clause) -> new MCT.SubPats(clause.patterns().view(), index)).toImmutableSeq(), coverage, 5);
        Ref errRef = new Ref();
        classification.forEach(pats -> {
            if (errRef.value == null && pats instanceof MCT.Error) {
                MCT.Error error = (MCT.Error)pats;
                reporter.report((Problem)new ClausesProblem.MissingCase(pos, (PatErr)error.errorMessage()));
                errRef.value = error;
            }
        });
        return errRef.value != null ? (MCT)errRef.value : classification;
    }

    public static int[] firstMatchDomination(@NotNull ImmutableSeq<Pattern.Clause> clauses, @NotNull Reporter reporter, @NotNull MCT<Term, PatErr> mct) {
        if (mct instanceof MCT.Error) {
            return new int[0];
        }
        int[] numbers = new int[clauses.size()];
        mct.forEach(results -> {
            int n = (Integer)results.contents().min();
            numbers[n] = numbers[n] + 1;
        });
        for (int i = 0; i < numbers.length; ++i) {
            if (0 != numbers[i]) continue;
            reporter.report((Problem)new ClausesProblem.FMDomination(i + 1, ((Pattern.Clause)clauses.get((int)i)).sourcePos));
        }
        return numbers;
    }

    public static void confluence(@NotNull PatTycker.PatResult clauses, @NotNull ExprTycker tycker, @NotNull SourcePos pos, @NotNull MCT<Term, PatErr> mct) {
        Term result = clauses.result();
        mct.forEach(results -> {
            ImmutableSeq contents = results.contents().flatMap(i -> Pat.Preclause.lift((Pat.Preclause)clauses.clauses().get(i.intValue())).map(matching -> IntObjTuple2.of((int)i, (Object)matching)));
            int size = contents.size();
            for (int i2 = 1; i2 < size; ++i2) {
                ErrorTerm error;
                AyaDocile patt4836$temp;
                ErrorTerm error2;
                AyaDocile patt4657$temp;
                IntObjTuple2 lhsInfo = (IntObjTuple2)contents.get(i2 - 1);
                IntObjTuple2 rhsInfo = (IntObjTuple2)contents.get(i2);
                Subst lhsSubst = new Subst((MutableMap<Var, Term>)MutableMap.create());
                Subst rhsSubst = new Subst((MutableMap<Var, Term>)MutableMap.create());
                LocalCtx ctx = PatUnify.unifyPat(((Matching)lhsInfo._2).patterns(), ((Matching)rhsInfo._2).patterns(), lhsSubst, rhsSubst, (LocalCtx)tycker.localCtx.deriveMap());
                PatClassifier.domination(rhsSubst, tycker.reporter, lhsInfo._1, rhsInfo._1, (Matching)rhsInfo._2);
                PatClassifier.domination(lhsSubst, tycker.reporter, rhsInfo._1, lhsInfo._1, (Matching)lhsInfo._2);
                Term lhsTerm = ((Matching)lhsInfo._2).body().subst(lhsSubst);
                Term rhsTerm = ((Matching)rhsInfo._2).body().subst(rhsSubst);
                if (lhsTerm instanceof ErrorTerm && (patt4657$temp = (error2 = (ErrorTerm)lhsTerm).description()) instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)patt4657$temp;
                    hole.ref().conditions.append((Object)Tuple.of((Object)lhsSubst, (Object)rhsTerm));
                } else if (rhsTerm instanceof ErrorTerm && (patt4836$temp = (error = (ErrorTerm)rhsTerm).description()) instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)patt4836$temp;
                    hole.ref().conditions.append((Object)Tuple.of((Object)rhsSubst, (Object)lhsTerm));
                }
                boolean unification = tycker.unifier(pos, Ordering.Eq, ctx).compare(lhsTerm, rhsTerm, result);
                if (unification) continue;
                tycker.reporter.report((Problem)new ClausesProblem.Confluence(pos, lhsInfo._1 + 1, rhsInfo._1 + 1, lhsTerm, rhsTerm, ((Matching)lhsInfo._2).sourcePos(), ((Matching)rhsInfo._2).sourcePos()));
            }
        });
    }

    private static void domination(Subst rhsSubst, Reporter reporter, int lhsIx, int rhsIx, Matching matching) {
        if (rhsSubst.isEmpty()) {
            reporter.report((Problem)new ClausesProblem.Domination(lhsIx + 1, rhsIx + 1, matching.sourcePos()));
        }
    }

    @NotNull
    private MCT<Term, PatErr> classifySub(@NotNull SeqView<Term.Param> telescope, @NotNull ImmutableSeq<MCT.SubPats<Pat>> subPatsSeq, boolean coverage, int fuel) {
        return MCT.classify(telescope, subPatsSeq, (params, subPats) -> this.classifySubImpl((SeqView<Term.Param>)params, (ImmutableSeq<MCT.SubPats<Pat>>)subPats, coverage, fuel));
    }

    @NotNull
    private static Pat head(@NotNull MCT.SubPats<Pat> subPats) {
        return ((Pat)subPats.head()).inline();
    }

    @Nullable
    private MCT<Term, PatErr> classifySubImpl(@NotNull SeqView<Term.Param> telescope, @NotNull ImmutableSeq<MCT.SubPats<Pat>> subPatsSeq, boolean coverage, int fuel) {
        Term normalize;
        Term.Param target = (Term.Param)telescope.first();
        boolean explicit = target.explicit();
        Term term = normalize = target.type().normalize(this.state, NormalizeMode.WHNF);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Sigma.class, CallTerm.Prim.class, CallTerm.Data.class}, (Object)term, n)) {
            default: {
                if (!subPatsSeq.isEmpty() || !coverage) break;
                this.reporter.report((Problem)new ClausesProblem.MissingBindCase(this.pos, target, normalize));
                break;
            }
            case 0: {
                FormTerm.Sigma sigma = (FormTerm.Sigma)term;
                ImmutableSeq hasTuple = subPatsSeq.mapIndexedNotNull((index, subPats) -> {
                    MCT.SubPats subPats2;
                    Pat patt7106$temp = PatClassifier.head((MCT.SubPats<Pat>)subPats);
                    if (patt7106$temp instanceof Pat.Tuple) {
                        Pat.Tuple tuple = (Pat.Tuple)patt7106$temp;
                        subPats2 = new MCT.SubPats(tuple.pats().view(), index);
                    } else {
                        subPats2 = null;
                    }
                    return subPats2;
                });
                if (!hasTuple.isNotEmpty()) break;
                this.builder.shiftEmpty(explicit);
                IntroTerm.Tuple thatTuple = new IntroTerm.Tuple((ImmutableSeq<Term>)sigma.params().map(Term.Param::toTerm));
                SeqView newTele = telescope.drop(1).map(param -> param.subst(target.ref(), thatTuple)).toImmutableSeq().view();
                int fuelCopy = fuel;
                return this.classifySub((SeqView<Term.Param>)sigma.params().view(), (ImmutableSeq<MCT.SubPats<Pat>>)hasTuple, coverage, fuel).flatMap(pat -> pat.propagate(this.classifySub((SeqView<Term.Param>)newTele, (ImmutableSeq<MCT.SubPats<Pat>>)MCT.extract((MCT.PatClass)pat, (ImmutableSeq)subPatsSeq).map(MCT.SubPats::drop), coverage, fuelCopy)));
            }
            case 1: {
                CallTerm.Prim primCall = (CallTerm.Prim)term;
                assert (((PrimDef)((DefVar)primCall.ref()).core).id == PrimDef.ID.INTERVAL);
                Option lrSplit = subPatsSeq.mapNotNull(subPats -> {
                    Pat.Prim prim;
                    Pat patt8433$temp = PatClassifier.head((MCT.SubPats<Pat>)subPats);
                    return patt8433$temp instanceof Pat.Prim ? (prim = (Pat.Prim)patt8433$temp) : null;
                }).firstOption();
                if (!lrSplit.isDefined()) break;
                MutableList buffer = MutableList.create();
                if (coverage) {
                    this.reporter.report((Problem)new ClausesProblem.SplitInterval(this.pos, (Pat)lrSplit.get()));
                }
                for (PrimDef.ID primName : PrimDef.Factory.LEFT_RIGHT) {
                    this.builder.append(new PatTree(primName.id, explicit, 0));
                    Option<PrimDef> prim = PrimDef.Factory.INSTANCE.getOption(primName);
                    MCT.Leaf patClass = new MCT.Leaf(subPatsSeq.view().mapIndexedNotNull((ix, subPats) -> PatClassifier.matches((MCT.SubPats<Pat>)subPats, ix, prim)).map(MCT.SubPats::ix).toImmutableSeq());
                    ImmutableSeq classes = MCT.extract((MCT.PatClass)patClass, subPatsSeq).map(MCT.SubPats::drop);
                    if (classes.isNotEmpty()) {
                        CallTerm.Prim lrCall = new CallTerm.Prim(((PrimDef)prim.get()).ref, 0, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
                        SeqView newTele = telescope.drop(1).map(param -> param.subst(target.ref(), lrCall)).toImmutableSeq().view();
                        MCT<Term, PatErr> rest = this.classifySub((SeqView<Term.Param>)newTele, (ImmutableSeq<MCT.SubPats<Pat>>)classes, false, fuel);
                        buffer.append(rest);
                    }
                    this.builder.unshift();
                }
                return new MCT.Node((Object)primCall, buffer.toImmutableSeq());
            }
            case -1: 
            case 2: {
                CallTerm.Data dataCall = (CallTerm.Data)term;
                if (subPatsSeq.anyMatch(subPats -> subPats.pats().isNotEmpty()) && subPatsSeq.noneMatch(subPats -> PatClassifier.head((MCT.SubPats<Pat>)subPats) instanceof Pat.Ctor)) break;
                MutableList buffer = MutableList.create();
                Var data = dataCall.ref();
                Seq<CtorDef> body = Def.dataBody((DefVar<? extends DataDef, ? extends Decl.DataDecl>)data);
                if (coverage && ((DefVar)data).core == null) {
                    this.reporter.report((Problem)new NotYetTyckedError(this.pos, data));
                }
                for (CtorDef ctor : body) {
                    boolean definitely;
                    SeqView conTele = ctor.selfTele.view();
                    Result<Subst, Boolean> matchy = PatTycker.mischa(dataCall, ctor, null, this.state);
                    if (matchy.isErr()) {
                        if (!((Boolean)matchy.getErr()).booleanValue()) continue;
                        if (subPatsSeq.isNotEmpty() && subPatsSeq.noneMatch(seq -> PatClassifier.head((MCT.SubPats<Pat>)seq) instanceof Pat.Bind)) {
                            this.reporter.report((Problem)new ClausesProblem.UnsureCase(this.pos, ctor, dataCall));
                            continue;
                        }
                    } else {
                        conTele = conTele.map(param -> param.subst((Subst)matchy.get()));
                    }
                    ImmutableSeq conTele2 = conTele.toImmutableSeq();
                    ImmutableSeq matches = subPatsSeq.mapIndexedNotNull((ix, subPats) -> PatClassifier.matches((MCT.SubPats<Pat>)subPats, ix, (ImmutableSeq<Term.Param>)conTele2, ctor.ref()));
                    this.builder.shift(new PatTree(ctor.ref().name(), explicit, conTele2.count(Term.Param::explicit)));
                    boolean matchesEmpty = matches.isEmpty();
                    if (matchesEmpty) {
                        --fuel;
                    }
                    boolean bl = definitely = matchesEmpty && conTele2.isEmpty() && telescope.sizeEquals(1);
                    if (definitely || fuel <= 0) {
                        if (coverage) {
                            buffer.append((Object)new MCT.Error(ImmutableSeq.empty(), (Object)new PatErr((ImmutableSeq<Pattern>)this.builder.root().view().map(PatTree::toPattern).toImmutableSeq())));
                        }
                        this.builder.reduce();
                        this.builder.unshift();
                        continue;
                    }
                    MCT<Term, PatErr> classified = this.classifySub((SeqView<Term.Param>)conTele2.view(), (ImmutableSeq<MCT.SubPats<Pat>>)matches, coverage, fuel);
                    this.builder.reduce();
                    CallTerm.Con conCall = new CallTerm.Con(dataCall.conHead(ctor.ref), (ImmutableSeq<Arg<Term>>)conTele2.map(Term.Param::toArg));
                    SeqView newTele = telescope.drop(1).map(param -> param.subst(target.ref(), conCall)).toImmutableSeq().view();
                    int fuelCopy = fuel;
                    MCT rest = classified.flatMap(pat -> pat.propagate(this.classifySub((SeqView<Term.Param>)newTele, (ImmutableSeq<MCT.SubPats<Pat>>)MCT.extract((MCT.PatClass)pat, (ImmutableSeq)subPatsSeq).map(MCT.SubPats::drop), coverage, fuelCopy)));
                    this.builder.unshift();
                    buffer.append((Object)rest);
                }
                return new MCT.Node((Object)dataCall, buffer.toImmutableSeq());
            }
        }
        this.builder.shiftEmpty(explicit);
        this.builder.unshift();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static MCT.SubPats<Pat> matches(MCT.SubPats<Pat> subPats, int ix, Option<PrimDef> existedPrim) {
        block3: {
            Pat head;
            block2: {
                head = PatClassifier.head(subPats);
                if (!(head instanceof Pat.Prim)) break block2;
                Pat.Prim prim = (Pat.Prim)head;
                if (existedPrim.isNotEmpty() && prim.ref() == ((PrimDef)existedPrim.get()).ref()) break block3;
            }
            if (!(head instanceof Pat.Bind)) return null;
        }
        MCT.SubPats subPats2 = new MCT.SubPats(subPats.pats(), ix);
        return subPats2;
    }

    @Nullable
    private static MCT.SubPats<Pat> matches(MCT.SubPats<Pat> subPats, int ix, ImmutableSeq<Term.Param> conTele, Var ctorRef) {
        Pat.Ctor ctorPat;
        Pat head = PatClassifier.head(subPats);
        if (head instanceof Pat.Ctor && (ctorPat = (Pat.Ctor)head).ref() == ctorRef) {
            return new MCT.SubPats(ctorPat.params().view(), ix);
        }
        if (head instanceof Pat.Bind) {
            return new MCT.SubPats(conTele.view().map(Term.Param::toPat), ix);
        }
        return null;
    }

    public record PatErr(@NotNull ImmutableSeq<Pattern> missing) {
    }
}

