/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.tuple.Tuple3;
import kala.tuple.Unit;
import kala.value.Ref;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.visitor.ExprOps;
import org.aya.concrete.visitor.ExprView;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatMatcher;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.TermFixpoint;
import org.aya.core.visitor.Unfolder;
import org.aya.generic.util.NormalizeMode;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.TyckState;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.error.NotYetTyckedError;
import org.aya.tyck.pat.PatClassifier;
import org.aya.tyck.pat.PatternProblem;
import org.aya.tyck.trace.Trace;
import org.aya.util.TreeBuilder;
import org.aya.util.distill.AyaDocile;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.tyck.MCT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatTycker {
    @NotNull
    public final ExprTycker exprTycker;
    @NotNull
    private final Subst typeSubst;
    @NotNull
    private final MutableMap<Var, Expr> bodySubst;
    @Nullable
    private final Trace.Builder traceBuilder;
    private boolean hasError = false;
    private Pattern.Clause currentClause = null;

    public boolean noError() {
        return !this.hasError;
    }

    public PatTycker(@NotNull ExprTycker exprTycker, @NotNull Subst typeSubst, @NotNull MutableMap<Var, Expr> bodySubst, @Nullable Trace.Builder traceBuilder) {
        this.exprTycker = exprTycker;
        this.typeSubst = typeSubst;
        this.bodySubst = bodySubst;
        this.traceBuilder = traceBuilder;
    }

    private <R> R traced(@NotNull Supplier<Trace> trace, @NotNull Supplier<R> computation) {
        this.tracing(builder -> builder.shift((Trace)trace.get()));
        R res = computation.get();
        this.tracing(TreeBuilder::reduce);
        return res;
    }

    private void tracing(@NotNull @NotNull Consumer<@NotNull Trace.Builder> consumer) {
        if (this.traceBuilder != null) {
            consumer.accept(this.traceBuilder);
        }
    }

    public PatTycker(@NotNull ExprTycker exprTycker) {
        this(exprTycker, new Subst((MutableMap<Var, Term>)MutableMap.create()), (MutableMap<Var, Expr>)MutableMap.create(), exprTycker.traceBuilder);
    }

    private void addPatSubst(@NotNull Var var, @NotNull Pat pat, @NotNull SourcePos pos) {
        this.typeSubst.addDirectly(var, pat.toTerm());
        this.bodySubst.put((Object)var, (Object)pat.toExpr(pos));
    }

    @NotNull
    public PatResult elabClausesDirectly(@NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature signature) {
        return this.checkAllRhs(this.checkAllLhs(clauses, signature), signature.result());
    }

    @NotNull
    public PatResult elabClausesClassified(@NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature signature, @NotNull SourcePos resultPos, @NotNull SourcePos overallPos) {
        ImmutableSeq<LhsResult> lhsResults = this.checkAllLhs(clauses, signature);
        if (this.noError()) {
            MCT<Term, PatClassifier.PatErr> classes = PatClassifier.classify(lhsResults.view().map(LhsResult::preclause), signature.param(), this.exprTycker, overallPos, true);
            if (clauses.isNotEmpty()) {
                int[] nArray = PatClassifier.firstMatchDomination(clauses, this.exprTycker.reporter, classes);
            }
        }
        return this.checkAllRhs(lhsResults, signature.result());
    }

    @NotNull
    private ImmutableSeq<LhsResult> checkAllLhs(@NotNull @NotNull ImmutableSeq<@NotNull Pattern.Clause> clauses, @NotNull Def.Signature signature) {
        return clauses.mapIndexed((index, clause) -> this.traced(() -> new Trace.LabelT(clause.sourcePos, "lhs of clause " + (1 + index)), () -> this.checkLhs((Pattern.Clause)clause, signature)));
    }

    @NotNull
    private PatResult checkAllRhs(@NotNull ImmutableSeq<LhsResult> clauses, @NotNull Term result) {
        ImmutableSeq res = clauses.mapIndexed((index, lhs) -> this.traced(() -> new Trace.LabelT(lhs.preclause.sourcePos(), "rhs of clause " + (1 + index)), () -> this.checkRhs((LhsResult)lhs)));
        this.exprTycker.solveMetas();
        ImmutableSeq preclauses = res.map(c -> new Pat.Preclause(c.sourcePos(), (ImmutableSeq<Pat>)c.patterns().map(p -> p.zonk(this.exprTycker)), c.expr().map(this.exprTycker::zonk)));
        return new PatResult(this.exprTycker.zonk(result), (ImmutableSeq<Pat.Preclause<Term>>)preclauses, (ImmutableSeq<Matching>)preclauses.flatMap(Pat.Preclause::lift));
    }

    @NotNull
    private Pat doTyck(@NotNull Pattern pattern, @NotNull Term term) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Absurd.class, Pattern.Tuple.class, Pattern.Ctor.class, Pattern.Bind.class, Pattern.CalmFace.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.Absurd absurd = (Pattern.Absurd)pattern3;
                Tuple3<CallTerm.Data, Subst, CallTerm.ConHead> selection = this.selectCtor(term, null, absurd);
                if (selection != null) {
                    this.foundError(new PatternProblem.PossiblePat(absurd, (CallTerm.ConHead)selection._3));
                }
                yield new Pat.Absurd(absurd.explicit());
            }
            case 1 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                Term var8_8 = term.normalize(this.exprTycker.state, NormalizeMode.WHNF);
                if (!(var8_8 instanceof FormTerm.Sigma)) {
                    yield this.withError(new PatternProblem.TupleNonSig(tuple, term), tuple, term);
                }
                FormTerm.Sigma sigma = (FormTerm.Sigma)var8_8;
                Def.Signature sig = new Def.Signature(sigma.params(), new ErrorTerm(Doc.plain((String)"Rua"), false));
                LocalVar as = tuple.as();
                Pat.Tuple ret = new Pat.Tuple(tuple.explicit(), (ImmutableSeq<Pat>)((ImmutableSeq)this.visitPatterns((Def.Signature)sig, (SeqView<Pattern>)tuple.patterns().view())._1));
                if (as != null) {
                    this.exprTycker.localCtx.put(as, sigma);
                    this.addPatSubst(as, ret, tuple.sourcePos());
                }
                yield ret;
            }
            case 2 -> {
                Tuple3<CallTerm.Data, Subst, CallTerm.ConHead> realCtor;
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                Var var = (Var)ctor.resolved().data();
                if (term instanceof CallTerm.Prim) {
                    CallTerm.Prim prim = (CallTerm.Prim)term;
                    if (((PrimDef)((DefVar)prim.ref()).core).id == PrimDef.ID.INTERVAL && var instanceof DefVar) {
                        DefVar defVar = (DefVar)var;
                        Object var12_19 = defVar.core;
                        if (var12_19 instanceof PrimDef) {
                            PrimDef def = (PrimDef)var12_19;
                            if (PrimDef.Factory.LEFT_RIGHT.contains((Object)def.id)) {
                                yield new Pat.Prim(ctor.explicit(), defVar);
                            }
                        }
                    }
                }
                if ((realCtor = this.selectCtor(term, var, ctor)) == null) {
                    yield this.randomPat(pattern, term);
                }
                DefVar<CtorDef, Decl.DataCtor> ctorRef = ((CallTerm.ConHead)realCtor._3).ref();
                CtorDef ctorCore = (CtorDef)ctorRef.core;
                CallTerm.Data dataCall = (CallTerm.Data)realCtor._1;
                Def.Signature sig = new Def.Signature(Term.Param.subst((ImmutableSeq<Term.Param>)ctorCore.selfTele, (Subst)realCtor._2, 0), dataCall);
                ImmutableSeq patterns = (ImmutableSeq)this.visitPatterns((Def.Signature)sig, (SeqView<Pattern>)ctor.params().view())._1;
                LocalVar as = ctor.as();
                Pat.Ctor ret = new Pat.Ctor(ctor.explicit(), ((CallTerm.ConHead)realCtor._3).ref(), (ImmutableSeq<Pat>)patterns, dataCall);
                if (as != null) {
                    this.exprTycker.localCtx.put(as, dataCall);
                    this.addPatSubst(as, ret, ctor.sourcePos());
                }
                yield ret;
            }
            case 3 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern3;
                LocalVar v = bind.bind();
                this.exprTycker.localCtx.put(v, term);
                yield new Pat.Bind(bind.explicit(), v, term);
            }
            case 4 -> {
                Pattern.CalmFace face = (Pattern.CalmFace)pattern3;
                yield new Pat.Meta(face.explicit(), (Ref<Pat>)new Ref(), new LocalVar("_", face.sourcePos()), term);
            }
            default -> throw new UnsupportedOperationException("Number patterns are unsupported yet");
        };
    }

    private Pat.Preclause<Term> checkRhs(LhsResult lhsResult) {
        LocalCtx parent = this.exprTycker.localCtx;
        this.exprTycker.localCtx = lhsResult.gamma;
        ImmutableSeq patterns = lhsResult.preclause.patterns().map(Pat::inline);
        Term type = lhsResult.type.accept(new TermFixpoint<Unit>(){

            @Override
            @NotNull
            public Term visitMetaPat(@NotNull RefTerm.MetaPat metaPat, Unit unit) {
                return metaPat.inline();
            }
        }, Unit.unit());
        Option term = lhsResult.preclause.expr().map(e -> lhsResult.hasError ? new ErrorTerm((AyaDocile)e, false) : this.exprTycker.inherit(new BodySubstitutor(e.view(), lhsResult.bodySubst).commit(), type).wellTyped());
        this.exprTycker.localCtx = parent;
        return new Pat.Preclause<Term>(lhsResult.preclause.sourcePos(), (ImmutableSeq<Pat>)patterns, term);
    }

    private LhsResult checkLhs(Pattern.Clause match, Def.Signature signature) {
        LocalCtx parent = this.exprTycker.localCtx;
        this.exprTycker.localCtx = parent.deriveMap();
        this.currentClause = match;
        Tuple2<ImmutableSeq<Pat>, Term> step0 = this.visitPatterns(signature, (SeqView<Pattern>)match.patterns.view());
        LhsResult step1 = new LhsResult(this.exprTycker.localCtx, (Term)step0._2, (ImmutableMap<Var, Expr>)this.bodySubst.toImmutableMap(), match.hasError, new Pat.Preclause<Expr>(match.sourcePos, (ImmutableSeq<Pat>)((ImmutableSeq)step0._1), match.expr));
        this.exprTycker.localCtx = parent;
        this.typeSubst.clear();
        this.bodySubst.clear();
        return step1;
    }

    @NotNull
    public Tuple2<ImmutableSeq<Pat>, Term> visitPatterns(Def.Signature sig, SeqView<Pattern> stream) {
        MutableList results = MutableList.create();
        if (sig.param().isEmpty() && stream.isEmpty()) {
            return Tuple.of((Object)results.toImmutableSeq(), (Object)sig.result());
        }
        Pattern last_pat = (Pattern)stream.last();
        while (sig.param().isNotEmpty()) {
            Pattern pat;
            Term.Param param = (Term.Param)sig.param().first();
            if (param.explicit()) {
                if (stream.isEmpty()) {
                    this.foundError(new PatternProblem.InsufficientPattern(last_pat, param));
                    return Tuple.of((Object)results.toImmutableSeq(), (Object)sig.result());
                }
                pat = (Pattern)stream.first();
                stream = stream.drop(1);
                if (!pat.explicit()) {
                    this.foundError(new PatternProblem.TooManyImplicitPattern(pat, param));
                    return Tuple.of((Object)results.toImmutableSeq(), (Object)sig.result());
                }
            } else {
                if (stream.isEmpty()) {
                    sig = this.generatePat(new PatData(sig, (MutableList<Pat>)results, param));
                    continue;
                }
                pat = (Pattern)stream.first();
                if (pat.explicit()) {
                    sig = this.generatePat(new PatData(sig, (MutableList<Pat>)results, param));
                    continue;
                }
                stream = stream.drop(1);
            }
            sig = this.updateSig(new PatData(sig, (MutableList<Pat>)results, param), pat);
        }
        if (stream.isNotEmpty()) {
            this.foundError(new PatternProblem.TooManyPattern((Pattern)stream.first(), sig.result().freezeHoles(this.exprTycker.state)));
        }
        return Tuple.of((Object)results.toImmutableSeq(), (Object)sig.result());
    }

    @NotNull
    private Def.Signature updateSig(PatData data, Pattern pat) {
        Term type = data.param.type();
        this.tracing(builder -> builder.shift(new Trace.PatT(type, pat, pat.sourcePos())));
        Pat res = this.doTyck(pat, type);
        this.tracing(TreeBuilder::reduce);
        this.addPatSubst(data.param.ref(), res, pat.sourcePos());
        data.results.append((Object)res);
        return data.sig.inst(this.typeSubst);
    }

    @NotNull
    private Def.Signature generatePat(@NotNull PatData data) {
        Record bind;
        LocalVar ref = data.param.ref();
        LocalVar freshVar = new LocalVar(ref.name(), ref.definition());
        Term term = data.param.type().normalize(this.exprTycker.state, NormalizeMode.WHNF);
        if (term instanceof CallTerm.Data) {
            CallTerm.Data dataCall = (CallTerm.Data)term;
            bind = new Pat.Meta(false, (Ref<Pat>)new Ref(), freshVar, dataCall);
        } else {
            bind = new Pat.Bind(false, freshVar, data.param.type());
        }
        data.results.append((Object)bind);
        this.exprTycker.localCtx.put(freshVar, data.param.type());
        this.addPatSubst(ref, (Pat)((Object)bind), data.paramPos());
        return data.sig.inst(this.typeSubst);
    }

    private void foundError(@Nullable Problem problem) {
        this.hasError = true;
        if (this.currentClause != null) {
            this.currentClause.hasError = true;
        }
        if (problem != null) {
            this.exprTycker.reporter.report(problem);
        }
    }

    @NotNull
    private Pat withError(Problem problem, Pattern pattern, Term param) {
        this.foundError(problem);
        return this.randomPat(pattern, param);
    }

    @NotNull
    private Pat randomPat(Pattern pattern, Term param) {
        return new Pat.Bind(pattern.explicit(), new LocalVar("?"), param);
    }

    @Nullable
    private Tuple3<CallTerm.Data, Subst, CallTerm.ConHead> selectCtor(Term param, @Nullable Var name, @NotNull Pattern pos) {
        Term term = param.normalize(this.exprTycker.state, NormalizeMode.WHNF);
        if (!(term instanceof CallTerm.Data)) {
            this.foundError(new PatternProblem.SplittingOnNonData(pos, param));
            return null;
        }
        CallTerm.Data dataCall = (CallTerm.Data)term;
        Var dataRef = dataCall.ref();
        DataDef core = (DataDef)((DefVar)dataRef).core;
        if (core == null && name == null) {
            this.foundError(new NotYetTyckedError(pos.sourcePos(), dataRef));
            return null;
        }
        Seq<CtorDef> body = Def.dataBody((DefVar<? extends DataDef, ? extends Decl.DataDecl>)dataRef);
        for (CtorDef ctor : body) {
            if (name != null && ctor.ref() != name) continue;
            Result<Subst, Boolean> matchy = PatTycker.mischa(dataCall, ctor, this.exprTycker.localCtx, this.exprTycker.state);
            if (matchy.isOk()) {
                return Tuple.of((Object)dataCall, (Object)((Subst)matchy.get()), (Object)dataCall.conHead(ctor.ref()));
            }
            if (name == null) {
                if (!((Boolean)matchy.getErr()).booleanValue()) continue;
                this.foundError(new PatternProblem.BlockedEval(pos, dataCall));
                return null;
            }
            this.foundError(new PatternProblem.UnavailableCtor(pos, dataCall));
            return null;
        }
        if (core == null) {
            this.foundError(new NotYetTyckedError(pos.sourcePos(), name));
            return null;
        }
        return null;
    }

    public static Result<Subst, Boolean> mischa(CallTerm.Data dataCall, CtorDef ctor, @Nullable LocalCtx ctx, @NotNull TyckState state) {
        if (ctor.pats.isNotEmpty()) {
            return PatMatcher.tryBuildSubstTerms(ctx, ctor.pats, (SeqView<Term>)dataCall.args().view().map(arg -> ((Term)arg.term()).normalize(state, NormalizeMode.WHNF)));
        }
        return Result.ok((Object)Unfolder.buildSubst(Def.defTele(dataCall.ref()), dataCall.args()));
    }

    public record PatResult(@NotNull Term result, @NotNull ImmutableSeq<Pat.Preclause<Term>> clauses, @NotNull ImmutableSeq<Matching> matchings) {
    }

    public record LhsResult(@NotNull LocalCtx gamma, @NotNull Term type, @NotNull ImmutableMap<Var, Expr> bodySubst, boolean hasError, @NotNull Pat.Preclause<Expr> preclause) {
    }

    private record PatData(@NotNull Def.Signature sig, @NotNull MutableList<Pat> results, @NotNull Term.Param param) {
        @NotNull
        public SourcePos paramPos() {
            return this.param.ref().definition();
        }
    }

    private record BodySubstitutor(@NotNull ExprView view, @NotNull ImmutableMap<Var, Expr> bodySubst) implements ExprOps
    {
        @Override
        @NotNull
        public Expr pre(@NotNull Expr expr) {
            Expr expr2;
            Expr expr3 = expr;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.RefExpr.class, Expr.MetaPat.class, Expr.class}, (Object)expr3, n)) {
                    case 0: {
                        Expr.RefExpr ref = (Expr.RefExpr)expr3;
                        if (!this.bodySubst.containsKey((Object)ref.resolvedVar())) {
                            n = 1;
                            continue block4;
                        }
                        expr2 = this.pre((Expr)this.bodySubst.get((Object)ref.resolvedVar()));
                        break block4;
                    }
                    case 1: {
                        Expr.MetaPat metaPat = (Expr.MetaPat)expr3;
                        expr2 = this.pre(metaPat.meta().inline().toExpr(metaPat.sourcePos()));
                        break block4;
                    }
                    default: {
                        Expr misc;
                        expr2 = misc = expr3;
                        break block4;
                    }
                }
                break;
            }
            return expr2;
        }
    }
}

