/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.trace;

import java.util.Deque;
import kala.collection.mutable.MutableList;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.core.term.Term;
import org.aya.ref.DefVar;
import org.aya.tyck.ExprTycker;
import org.aya.util.TreeBuilder;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Trace
extends TreeBuilder.Tree<Trace> {
    public <P, R> R accept(@NotNull Visitor<P, R> var1, P var2);

    public record PatT(@NotNull Term term, @NotNull Pattern pat, @NotNull SourcePos pos, @NotNull @NotNull MutableList<@NotNull Trace> children) implements Trace
    {
        public PatT(@NotNull Term term, @NotNull Pattern pat, @NotNull SourcePos pos) {
            this(term, pat, pos, (MutableList<Trace>)MutableList.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPat(this, p);
        }
    }

    public record TyckT(@NotNull Term term, @NotNull Term type, @NotNull SourcePos pos, @NotNull @NotNull MutableList<@NotNull Trace> children) implements Trace
    {
        public TyckT(@NotNull ExprTycker.Result result, @NotNull SourcePos pos) {
            this(result.wellTyped(), result.type(), pos, (MutableList<Trace>)MutableList.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitTyck(this, p);
        }
    }

    public record UnifyT(@NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos pos, @Nullable Term type, @NotNull @NotNull MutableList<@NotNull Trace> children) implements Trace
    {
        public UnifyT(@NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos pos) {
            this(lhs, rhs, pos, null);
        }

        public UnifyT(@NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos pos, @Nullable Term type) {
            this(lhs, rhs, pos, type, (MutableList<Trace>)MutableList.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUnify(this, p);
        }
    }

    public record ExprT(@NotNull Expr expr, @Nullable Term term, @NotNull @NotNull MutableList<@NotNull Trace> children) implements Trace
    {
        public ExprT(@NotNull Expr expr, @Nullable Term term) {
            this(expr, term, (MutableList<Trace>)MutableList.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitExpr(this, p);
        }
    }

    public record DeclT(@NotNull DefVar<?, ?> var, @NotNull SourcePos pos, @NotNull @NotNull MutableList<@NotNull Trace> children) implements Trace
    {
        public DeclT(@NotNull DefVar<?, ?> var, @NotNull SourcePos pos) {
            this(var, pos, (MutableList<Trace>)MutableList.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitDecl(this, p);
        }
    }

    public record LabelT(@NotNull SourcePos pos, @NotNull String label, @NotNull @NotNull MutableList<@NotNull Trace> children) implements Trace
    {
        public LabelT(@NotNull SourcePos pos, @NotNull String label) {
            this(pos, label, (MutableList<Trace>)MutableList.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLabel(this, p);
        }
    }

    public static final class Builder
    extends TreeBuilder<Trace> {
        @VisibleForTesting
        @NotNull
        public Deque<MutableList<Trace>> getTops() {
            return this.tops;
        }
    }

    public static interface Visitor<P, R> {
        public R visitExpr(@NotNull ExprT var1, P var2);

        public R visitUnify(@NotNull UnifyT var1, P var2);

        public R visitDecl(@NotNull DeclT var1, P var2);

        public R visitTyck(@NotNull TyckT var1, P var2);

        public R visitPat(@NotNull PatT var1, P var2);

        public R visitLabel(@NotNull LabelT var1, P var2);
    }
}

