/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.unify;

import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kala.collection.Map;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple2;
import org.aya.concrete.stmt.Decl;
import org.aya.core.Meta;
import org.aya.core.def.CtorDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.StructDef;
import org.aya.core.ops.Eta;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.Unfolder;
import org.aya.core.visitor.VarConsumer;
import org.aya.generic.Arg;
import org.aya.generic.util.NormalizeMode;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.ref.Var;
import org.aya.tyck.TyckState;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.env.MapLocalCtx;
import org.aya.tyck.error.HoleProblem;
import org.aya.tyck.error.LevelError;
import org.aya.tyck.trace.Trace;
import org.aya.util.Ordering;
import org.aya.util.TreeBuilder;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefEq {
    @Nullable
    private final Trace.Builder traceBuilder;
    final boolean allowVague;
    final boolean allowConfused;
    @NotNull
    private final TyckState state;
    @NotNull
    private final Reporter reporter;
    @NotNull
    private final SourcePos pos;
    @NotNull
    private final Ordering cmp;
    @NotNull
    private final LocalCtx ctx;
    @NotNull
    private final Eta uneta;
    private FailureData failure;

    @NotNull
    public FailureData getFailure() {
        assert (this.failure != null);
        return this.failure;
    }

    public DefEq(@NotNull Ordering cmp, @NotNull Reporter reporter, boolean allowVague, boolean allowConfused, @Nullable Trace.Builder traceBuilder, @NotNull TyckState state, @NotNull SourcePos pos, @NotNull LocalCtx ctx) {
        this.cmp = cmp;
        this.allowVague = allowVague;
        this.allowConfused = allowConfused;
        this.reporter = reporter;
        this.traceBuilder = traceBuilder;
        this.state = state;
        this.pos = pos;
        this.ctx = ctx;
        this.uneta = new Eta(ctx);
    }

    private void tracing(@NotNull @NotNull Consumer<@NotNull Trace.Builder> consumer) {
        if (this.traceBuilder != null) {
            consumer.accept(this.traceBuilder);
        }
    }

    private void traceEntrance(@NotNull Trace trace) {
        this.tracing(builder -> builder.shift(trace));
    }

    private void traceExit() {
        this.tracing(TreeBuilder::reduce);
    }

    public boolean compare(@NotNull Term lhs, @NotNull Term rhs, @Nullable Term type) {
        return this.compare(lhs, rhs, new Sub(), new Sub(), type);
    }

    private boolean compare(Term lhs, Term rhs, Sub lr, Sub rl, @Nullable Term type) {
        if (lhs == rhs) {
            return true;
        }
        if (this.compareApprox(lhs, rhs, lr, rl) != null) {
            return true;
        }
        if (this.compareApprox(lhs = lhs.normalize(this.state, NormalizeMode.WHNF), rhs = rhs.normalize(this.state, NormalizeMode.WHNF), lr, rl) != null) {
            return true;
        }
        if (rhs instanceof CallTerm.Hole) {
            return this.compareUntyped(rhs, lhs, rl, lr) != null;
        }
        if (lhs instanceof CallTerm.Hole || type == null) {
            return this.compareUntyped(lhs, rhs, lr, rl) != null;
        }
        if (lhs instanceof ErrorTerm || rhs instanceof ErrorTerm) {
            return true;
        }
        boolean result = this.doCompareTyped(type.normalize(this.state, NormalizeMode.WHNF), lhs, rhs, lr, rl);
        if (!result && this.failure == null) {
            this.failure = new FailureData(lhs.freezeHoles(this.state), rhs.freezeHoles(this.state));
        }
        return result;
    }

    @Nullable
    private Term compareUntyped(@NotNull Term lhs, @NotNull Term rhs, Sub lr, Sub rl) {
        Term x;
        if (DefEq.isCall(lhs) || DefEq.isCall(rhs)) {
            Term ty = this.compareApprox(lhs, rhs, lr, rl);
            if (ty == null) {
                ty = this.doCompareUntyped(lhs, rhs, lr, rl);
            }
            if (ty != null) {
                return ty.normalize(this.state, NormalizeMode.WHNF);
            }
        }
        if ((x = this.doCompareUntyped(lhs = lhs.normalize(this.state, NormalizeMode.WHNF), rhs = rhs.normalize(this.state, NormalizeMode.WHNF), lr, rl)) != null) {
            return x.normalize(this.state, NormalizeMode.WHNF);
        }
        if (this.failure == null) {
            this.failure = new FailureData(lhs.subst((Map<Var, ? extends Term>)lr.map).freezeHoles(this.state), rhs.freezeHoles(this.state));
        }
        return null;
    }

    private boolean compareWHNF(Term lhs, Term preRhs, Sub lr, Sub rl, @NotNull Term type) {
        Term whnf = lhs.normalize(this.state, NormalizeMode.WHNF);
        Term rhsWhnf = preRhs.normalize(this.state, NormalizeMode.WHNF);
        if (Objects.equals(whnf, lhs) && Objects.equals(rhsWhnf, preRhs)) {
            return false;
        }
        return this.compare(whnf, rhsWhnf, lr, rl, type);
    }

    @Nullable
    private Term compareApprox(@NotNull Term preLhs, @NotNull Term preRhs, Sub lr, Sub rl) {
        Term term;
        Term term2 = preLhs;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CallTerm.Fn.class, CallTerm.Con.class, CallTerm.Prim.class}, (Object)term3, n)) {
                case 0: {
                    CallTerm.Fn lhs = (CallTerm.Fn)term3;
                    if (!(preRhs instanceof CallTerm.Fn)) {
                        n = 1;
                        continue block5;
                    }
                    CallTerm.Fn rhs = (CallTerm.Fn)preRhs;
                    if (lhs.ref() != rhs.ref()) {
                        term = null;
                        break block5;
                    }
                    term = this.visitCall(lhs, rhs, lr, rl, (DefVar<?, ?>)lhs.ref(), lhs.ulift());
                    break block5;
                }
                case 1: {
                    CallTerm.Con lhs = (CallTerm.Con)term3;
                    if (!(preRhs instanceof CallTerm.Con)) {
                        n = 2;
                        continue block5;
                    }
                    CallTerm.Con rhs = (CallTerm.Con)preRhs;
                    if (lhs.ref() != rhs.ref()) {
                        term = null;
                        break block5;
                    }
                    term = this.visitCall(lhs, rhs, lr, rl, (DefVar<?, ?>)lhs.ref(), lhs.ulift());
                    break block5;
                }
                case 2: {
                    CallTerm.Prim lhs = (CallTerm.Prim)term3;
                    if (!(preRhs instanceof CallTerm.Prim)) {
                        n = 3;
                        continue block5;
                    }
                    CallTerm.Prim rhs = (CallTerm.Prim)preRhs;
                    if (lhs.ref() != rhs.ref()) {
                        term = null;
                        break block5;
                    }
                    term = this.visitCall(lhs, rhs, lr, rl, (DefVar<?, ?>)lhs.ref(), lhs.ulift());
                    break block5;
                }
                default: {
                    term = null;
                    break block5;
                }
            }
            break;
        }
        return term;
    }

    private <T> T checkParam(Term.Param l, Term.Param r, @Nullable Term type, Sub lr, Sub rl, Supplier<T> fail, Supplier<T> success) {
        if (l.explicit() != r.explicit()) {
            return fail.get();
        }
        if (!this.compare(l.type(), r.type(), lr, rl, type)) {
            return fail.get();
        }
        rl.map.put((Object)r.ref(), (Object)l.toTerm());
        lr.map.put((Object)l.ref(), (Object)r.toTerm());
        Object result = this.ctx.with(l, () -> this.ctx.with(r, success));
        rl.map.remove((Object)r.ref());
        lr.map.remove((Object)l.ref());
        return (T)result;
    }

    private <T> T checkParams(SeqView<Term.Param> l, SeqView<Term.Param> r, Sub lr, Sub rl, Supplier<T> fail, Supplier<T> success) {
        if (!l.sizeEquals(r)) {
            return fail.get();
        }
        if (l.isEmpty()) {
            return success.get();
        }
        return (T)this.checkParam((Term.Param)l.first(), (Term.Param)r.first(), null, lr, rl, fail, () -> this.checkParams((SeqView<Term.Param>)l.drop(1), (SeqView<Term.Param>)r.drop(1), lr, rl, fail, success));
    }

    private boolean visitArgs(SeqLike<Arg<Term>> l, SeqLike<Arg<Term>> r, Sub lr, Sub rl, SeqLike<Term.Param> params) {
        return this.visitLists((SeqLike<Term>)l.view().map(Arg::term), (SeqLike<Term>)r.view().map(Arg::term), lr, rl, params);
    }

    private boolean visitLists(SeqLike<Term> l, SeqLike<Term> r, Sub lr, Sub rl, @NotNull SeqLike<Term.Param> types) {
        if (!l.sizeEquals(r)) {
            return false;
        }
        if (!r.sizeEquals(types)) {
            return false;
        }
        SeqView typesSubst = types.view();
        ImmutableSeq lu = l.toImmutableSeq();
        ImmutableSeq ru = r.toImmutableSeq();
        int i = 0;
        while (lu.sizeGreaterThan(i)) {
            Term li = (Term)lu.get(i);
            Term.Param head = (Term.Param)typesSubst.first();
            if (!this.compare(li, (Term)ru.get(i), lr, rl, head.type())) {
                return false;
            }
            typesSubst = typesSubst.drop(1).map(type -> type.subst(head.ref(), li));
            ++i;
        }
        return true;
    }

    @Nullable
    private Term visitCall(@NotNull CallTerm lhs, @NotNull CallTerm rhs, Sub lr, Sub rl, @NotNull DefVar<?, ?> lhsRef, int ulift) {
        Term retType = this.getType(lhs, lhsRef);
        if (this.visitArgs((SeqLike<Arg<Term>>)lhs.args(), (SeqLike<Arg<Term>>)rhs.args(), lr, rl, (SeqLike<Term.Param>)Term.Param.subst(Def.defTele(lhsRef), ulift))) {
            return retType;
        }
        if (this.compareWHNF(lhs, rhs, lr, rl, retType)) {
            return retType;
        }
        return null;
    }

    @NotNull
    private Term getType(@NotNull CallTerm lhs, @NotNull DefVar<? extends Def, ?> lhsRef) {
        MutableMap substMap = MutableMap.create();
        for (Tuple2 pa : lhs.args().view().zip((Iterable)lhsRef.core.telescope().view())) {
            substMap.set((Object)((Term.Param)pa._2).ref(), (Object)((Term)((Arg)pa._1).term()));
        }
        return lhsRef.core.result().subst((Map<Var, ? extends Term>)substMap);
    }

    private static boolean isCall(@NotNull Term term) {
        return term instanceof CallTerm.Fn || term instanceof CallTerm.Con || term instanceof CallTerm.Prim;
    }

    @NotNull
    private TyckState.Eqn createEqn(@NotNull Term lhs, @NotNull Term rhs, Sub lr, Sub rl) {
        MapLocalCtx local = new MapLocalCtx();
        this.ctx.forward(local, lhs, this.state);
        this.ctx.forward(local, rhs, this.state);
        return new TyckState.Eqn(lhs, rhs, this.cmp, this.pos, local, lr.clone(), rl.clone());
    }

    @Nullable
    private Subst extract(@NotNull CallTerm.Hole lhs, @NotNull Term rhs, @NotNull Meta meta) {
        Subst subst = new Subst((MutableMap<Var, Term>)new MutableHashMap());
        for (Tuple2 arg : lhs.args().view().zip(meta.telescope)) {
            Term term = this.uneta.uneta((Term)((Arg)arg._1).term());
            if (term instanceof RefTerm) {
                RefTerm ref = (RefTerm)term;
                if (subst.map().containsKey((Object)ref.var())) {
                    return null;
                }
                subst.add(ref.var(), ((Term.Param)arg._2).toTerm());
                continue;
            }
            return null;
        }
        return subst;
    }

    private boolean doCompareTyped(@NotNull Term type, @NotNull Term lhs, @NotNull Term rhs, Sub lr, Sub rl) {
        this.traceEntrance(new Trace.UnifyT(lhs.freezeHoles(this.state), rhs.freezeHoles(this.state), this.pos, type.freezeHoles(this.state)));
        Term term = type;
        int n = 0;
        boolean ret = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CallTerm.Struct.class, IntroTerm.Lambda.class, CallTerm.Con.class, IntroTerm.Tuple.class, IntroTerm.New.class, ErrorTerm.class, FormTerm.Sigma.class, FormTerm.Pi.class}, (Object)term, n)) {
            default -> {
                if (this.compareUntyped(lhs, rhs, lr, rl) != null) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                CallTerm.Struct type1 = (CallTerm.Struct)term;
                ImmutableSeq<FieldDef> fieldSigs = ((StructDef)((DefVar)type1.ref()).core).fields;
                ImmutableMap paramSubst = ((StructDef)((DefVar)type1.ref()).core).telescope().view().zip((Iterable)type1.args().view()).map(x -> Tuple2.of((Object)((Term.Param)x._1).ref(), (Object)((Term)((Arg)x._2).term()))).toImmutableMap();
                Subst fieldSubst = new Subst((MutableMap<Var, Term>)MutableHashMap.create());
                for (FieldDef fieldSig : fieldSigs) {
                    ImmutableSeq dummyVars = fieldSig.selfTele.map(par -> new LocalVar(par.ref().name(), par.ref().definition()));
                    ImmutableSeq dummy = dummyVars.zip((Iterable)fieldSig.selfTele).map(vpa -> new Arg<RefTerm>(new RefTerm((LocalVar)vpa._1, 0), ((Term.Param)vpa._2).explicit()));
                    CallTerm.Access l = new CallTerm.Access(lhs, fieldSig.ref(), type1.args(), (ImmutableSeq<Arg<Term>>)dummy);
                    CallTerm.Access r = new CallTerm.Access(rhs, fieldSig.ref(), type1.args(), (ImmutableSeq<Arg<Term>>)dummy);
                    fieldSubst.add(fieldSig.ref(), l);
                    if (this.compare(l, r, lr, rl, fieldSig.result().subst((Map<Var, ? extends Term>)paramSubst).subst(fieldSubst))) continue;
                    yield false;
                }
                yield true;
            }
            case 1 -> {
                IntroTerm.Lambda $ = (IntroTerm.Lambda)term;
                throw new IllegalStateException("LamTerm is never type");
            }
            case 2 -> {
                CallTerm.Con $ = (CallTerm.Con)term;
                throw new IllegalStateException("ConCall is never type");
            }
            case 3 -> {
                IntroTerm.Tuple $ = (IntroTerm.Tuple)term;
                throw new IllegalStateException("TupTerm is never type");
            }
            case 4 -> {
                IntroTerm.New $ = (IntroTerm.New)term;
                throw new IllegalStateException("NewTerm is never type");
            }
            case 5 -> {
                ErrorTerm $ = (ErrorTerm)term;
                yield true;
            }
            case 6 -> {
                FormTerm.Sigma sigma = (FormTerm.Sigma)term;
                SeqView params = sigma.params().view();
                int size = sigma.params().size();
                for (int i = 1; i <= size; ++i) {
                    ElimTerm.Proj l = new ElimTerm.Proj(lhs, i);
                    Term.Param currentParam = (Term.Param)params.first();
                    this.ctx.put(currentParam);
                    if (!this.compare(l, new ElimTerm.Proj(rhs, i), lr, rl, currentParam.type())) {
                        yield false;
                    }
                    params = params.drop(1).map(x -> x.subst(currentParam.ref(), l));
                }
                this.ctx.remove((SeqView<LocalVar>)sigma.params().view().map(Term.Param::ref));
                yield true;
            }
            case -1, 7 -> {
                FormTerm.Pi pi = (FormTerm.Pi)term;
                yield this.ctx.with(pi.param(), () -> {
                    if (lhs instanceof IntroTerm.Lambda) {
                        IntroTerm.Lambda lambda = (IntroTerm.Lambda)lhs;
                        return this.ctx.with(lambda.param(), () -> {
                            if (rhs instanceof IntroTerm.Lambda) {
                                IntroTerm.Lambda rambda = (IntroTerm.Lambda)rhs;
                                return this.ctx.with(rambda.param(), () -> {
                                    lr.map.put((Object)lambda.param().ref(), (Object)rambda.param().toTerm());
                                    rl.map.put((Object)rambda.param().ref(), (Object)lambda.param().toTerm());
                                    return this.compare(lambda.body(), rambda.body(), lr, rl, pi.body());
                                });
                            }
                            return this.compare(lambda.body(), CallTerm.make(rhs, lambda.param().toArg()), lr, rl, pi.body());
                        });
                    }
                    if (rhs instanceof IntroTerm.Lambda) {
                        IntroTerm.Lambda rambda = (IntroTerm.Lambda)rhs;
                        return this.ctx.with(rambda.param(), () -> this.compare(CallTerm.make(lhs, rambda.param().toArg()), rambda.body(), lr, rl, pi.body()));
                    }
                    return this.compareUntyped(lhs, rhs, lr, rl) != null;
                });
            }
        };
        this.traceExit();
        return ret;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Term doCompareUntyped(@NotNull Term type, @NotNull Term preRhs, Sub lr, Sub rl) {
        this.traceEntrance(new Trace.UnifyT(type.freezeHoles(this.state), preRhs.freezeHoles(this.state), this.pos));
        var6_5 = type;
        var7_6 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefTerm.MetaPat.class, RefTerm.class, ElimTerm.App.class, ElimTerm.Proj.class, ErrorTerm.class, FormTerm.Pi.class, FormTerm.Sigma.class, FormTerm.Univ.class, CallTerm.Fn.class, CallTerm.Data.class, CallTerm.Struct.class, CallTerm.Con.class, CallTerm.Prim.class, CallTerm.Access.class, CallTerm.Hole.class}, (Object)var6_5, var7_6)) {
            default: {
                throw new IllegalStateException(type.getClass() + ": " + type);
            }
            case 0: {
                metaPat = (RefTerm.MetaPat)var6_5;
                lhsRef = metaPat.ref();
                if (preRhs instanceof RefTerm.MetaPat && lhsRef == (rPat = (RefTerm.MetaPat)preRhs).ref()) {
                    v0 /* !! */  = lhsRef.type();
                    break;
                }
                v0 /* !! */  = null;
                break;
            }
            case 1: {
                lhs = (RefTerm)var6_5;
                if (preRhs instanceof RefTerm && (((RefTerm)rl.map.getOrDefault((Object)(rhs = (RefTerm)preRhs).var(), (Object)rhs)).var() == lhs.var() || ((RefTerm)lr.map.getOrDefault((Object)lhs.var(), (Object)lhs)).var() == rhs.var())) {
                    v0 /* !! */  = this.ctx.get(lhs.var());
                    break;
                }
                v0 /* !! */  = null;
                break;
            }
            case 2: {
                lhs = (ElimTerm.App)var6_5;
                if (!(preRhs instanceof ElimTerm.App)) {
                    v0 /* !! */  = null;
                    break;
                }
                rhs = (ElimTerm.App)preRhs;
                preFnType = this.compareUntyped(lhs.of(), rhs.of(), lr, rl);
                if (!(preFnType instanceof FormTerm.Pi)) {
                    v0 /* !! */  = null;
                    break;
                }
                fnType = (FormTerm.Pi)preFnType;
                if (!this.compare(lhs.arg().term(), rhs.arg().term(), lr, rl, fnType.param().type())) {
                    v0 /* !! */  = null;
                    break;
                }
                v0 /* !! */  = fnType.substBody(lhs.arg().term());
                break;
            }
            case 3: {
                lhs = (ElimTerm.Proj)var6_5;
                if (!(preRhs instanceof ElimTerm.Proj)) {
                    v0 /* !! */  = null;
                    break;
                }
                rhs = (ElimTerm.Proj)preRhs;
                preTupType = this.compareUntyped(lhs.of(), rhs.of(), lr, rl);
                if (!(preTupType instanceof FormTerm.Sigma)) {
                    v0 /* !! */  = null;
                    break;
                }
                tupType = (FormTerm.Sigma)preTupType;
                if (lhs.ix() != rhs.ix()) {
                    v0 /* !! */  = null;
                    break;
                }
                params = tupType.params().view();
                subst = new Subst((MutableMap<Var, Term>)MutableMap.create());
                for (i = 1; i < lhs.ix(); ++i) {
                    l = new ElimTerm.Proj(lhs, i);
                    currentParam = (Term.Param)params.first();
                    subst.add(currentParam.ref(), l);
                    params = params.drop(1);
                }
                if (params.isNotEmpty()) {
                    v0 /* !! */  = ((Term.Param)params.first()).subst(subst).type();
                    break;
                }
                v0 /* !! */  = ((Term.Param)params.last()).subst(subst).type();
                break;
            }
            case 4: {
                term = (ErrorTerm)var6_5;
                v0 /* !! */  = ErrorTerm.typeOf(term.freezeHoles(this.state));
                break;
            }
            case 5: {
                lhs = (FormTerm.Pi)var6_5;
                if (!(preRhs instanceof FormTerm.Pi)) {
                    v0 /* !! */  = null;
                    break;
                }
                rhs = (FormTerm.Pi)preRhs;
                v0 /* !! */  = this.checkParam(lhs.param(), rhs.param(), null, lr, rl, (Supplier<FormTerm.Univ>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCompareUntyped$12(), ()Lorg/aya/core/term/FormTerm$Univ;)(), (Supplier<FormTerm.Univ>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCompareUntyped$13(org.aya.core.term.FormTerm$Pi org.aya.core.term.FormTerm$Pi org.aya.tyck.unify.DefEq$Sub org.aya.tyck.unify.DefEq$Sub ), ()Lorg/aya/core/term/FormTerm$Univ;)((DefEq)this, (FormTerm.Pi)lhs, (FormTerm.Pi)rhs, (Sub)lr, (Sub)rl));
                break;
            }
            case 6: {
                lhs = (FormTerm.Sigma)var6_5;
                if (!(preRhs instanceof FormTerm.Sigma)) {
                    v0 /* !! */  = null;
                    break;
                }
                rhs = (FormTerm.Sigma)preRhs;
                v0 /* !! */  = this.checkParams((SeqView<Term.Param>)lhs.params().view(), (SeqView<Term.Param>)rhs.params().view(), lr, rl, (Supplier<FormTerm.Univ>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCompareUntyped$14(), ()Lorg/aya/core/term/FormTerm$Univ;)(), (Supplier<FormTerm.Univ>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCompareUntyped$15(), ()Lorg/aya/core/term/FormTerm$Univ;)());
                break;
            }
            case 7: {
                lhs = (FormTerm.Univ)var6_5;
                if (!(preRhs instanceof FormTerm.Univ)) {
                    v0 /* !! */  = null;
                    break;
                }
                rhs = (FormTerm.Univ)preRhs;
                if (!this.compareLevel(lhs.lift(), rhs.lift())) {
                    v0 /* !! */  = null;
                    break;
                }
                v0 /* !! */  = new FormTerm.Univ((this.cmp == Ordering.Lt ? lhs : rhs).lift() + 1);
                break;
            }
            case 8: {
                lhs = (CallTerm.Fn)var6_5;
                v0 /* !! */  = null;
                break;
            }
            case 9: {
                lhs = (CallTerm.Data)var6_5;
                if (!(preRhs instanceof CallTerm.Data)) ** GOTO lbl106
                rhs = (CallTerm.Data)preRhs;
                if (lhs.ref() == rhs.ref()) ** GOTO lbl108
lbl106:
                // 2 sources

                v0 /* !! */  = null;
                break;
lbl108:
                // 1 sources

                args = this.visitArgs((SeqLike<Arg<Term>>)lhs.args(), (SeqLike<Arg<Term>>)rhs.args(), lr, rl, (SeqLike<Term.Param>)Term.Param.subst(Def.defTele(lhs.ref()), lhs.ulift()));
                if (args) {
                    v0 /* !! */  = FormTerm.Univ.ZERO;
                    break;
                }
                v0 /* !! */  = null;
                break;
            }
            case 10: {
                lhs = (CallTerm.Struct)var6_5;
                if (!(preRhs instanceof CallTerm.Struct)) ** GOTO lbl119
                rhs = (CallTerm.Struct)preRhs;
                if (lhs.ref() == rhs.ref()) ** GOTO lbl121
lbl119:
                // 2 sources

                v0 /* !! */  = null;
                break;
lbl121:
                // 1 sources

                args = this.visitArgs((SeqLike<Arg<Term>>)lhs.args(), (SeqLike<Arg<Term>>)rhs.args(), lr, rl, (SeqLike<Term.Param>)Term.Param.subst(Def.defTele(lhs.ref()), lhs.ulift()));
                if (args) {
                    v0 /* !! */  = FormTerm.Univ.ZERO;
                    break;
                }
                v0 /* !! */  = null;
                break;
            }
            case 11: {
                lhs = (CallTerm.Con)var6_5;
                if (!(preRhs instanceof CallTerm.Con)) ** GOTO lbl132
                rhs = (CallTerm.Con)preRhs;
                if (lhs.ref() == rhs.ref()) ** GOTO lbl134
lbl132:
                // 2 sources

                v0 /* !! */  = null;
                break;
lbl134:
                // 1 sources

                retType = this.getType(lhs, (DefVar<? extends Def, ?>)lhs.ref());
                if (this.visitArgs((SeqLike<Arg<Term>>)lhs.conArgs(), (SeqLike<Arg<Term>>)rhs.conArgs(), lr, rl, (SeqLike<Term.Param>)Term.Param.subst(CtorDef.conTele((DefVar<CtorDef, Decl.DataCtor>)lhs.ref()), lhs.ulift()))) {
                    v0 /* !! */  = retType;
                    break;
                }
                v0 /* !! */  = null;
                break;
            }
            case 12: {
                lhs = (CallTerm.Prim)var6_5;
                v0 /* !! */  = null;
                break;
            }
            case 13: {
                lhs = (CallTerm.Access)var6_5;
                if (!(preRhs instanceof CallTerm.Access)) {
                    v0 /* !! */  = null;
                    break;
                }
                rhs = (CallTerm.Access)preRhs;
                preStructType = this.compareUntyped(lhs.of(), rhs.of(), lr, rl);
                if (!(preStructType instanceof CallTerm.Struct)) {
                    v0 /* !! */  = null;
                    break;
                }
                structType = (CallTerm.Struct)preStructType;
                if (lhs.ref() != rhs.ref()) {
                    v0 /* !! */  = null;
                    break;
                }
                v0 /* !! */  = Def.defResult(lhs.ref());
                break;
            }
            case -1: 
            case 14: {
                lhs = (CallTerm.Hole)var6_5;
                v0 /* !! */  = this.solveMeta(preRhs, lr, rl, lhs);
            }
        }
        ret = v0 /* !! */ ;
        this.traceExit();
        return ret;
    }

    @Nullable
    private Term solveMeta(@NotNull Term preRhs, Sub lr, Sub rl, CallTerm.Hole lhs) {
        Subst argSubst;
        Meta meta = lhs.ref();
        if (preRhs instanceof CallTerm.Hole) {
            CallTerm.Hole rcall = (CallTerm.Hole)preRhs;
            if (lhs.ref() == rcall.ref()) {
                if (meta.result == null) {
                    return null;
                }
                this.compareLevel(lhs.ulift(), rcall.ulift());
                Term holeTy = FormTerm.Pi.make(meta.telescope, meta.result);
                for (Tuple2 arg : lhs.args().view().zip(rcall.args())) {
                    if (!(holeTy instanceof FormTerm.Pi)) {
                        throw new IllegalStateException("meta arg size larger than param size. this should not happen");
                    }
                    FormTerm.Pi holePi = (FormTerm.Pi)holeTy;
                    if (!this.compare((Term)((Arg)arg._1).term(), (Term)((Arg)arg._2).term(), lr, rl, holePi.param().type())) {
                        return null;
                    }
                    holeTy = holePi.substBody((Term)((Arg)arg._1).term());
                }
                return holeTy.subst(Subst.EMPTY, lhs.ulift());
            }
        }
        Term resultTy = preRhs.computeType(this.state, this.ctx);
        if (meta.result != null) {
            Term liftedType = meta.result.subst(Subst.EMPTY, lhs.ulift());
            this.compareUntyped(resultTy, liftedType, rl, lr);
        }
        if ((argSubst = this.extract(lhs, preRhs, meta)) == null) {
            this.reporter.report((Problem)new HoleProblem.BadSpineError(lhs, this.pos));
            return null;
        }
        Subst subst = Unfolder.buildSubst(meta.contextTele, lhs.contextArgs());
        if (!this.allowVague && subst.overlap(argSubst).anyMatch(var -> preRhs.findUsages((Var)var) > 0)) {
            this.state.addEqn(this.createEqn(lhs, preRhs, lr, rl));
            return resultTy;
        }
        subst.add(argSubst);
        rl.map.forEach(subst::add);
        assert (!this.state.metas().containsKey((Object)meta));
        Term solved = preRhs.freezeHoles(this.state).subst(subst, -lhs.ulift());
        ImmutableSeq allowedVars = meta.fullTelescope().map(Term.Param::ref).toImmutableSeq();
        VarConsumer.ScopeChecker scopeCheck = solved.scopeCheck((ImmutableSeq<LocalVar>)allowedVars);
        if (scopeCheck.invalid.isNotEmpty()) {
            solved = solved.normalize(this.state, NormalizeMode.NF);
            scopeCheck = solved.scopeCheck((ImmutableSeq<LocalVar>)allowedVars);
        }
        if (scopeCheck.invalid.isNotEmpty()) {
            this.reporter.report((Problem)new HoleProblem.BadlyScopedError(lhs, solved, (Seq<LocalVar>)scopeCheck.invalid, this.pos));
            return new ErrorTerm(solved);
        }
        if (scopeCheck.confused.isNotEmpty()) {
            if (this.allowConfused) {
                this.state.addEqn(this.createEqn(lhs, solved, lr, rl));
            } else {
                this.reporter.report((Problem)new HoleProblem.BadlyScopedError(lhs, solved, (Seq<LocalVar>)scopeCheck.confused, this.pos));
                return new ErrorTerm(solved);
            }
        }
        if (!meta.solve(this.state, solved)) {
            this.reporter.report((Problem)new HoleProblem.RecursionError(lhs, solved, this.pos));
            return new ErrorTerm(solved);
        }
        this.tracing(builder -> builder.append(new Trace.LabelT(this.pos, "Hole solved!")));
        return resultTy;
    }

    private boolean compareLevel(int l, int r) {
        switch (this.cmp) {
            case Eq: {
                if (l != r) {
                    this.reporter.report((Problem)new LevelError(this.pos, l, r, true));
                    return false;
                }
            }
            case Gt: {
                if (l < r) {
                    this.reporter.report((Problem)new LevelError(this.pos, l, r, false));
                    return false;
                }
            }
            case Lt: {
                if (l <= r) break;
                this.reporter.report((Problem)new LevelError(this.pos, r, l, false));
                return false;
            }
        }
        return true;
    }

    public void checkEqn(@NotNull TyckState.Eqn eqn) {
        this.compareUntyped(eqn.lhs().normalize(this.state, NormalizeMode.WHNF), eqn.rhs().normalize(this.state, NormalizeMode.WHNF), eqn.lr(), eqn.rl());
    }

    private static /* synthetic */ FormTerm.Univ lambda$doCompareUntyped$15() {
        return FormTerm.Univ.ZERO;
    }

    private static /* synthetic */ FormTerm.Univ lambda$doCompareUntyped$14() {
        return null;
    }

    private /* synthetic */ FormTerm.Univ lambda$doCompareUntyped$13(FormTerm.Pi lhs, FormTerm.Pi rhs, Sub lr, Sub rl) {
        boolean bodyIsOk = this.compare(lhs.body(), rhs.body(), lr, rl, null);
        if (!bodyIsOk) {
            return null;
        }
        return FormTerm.Univ.ZERO;
    }

    private static /* synthetic */ FormTerm.Univ lambda$doCompareUntyped$12() {
        return null;
    }

    public record FailureData(@NotNull Term lhs, @NotNull Term rhs) {
    }

    public record Sub(@NotNull @NotNull MutableMap<@NotNull Var, @NotNull RefTerm> map) implements Cloneable
    {
        public Sub() {
            this((MutableMap<Var, RefTerm>)MutableMap.create());
        }

        @NotNull
        public Sub clone() {
            return new Sub((MutableMap<Var, RefTerm>)MutableMap.from(this.map));
        }
    }
}

