/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import java.util.function.Function;
import kala.collection.SeqView;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.error.OperatorError;
import org.aya.generic.Constants;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.ResolveInfo;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.BinOpParser;
import org.aya.util.binop.BinOpSet;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinExprParser
extends BinOpParser<AyaBinOpSet, Expr, Expr.NamedArg> {
    @NotNull
    private final ResolveInfo resolveInfo;
    private static final Expr.NamedArg OP_APP = new Expr.NamedArg(true, BinOpSet.APP_ELEM.name(), new Expr.ErrorExpr(SourcePos.NONE, Doc.english((String)"fakeApp escaped from BinOpParser")));

    public BinExprParser(@NotNull ResolveInfo resolveInfo, @NotNull @NotNull SeqView<@NotNull Expr.NamedArg> seq) {
        super((BinOpSet)resolveInfo.opSet(), seq);
        this.resolveInfo = resolveInfo;
    }

    @NotNull
    protected Expr.NamedArg appOp() {
        return OP_APP;
    }

    @NotNull
    protected BinOpParser<AyaBinOpSet, Expr, Expr.NamedArg> replicate(@NotNull @NotNull SeqView<@NotNull Expr.NamedArg> seq) {
        return new BinExprParser(this.resolveInfo, seq);
    }

    protected void reportAmbiguousPred(String op1, String op2, SourcePos pos) {
        ((AyaBinOpSet)this.opSet).reporter.report((Problem)new OperatorError.Precedence(op1, op2, pos));
    }

    @NotNull
    protected Expr createErrorExpr(@NotNull SourcePos sourcePos) {
        return new Expr.ErrorExpr(sourcePos, Doc.english((String)"an application"));
    }

    protected void reportFixityError(Assoc top, Assoc current, String topOp, String currentOp, SourcePos pos) {
        ((AyaBinOpSet)this.opSet).reporter.report((Problem)new OperatorError.Fixity(currentOp, current, topOp, top, pos));
    }

    @Nullable
    protected OpDecl underlyingOpDecl(@NotNull Expr.NamedArg elem) {
        OpDecl opDecl;
        Expr.RefExpr ref;
        AnyVar anyVar;
        Expr expr = elem.expr();
        while (expr instanceof Expr.LiftExpr) {
            Expr.LiftExpr lift = (Expr.LiftExpr)expr;
            expr = lift.expr();
        }
        if (expr instanceof Expr.RefExpr && (anyVar = (ref = (Expr.RefExpr)expr).resolvedVar()) instanceof DefVar) {
            DefVar defVar = (DefVar)anyVar;
            opDecl = defVar.resolveOpDecl(this.resolveInfo.thisModule().moduleName());
        } else {
            opDecl = null;
        }
        return opDecl;
    }

    @NotNull
    protected Expr.NamedArg makeArg(@NotNull SourcePos pos, @NotNull Expr func, @NotNull Expr.NamedArg arg, boolean explicit) {
        return new Expr.NamedArg(explicit, new Expr.AppExpr(pos, func, arg));
    }

    @NotNull
    public Expr.NamedArg makeSectionApp(@NotNull SourcePos pos, @NotNull Expr.NamedArg op, @NotNull Function<Expr.NamedArg, Expr> lamBody) {
        LocalVar missing = Constants.randomlyNamed(op.expr().sourcePos());
        Expr.NamedArg missingElem = new Expr.NamedArg(true, new Expr.RefExpr(SourcePos.NONE, missing));
        Expr.Param missingParam = new Expr.Param(missing.definition(), missing, true);
        Expr.LamExpr term = new Expr.LamExpr(pos, missingParam, lamBody.apply(missingElem));
        return new Expr.NamedArg(op.explicit(), term);
    }
}

