/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.aya.concrete.Expr;
import org.jetbrains.annotations.NotNull;

public interface ExprTraversal<P> {
    @NotNull
    default public Expr visitExpr(@NotNull Expr expr, P p) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.AppExpr.class, Expr.NewExpr.class, Expr.BinOpSeq.class, Expr.SigmaExpr.class, Expr.LamExpr.class, Expr.TupExpr.class, Expr.ProjExpr.class, Expr.LiftExpr.class, Expr.HoleExpr.class, Expr.PiExpr.class, Expr.PartEl.class, Expr.Path.class}, (Object)expr3, n)) {
            case 0: {
                Expr.AppExpr app = (Expr.AppExpr)expr3;
                this.visitExpr(app.function(), p);
                this.visitExpr(app.argument().expr(), p);
                break;
            }
            case 1: {
                Expr.NewExpr neo = (Expr.NewExpr)expr3;
                neo.fields().forEach(e -> this.visitExpr(e.body(), p));
                this.visitExpr(neo.struct(), p);
                break;
            }
            case 2: {
                Expr.BinOpSeq seq = (Expr.BinOpSeq)expr3;
                seq.seq().forEach(e -> this.visitExpr(e.expr(), p));
                break;
            }
            case 3: {
                Expr.SigmaExpr sig = (Expr.SigmaExpr)expr3;
                sig.params().forEach(e -> this.visitParam((Expr.Param)e, p));
                break;
            }
            case 4: {
                Expr.LamExpr lamExpr = (Expr.LamExpr)expr3;
                this.visitParam(lamExpr.param(), p);
                this.visitExpr(lamExpr.body(), p);
                break;
            }
            case 5: {
                Expr.TupExpr tup = (Expr.TupExpr)expr3;
                tup.items().forEach(i -> this.visitExpr((Expr)i, p));
                break;
            }
            case 6: {
                Expr.ProjExpr proj = (Expr.ProjExpr)expr3;
                this.visitExpr(proj.tup(), p);
                break;
            }
            case 7: {
                Expr.LiftExpr lift = (Expr.LiftExpr)expr3;
                this.visitExpr(lift.expr(), p);
                break;
            }
            case 8: {
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                if (hole.filling() == null) break;
                this.visitExpr(hole.filling(), p);
                break;
            }
            case 9: {
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                this.visitParam(pi.param(), p);
                this.visitExpr(pi.last(), p);
                break;
            }
            case 10: {
                Expr.PartEl el = (Expr.PartEl)expr3;
                el.clauses().forEach(cl -> {
                    this.visitExpr((Expr)cl._1, p);
                    this.visitExpr((Expr)cl._2, p);
                });
                break;
            }
            case 11: {
                Expr.Path path = (Expr.Path)expr3;
                this.visitExpr(path.type(), p);
                this.visitExpr(path.partial(), p);
                break;
            }
        }
        return expr;
    }

    @NotNull
    default public Expr visitParam(Expr.Param e, P pp) {
        return this.visitExpr(e.type(), pp);
    }
}

