/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.ClassDecl;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.concrete.visitor.ExprTraversal;
import org.jetbrains.annotations.NotNull;

public interface StmtOps<P>
extends ExprTraversal<P> {
    default public <T extends Decl> void traced(@NotNull T yeah, P p, @NotNull BiConsumer<T, P> f) {
        this.traceEntrance(yeah, p);
        f.accept(yeah, p);
        this.traceExit(p);
    }

    default public void traceEntrance(@NotNull Decl item, P p) {
    }

    default public void traceExit(P p) {
    }

    default public void visitTelescopic(@NotNull Decl decl, @NotNull Decl.Telescopic proof, P pp) {
        if (!1.$assertionsDisabled && decl != proof) {
            throw new AssertionError();
        }
        proof.setTelescope((ImmutableSeq<Expr.Param>)proof.telescope().map(p -> p.mapExpr(expr -> this.visitExpr((Expr)expr, pp))));
    }

    default public void visit(@NotNull Stmt stmt, P pp) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Remark.class, Decl.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Remark remark = (Remark)stmt3;
                if (remark.literate == null) break;
                remark.literate.modify(expr -> this.visitExpr((Expr)expr, pp));
                break;
            }
            case 1: {
                Decl decl = (Decl)stmt3;
                this.visitDecl(decl, pp);
                break;
            }
            case 2: {
                Command cmd = (Command)stmt3;
                this.visitCommand(cmd, pp);
                break;
            }
            case 3: {
                Generalize generalize = (Generalize)stmt3;
                generalize.type = this.visitExpr(generalize.type, pp);
            }
        }
    }

    default public void visitCommand(@NotNull Command cmd, P pp) {
        Command command = cmd;
        Objects.requireNonNull(command);
        Command command2 = command;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, Command.Import.class, Command.Open.class}, (Object)command2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Command.Module moduleCmd = (Command.Module)command2;
                moduleCmd.contents().forEach(stmt -> this.visit((Stmt)stmt, pp));
                break;
            }
            case 1: {
                Command.Import importCmd = (Command.Import)command2;
                break;
            }
            case 2: {
                Command.Open open = (Command.Open)command2;
            }
        }
    }

    default public void visitDecl(@NotNull Decl decl, P pp) {
        if (decl instanceof Decl.Telescopic) {
            Decl.Telescopic teleDecl = (Decl.Telescopic)((Object)decl);
            this.visitTelescopic(decl, teleDecl, pp);
        }
        if (decl instanceof Decl.Resulted) {
            Decl.Resulted resulted = (Decl.Resulted)((Object)decl);
            resulted.setResult(this.visitExpr(resulted.result(), pp));
        }
        Decl decl2 = decl;
        Objects.requireNonNull(decl2);
        Decl decl3 = decl2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.PrimDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.FnDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class}, (Object)decl3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                ClassDecl classDecl = (ClassDecl)decl3;
                break;
            }
            case 1: {
                TeleDecl.PrimDecl prim = (TeleDecl.PrimDecl)decl3;
                break;
            }
            case 2: {
                TeleDecl.DataDecl data = (TeleDecl.DataDecl)decl3;
                data.body.forEach(ctor -> this.traced((Decl)ctor, pp, this::visitDecl));
                break;
            }
            case 3: {
                TeleDecl.StructDecl struct = (TeleDecl.StructDecl)decl3;
                struct.fields.forEach(field -> this.traced((Decl)field, pp, this::visitDecl));
                break;
            }
            case 4: {
                TeleDecl.FnDecl fn = (TeleDecl.FnDecl)decl3;
                fn.body = fn.body.map(expr -> this.visitExpr((Expr)expr, pp), clauses -> clauses.map(clause -> this.visitClause((Pattern.Clause)clause, pp)));
                break;
            }
            case 5: {
                TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)decl3;
                ctor2.patterns = ctor2.patterns.map(pat -> this.visitPattern((Pattern)pat, pp));
                ctor2.clauses = ctor2.clauses.map(clause -> this.visitClause((Pattern.Clause)clause, pp));
                break;
            }
            case 6: {
                TeleDecl.StructField field2 = (TeleDecl.StructField)decl3;
                field2.body = field2.body.map(expr -> this.visitExpr((Expr)expr, pp));
            }
        }
    }

    @NotNull
    default public Pattern.Clause visitClause(@NotNull Pattern.Clause c, P pp) {
        return new Pattern.Clause(c.sourcePos, (ImmutableSeq<Pattern>)c.patterns.map(p -> this.visitPattern((Pattern)p, pp)), (Option<Expr>)c.expr.map(expr -> this.visitExpr((Expr)expr, pp)));
    }

    @NotNull
    default public Pattern visitPattern(@NotNull Pattern pattern, P pp) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.BinOpSeq.class, Pattern.Ctor.class, Pattern.Tuple.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.BinOpSeq seq = (Pattern.BinOpSeq)pattern3;
                yield this.visitBinOpPattern(seq, pp);
            }
            case 1 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                yield new Pattern.Ctor(ctor.sourcePos(), ctor.explicit(), ctor.resolved(), (ImmutableSeq<Pattern>)ctor.params().map(p -> this.visitPattern((Pattern)p, pp)), ctor.as());
            }
            case 2 -> {
                Pattern.Tuple tup = (Pattern.Tuple)pattern3;
                yield new Pattern.Tuple(tup.sourcePos(), tup.explicit(), (ImmutableSeq<Pattern>)tup.patterns().map(p -> this.visitPattern((Pattern)p, pp)), tup.as());
            }
            default -> pattern;
        };
    }

    @NotNull
    default public Pattern visitBinOpPattern(@NotNull Pattern.BinOpSeq seq, P pp) {
        return new Pattern.BinOpSeq(seq.sourcePos(), (ImmutableSeq<Pattern>)seq.seq().map(p -> this.visitPattern((Pattern)p, pp)), seq.as(), seq.explicit());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

