/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.def;

import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.GenericDef;
import org.aya.core.term.FormTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.distill.CoreDistiller;
import org.aya.generic.AyaDocile;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Def
extends AyaDocile,
GenericDef {
    @NotNull
    public static Term defType(@NotNull DefVar<? extends Def, ? extends Decl.Telescopic> defVar) {
        return FormTerm.Pi.make(Def.defTele(defVar), Def.defResult(defVar));
    }

    @NotNull
    public static ImmutableSeq<Term.Param> defTele(@NotNull DefVar<? extends Def, ? extends Decl.Telescopic> defVar) {
        if (defVar.core != null) {
            return ((Def)defVar.core).telescope();
        }
        return Objects.requireNonNull(((Decl.Telescopic)defVar.concrete).signature()).param;
    }

    @NotNull
    public static Seq<CtorDef> dataBody(@NotNull DefVar<? extends DataDef, ? extends TeleDecl.DataDecl> defVar) {
        if (defVar.core != null) {
            return ((DataDef)defVar.core).body;
        }
        return ((TeleDecl.DataDecl)defVar.concrete).checkedBody;
    }

    @NotNull
    public static Term defResult(@NotNull DefVar<? extends Def, ? extends Decl.Telescopic> defVar) {
        if (defVar.core != null) {
            return ((Def)defVar.core).result();
        }
        return Objects.requireNonNull(((Decl.Telescopic)defVar.concrete).signature()).result;
    }

    @NotNull
    public static ImmutableSeq<Term.Param> substParams(@NotNull @NotNull SeqLike<@NotNull Term.Param> param, @NotNull Subst subst) {
        return param.view().drop(1).map(p -> p.subst(subst)).toImmutableSeq();
    }

    @NotNull
    public DefVar<? extends Def, ? extends Decl> ref();

    @NotNull
    public ImmutableSeq<Term.Param> telescope();

    @Override
    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new CoreDistiller(options).def(this);
    }

    public record Signature(@NotNull @NotNull ImmutableSeq<@NotNull Term.Param> param, @NotNull Term result) implements AyaDocile
    {
        @Contract(value="_ -> new")
        @NotNull
        public Signature inst(@NotNull Subst subst) {
            return new Signature(Def.substParams(this.param, subst), this.result.subst(subst));
        }

        @Override
        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.sep((SeqLike)this.param.view().map(p -> p.toDoc(options))), Doc.symbol((String)"->"), this.result.toDoc(options)});
        }
    }
}

