/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.def;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import kala.collection.Map;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.Def;
import org.aya.core.def.TopLevelDef;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.generic.util.NormalizeMode;
import org.aya.guest0x0.cubical.CofThy;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrimDef
extends TopLevelDef<Term> {
    @NotNull
    public final @NotNull DefVar<@NotNull PrimDef, TeleDecl.PrimDecl> ref;
    @NotNull
    public final ID id;

    public PrimDef(@NotNull @NotNull DefVar<@NotNull PrimDef, @NotNull TeleDecl.PrimDecl> ref, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull Term result, @NotNull ID name) {
        super(telescope, result);
        this.ref = ref;
        this.id = name;
        ref.core = this;
    }

    public PrimDef(@NotNull @NotNull DefVar<@NotNull PrimDef, @NotNull TeleDecl.PrimDecl> ref, @NotNull Term result, @NotNull ID name) {
        this(ref, (ImmutableSeq<Term.Param>)ImmutableSeq.empty(), result, name);
    }

    @Override
    @NotNull
    public ImmutableSeq<Term.Param> telescope() {
        Def.Signature signature;
        if (this.telescope.isEmpty()) {
            return this.telescope;
        }
        if (this.ref.concrete != null && (signature = ((TeleDecl.PrimDecl)this.ref.concrete).signature) != null) {
            return signature.param();
        }
        return this.telescope;
    }

    @Override
    @NotNull
    public Term result() {
        Def.Signature signature;
        if (this.ref.concrete != null && (signature = ((TeleDecl.PrimDecl)this.ref.concrete).signature) != null) {
            return signature.result();
        }
        return this.result;
    }

    @NotNull
    public static FormTerm.Pi familyLeftToRight(Term term) {
        return new FormTerm.Pi(new Term.Param(LocalVar.IGNORED, new ElimTerm.App(term, new Arg<Term>(PrimTerm.Mula.LEFT, true)), true), new ElimTerm.App(term, new Arg<Term>(PrimTerm.Mula.RIGHT, true)));
    }

    @NotNull
    public static Term intervalToA() {
        Term.Param paramI = new Term.Param(LocalVar.IGNORED, PrimTerm.Interval.INSTANCE, true);
        return new FormTerm.Pi(paramI, new FormTerm.Type(0));
    }

    @NotNull
    public @NotNull DefVar<@NotNull PrimDef, TeleDecl.PrimDecl> ref() {
        return this.ref;
    }

    public static enum ID {
        IMIN("intervalMin"),
        IMAX("intervalMax"),
        INVOL("intervalInv"),
        STRING("String"),
        STRCONCAT("strcat"),
        I("I"),
        PARTIAL("Partial"),
        COE("coe");

        @NotNull
        @NonNls
        public final String id;

        public String toString() {
            return this.id;
        }

        @Nullable
        public static ID find(@NotNull String id) {
            for (ID value : ID.values()) {
                if (!Objects.equals(value.id, id)) continue;
                return value;
            }
            return null;
        }

        private ID(String id) {
            this.id = id;
        }
    }

    public static class Factory {
        @NotNull
        private final @NotNull EnumMap<@NotNull ID, @NotNull PrimDef> defs = new EnumMap(ID.class);
        @NotNull
        private final @NotNull Map<@NotNull ID, @NotNull PrimSeed> seeds;

        public Factory() {
            Initializer init = new Initializer();
            this.seeds = ImmutableSeq.of((Object[])new PrimSeed[]{init.intervalMin, init.intervalMax, init.intervalInv, init.stringType, init.stringConcat, init.intervalType, init.partialType, init.coerce}).map(seed -> Tuple.of((Object)((Object)seed.name), (Object)seed)).toImmutableMap();
        }

        @NotNull
        public PrimDef factory(@NotNull ID name, @NotNull DefVar<PrimDef, TeleDecl.PrimDecl> ref) {
            assert (!this.have(name));
            PrimDef rst = ((PrimSeed)this.seeds.get((Object)name)).supply(ref);
            this.defs.put(name, rst);
            return rst;
        }

        @NotNull
        public CallTerm.Prim getCall(@NotNull ID id, @NotNull ImmutableSeq<Arg<Term>> args) {
            return new CallTerm.Prim(((PrimDef)this.getOption(id).get()).ref(), 0, args);
        }

        @NotNull
        public CallTerm.Prim getCall(@NotNull ID id) {
            return this.getCall(id, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
        }

        @NotNull
        public Option<PrimDef> getOption(@NotNull ID name) {
            return Option.ofNullable((Object)this.defs.get((Object)name));
        }

        public boolean have(@NotNull ID name) {
            return this.defs.containsKey((Object)name);
        }

        public boolean suppressRedefinition() {
            return false;
        }

        @NotNull
        public PrimDef getOrCreate(@NotNull ID name, @NotNull DefVar<PrimDef, TeleDecl.PrimDecl> ref) {
            return (PrimDef)this.getOption(name).getOrElse(() -> this.factory(name, ref));
        }

        @NotNull
        public @NotNull Option<ImmutableSeq<@NotNull ID>> checkDependency(@NotNull ID name) {
            return this.seeds.getOption((Object)name).map(seed -> seed.dependency().filterNot(this::have));
        }

        @NotNull
        public Term unfold(@NotNull ID name, @NotNull CallTerm.Prim primCall, @NotNull TyckState state) {
            return (Term)((PrimSeed)this.seeds.get((Object)((Object)name))).unfold.apply(primCall, state);
        }

        public void clear() {
            this.defs.clear();
        }

        public void clear(@NotNull ID name) {
            this.defs.remove((Object)name);
        }

        private final class Initializer {
            @NotNull
            public final PrimSeed coerce = new PrimSeed(ID.COE, this::coe, ref -> {
                LocalVar varA = new LocalVar("A");
                Term.Param paramA = new Term.Param(varA, PrimDef.intervalToA(), true);
                Term.Param paramRestr = new Term.Param(new LocalVar("i"), PrimTerm.Interval.INSTANCE, true);
                FormTerm.Pi result = PrimDef.familyLeftToRight(new RefTerm(varA));
                return new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)paramA, (Object)paramRestr), result, ID.COE);
            }, (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));
            @NotNull
            public final PrimSeed intervalMin = this.formula(ID.IMIN, prim -> {
                ImmutableSeq<Arg<Term>> args = prim.args();
                return PrimTerm.Mula.and((Term)((Arg)args.first()).term(), (Term)((Arg)args.last()).term());
            }, "i", "j");
            @NotNull
            public final PrimSeed intervalMax = this.formula(ID.IMAX, prim -> {
                ImmutableSeq<Arg<Term>> args = prim.args();
                return PrimTerm.Mula.or((Term)((Arg)args.first()).term(), (Term)((Arg)args.last()).term());
            }, "i", "j");
            @NotNull
            public final PrimSeed intervalInv = this.formula(ID.INVOL, prim -> PrimTerm.Mula.inv((Term)((Arg)prim.args().first()).term()), "i");
            @NotNull
            public final PrimSeed stringType = new PrimSeed(ID.STRING, (prim, tyckState) -> prim, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, FormTerm.Type.ZERO, ID.STRING), (ImmutableSeq<ID>)ImmutableSeq.empty());
            @NotNull
            public final PrimSeed stringConcat = new PrimSeed(ID.STRCONCAT, Initializer::concat, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)new Term.Param(new LocalVar("str1"), Factory.this.getCall(ID.STRING, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty()), true), (Object)new Term.Param(new LocalVar("str2"), Factory.this.getCall(ID.STRING, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty()), true)), Factory.this.getCall(ID.STRING, (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty()), ID.STRCONCAT), (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.STRING)));
            @NotNull
            public final PrimSeed intervalType = new PrimSeed(ID.I, (prim, state) -> PrimTerm.Interval.INSTANCE, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, FormTerm.ISet.INSTANCE, ID.I), (ImmutableSeq<ID>)ImmutableSeq.empty());
            @NotNull
            public final PrimSeed partialType = new PrimSeed(ID.PARTIAL, (prim, state) -> {
                Term iExp = (Term)((Arg)prim.args().get(0)).term();
                Term ty = (Term)((Arg)prim.args().get(1)).term();
                return new FormTerm.PartTy(ty, (Restr<Term>)CofThy.isOne((Restr.TermLike)iExp));
            }, ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object)new Term.Param(new LocalVar("phi"), PrimTerm.Interval.INSTANCE, true), (Object)new Term.Param(new LocalVar("A"), FormTerm.Type.ZERO, true)), FormTerm.Type.ZERO, ID.PARTIAL), (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));

            private Initializer() {
            }

            private Term coe(@NotNull CallTerm.Prim prim, @NotNull TyckState state) {
                Term type = (Term)((Arg)prim.args().get(0)).term();
                Term restr = (Term)((Arg)prim.args().get(1)).term();
                return new PrimTerm.Coe(type, (Restr<Term>)CofThy.isOne((Restr.TermLike)restr));
            }

            @NotNull
            private PrimSeed formula(ID id, Function<CallTerm.Prim, Term> unfold, String ... tele) {
                return new PrimSeed(id, (prim, state) -> (Term)unfold.apply((CallTerm.Prim)prim), ref -> new PrimDef((DefVar<PrimDef, TeleDecl.PrimDecl>)ref, (ImmutableSeq<Term.Param>)ImmutableSeq.of((Object[])tele).map(n -> new Term.Param(new LocalVar((String)n), PrimTerm.Interval.INSTANCE, true)), PrimTerm.Interval.INSTANCE, id), (ImmutableSeq<ID>)ImmutableSeq.of((Object)((Object)ID.I)));
            }

            @NotNull
            private static Term concat( @NotNull CallTerm.Prim prim, @NotNull TyckState state) {
                Term first = ((Term)((Arg)prim.args().get(0)).term()).normalize(state, NormalizeMode.WHNF);
                Term second = ((Term)((Arg)prim.args().get(1)).term()).normalize(state, NormalizeMode.WHNF);
                if (first instanceof PrimTerm.Str) {
                    PrimTerm.Str str1 = (PrimTerm.Str)first;
                    if (second instanceof PrimTerm.Str) {
                        PrimTerm.Str str2 = (PrimTerm.Str)second;
                        return new PrimTerm.Str(str1.string() + str2.string());
                    }
                }
                return new CallTerm.Prim((DefVar<PrimDef, TeleDecl.PrimDecl>)prim.ref(), prim.ulift(), (ImmutableSeq<Arg<Term>>)ImmutableSeq.of(new Arg<Term>(first, true), new Arg<Term>(second, true)));
            }
        }
    }

    record PrimSeed(@NotNull ID name, @NotNull Unfolder unfold, @NotNull @NotNull Function<@NotNull DefVar<PrimDef, TeleDecl.PrimDecl>, @NotNull PrimDef> supplier, @NotNull @NotNull ImmutableSeq<@NotNull ID> dependency) {
        @NotNull
        public PrimDef supply(@NotNull DefVar<PrimDef, TeleDecl.PrimDecl> ref) {
            return this.supplier.apply(ref);
        }
    }

    @FunctionalInterface
    static interface Unfolder
    extends BiFunction<CallTerm.Prim, TyckState, Term> {
    }
}

