/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.pat;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.pat.PatToTerm;
import org.aya.core.repr.AyaShape;
import org.aya.core.term.CallTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.distill.BaseDistiller;
import org.aya.distill.CoreDistiller;
import org.aya.generic.Arg;
import org.aya.generic.AyaDocile;
import org.aya.generic.Shaped;
import org.aya.generic.util.InternalException;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.Tycker;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.env.SeqLocalCtx;
import org.aya.util.distill.DistillerOptions;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Debug.Renderer(text="toTerm().toDoc(DistillerOptions.debug()).debugRender()")
public interface Pat
extends AyaDocile {
    public boolean explicit();

    @NotNull
    default public Term toTerm() {
        return PatToTerm.INSTANCE.visit(this);
    }

    @NotNull
    public Expr toExpr(@NotNull SourcePos var1);

    @NotNull
    default public Arg<Term> toArg() {
        return new Arg<Term>(this.toTerm(), this.explicit());
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new CoreDistiller(options).pat(this, BaseDistiller.Outer.Free);
    }

    @NotNull
    public Pat rename(@NotNull Subst var1, @NotNull LocalCtx var2, boolean var3);

    @NotNull
    public Pat zonk(@NotNull Tycker var1);

    @NotNull
    public Pat inline(@Nullable LocalCtx var1);

    public void storeBindings(@NotNull LocalCtx var1);

    @NotNull
    public static ImmutableSeq<Term.Param> extractTele(@NotNull SeqLike<Pat> pats) {
        SeqLocalCtx localCtx = new SeqLocalCtx();
        for (Pat pat : pats) {
            pat.storeBindings(localCtx);
        }
        return localCtx.extract();
    }

    public record Preclause<T extends AyaDocile>(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Pat> patterns, @NotNull Option<T> expr) implements AyaDocile
    {
        @Override
        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            CoreDistiller distiller = new CoreDistiller(options);
            SeqView pats = (Boolean)options.map.get(DistillerOptions.Key.ShowImplicitPats) != false ? this.patterns : this.patterns.view().filter(Pat::explicit);
            Doc doc = Doc.emptyIf((boolean)pats.isEmpty(), () -> Preclause.lambda$toDoc$1((SeqLike)pats, distiller));
            if (this.expr.isDefined()) {
                return Doc.sep((Doc[])new Doc[]{doc, Doc.symbol((String)"=>"), ((AyaDocile)this.expr.get()).toDoc(options)});
            }
            return doc;
        }

        @NotNull
        public static Preclause<Term> weaken(@NotNull Matching clause) {
            return new Preclause<Term>(clause.sourcePos(), clause.patterns(), Option.some((Object)clause.body()));
        }

        @NotNull
        public static @NotNull Option<@NotNull Matching> lift(@NotNull Preclause<Term> clause) {
            return clause.expr.map(term -> new Matching(clause.sourcePos, clause.patterns, (Term)term));
        }

        private static /* synthetic */ Doc lambda$toDoc$1(SeqLike pats, CoreDistiller distiller) {
            return Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.commaList((SeqLike)pats.view().map(p -> distiller.pat((Pat)p, BaseDistiller.Outer.Free)))});
        }
    }

    public static final class ShapedInt
    extends Record
    implements Pat,
    Shaped.Inductively<Pat> {
        private final int repr;
        @NotNull
        private final AyaShape shape;
        @NotNull
        private final CallTerm.Data type;
        private final boolean explicit;

        public ShapedInt(int repr, @NotNull AyaShape shape, @NotNull CallTerm.Data type, boolean explicit) {
            this.repr = repr;
            this.shape = shape;
            this.type = type;
            this.explicit = explicit;
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.LitIntExpr(pos, this.repr);
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            return this;
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new ShapedInt(this.repr, this.shape, (CallTerm.Data)tycker.zonk(this.type), this.explicit);
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return this;
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
        }

        @Override
        @NotNull
        public Pat makeZero(@NotNull CtorDef zero) {
            return new Ctor(this.explicit, zero.ref, (ImmutableSeq<Pat>)ImmutableSeq.empty(), this.type);
        }

        @Override
        @NotNull
        public Pat makeSuc(@NotNull CtorDef suc, @NotNull Pat pat) {
            return new Ctor(this.explicit, suc.ref, (ImmutableSeq<Pat>)ImmutableSeq.of((Object)pat), this.type);
        }

        @Override
        @NotNull
        public Pat destruct(int repr) {
            return new ShapedInt(repr, this.shape, this.type, true);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShapedInt.class, "repr;shape;type;explicit", "repr", "shape", "type", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShapedInt.class, "repr;shape;type;explicit", "repr", "shape", "type", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShapedInt.class, "repr;shape;type;explicit", "repr", "shape", "type", "explicit"}, this, o);
        }

        @Override
        public int repr() {
            return this.repr;
        }

        @Override
        @NotNull
        public AyaShape shape() {
            return this.shape;
        }

        @Override
        @NotNull
        public CallTerm.Data type() {
            return this.type;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }

    public record End(boolean isLeft, boolean explicit) implements Pat
    {
        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.LitIntExpr(pos, this.isLeft ? 0 : 1);
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            return this;
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return this;
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return this;
        }

        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
        }
    }

    public record Ctor(boolean explicit, @NotNull DefVar<CtorDef, TeleDecl.DataCtor> ref, @NotNull ImmutableSeq<Pat> params, @NotNull CallTerm.Data type) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
            this.params.forEach(pat -> pat.storeBindings(ctx));
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return (Expr)this.params.foldLeft((Object)new Expr.RefExpr(pos, this.ref), (f, pat) -> new Expr.AppExpr(pos, (Expr)f, new Expr.NamedArg(pat.explicit(), pat.toExpr(pos))));
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            ImmutableSeq params = this.params.map(pat -> pat.rename(subst, localCtx, pat.explicit()));
            return new Ctor(explicit, this.ref, (ImmutableSeq<Pat>)params, (CallTerm.Data)this.type.subst(subst));
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new Ctor(this.explicit, this.ref, (ImmutableSeq<Pat>)this.params.map(pat -> pat.zonk(tycker)), (CallTerm.Data)tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return new Ctor(this.explicit, this.ref, (ImmutableSeq<Pat>)this.params.map(p -> p.inline(ctx)), this.type);
        }
    }

    public record Tuple(boolean explicit, @NotNull ImmutableSeq<Pat> pats) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
            this.pats.forEach(pat -> pat.storeBindings(ctx));
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.TupExpr(pos, (ImmutableSeq<Expr>)this.pats.map(pat -> pat.toExpr(pos)));
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            ImmutableSeq params = this.pats.map(pat -> pat.rename(subst, localCtx, pat.explicit()));
            return new Tuple(explicit, (ImmutableSeq<Pat>)params);
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new Tuple(this.explicit, (ImmutableSeq<Pat>)this.pats.map(pat -> pat.zonk(tycker)));
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return new Tuple(this.explicit, (ImmutableSeq<Pat>)this.pats.map(p -> p.inline(ctx)));
        }
    }

    public record Absurd(boolean explicit) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
            throw new InternalException("unreachable");
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.RefExpr(pos, new LocalVar("()", SourcePos.NONE));
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            throw new InternalException();
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return this;
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return this;
        }
    }

    public record Meta(boolean explicit, @NotNull MutableValue<Pat> solution, @NotNull LocalVar fakeBind, @NotNull Term type) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.MetaPat(pos, this);
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            throw new InternalException("unreachable");
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            Pat value = (Pat)this.solution.get();
            if (value == null) {
                Bind bind = new Bind(this.explicit, this.fakeBind, this.type);
                assert (ctx != null) : "Pre-inline patterns must be inlined with ctx";
                this.solution.set((Object)bind);
                ctx.put(this.fakeBind, this.type);
                return bind;
            }
            return value;
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            throw new InternalException("unreachable");
        }
    }

    public record Bind(boolean explicit, @NotNull LocalVar bind, @NotNull Term type) implements Pat
    {
        @Override
        public void storeBindings(@NotNull LocalCtx ctx) {
            ctx.put(this.bind, this.type);
        }

        @Override
        @NotNull
        public Expr toExpr(@NotNull SourcePos pos) {
            return new Expr.RefExpr(pos, this.bind);
        }

        @Override
        @NotNull
        public Pat rename(@NotNull Subst subst, @NotNull LocalCtx localCtx, boolean explicit) {
            LocalVar newName = new LocalVar(this.bind.name(), this.bind.definition());
            Bind newBind = new Bind(explicit, newName, this.type.subst(subst));
            subst.addDirectly(this.bind, new RefTerm(newName));
            localCtx.put(newName, this.type);
            return newBind;
        }

        @Override
        @NotNull
        public Pat zonk(@NotNull Tycker tycker) {
            return new Bind(this.explicit, this.bind, tycker.zonk(this.type));
        }

        @Override
        @NotNull
        public Pat inline(@Nullable LocalCtx ctx) {
            return this;
        }
    }
}

