/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.repr;

import kala.collection.immutable.ImmutableSeq;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeShape {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ParamShape {
        @NotNull
        public static ParamShape ex(@NotNull TermShape type) {
            return new Licit(type, true);
        }

        @NotNull
        public static ParamShape im(@NotNull TermShape type) {
            return new Licit(type, false);
        }

        @NotNull
        public static ParamShape anyEx() {
            return ParamShape.ex(new TermShape.Any());
        }

        @NotNull
        public static ParamShape anyIm() {
            return ParamShape.im(new TermShape.Any());
        }

        public record Licit(@NotNull TermShape type, boolean explicit) implements ParamShape
        {
        }

        public record Optional(@NotNull ParamShape param) implements ParamShape
        {
        }

        public record Any() implements ParamShape
        {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PatShape {

        public record Any() implements PatShape
        {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TermShape {

        public record TeleRef(int superLevel, int nth) implements TermShape
        {
        }

        public record Call(int superLevel) implements TermShape
        {
        }

        public record Any() implements TermShape
        {
        }
    }

    public record FieldShape(@NotNull ImmutableSeq<ParamShape> tele) implements CodeShape
    {
    }

    public record CtorShape(@NotNull ImmutableSeq<ParamShape> tele) implements CodeShape
    {
    }

    public record StructShape(@NotNull ImmutableSeq<ParamShape> tele, @NotNull ImmutableSeq<FieldShape> fields) implements CodeShape
    {
    }

    public record DataShape(@NotNull ImmutableSeq<ParamShape> tele, @NotNull ImmutableSeq<CtorShape> ctors) implements CodeShape
    {
    }

    public record FnShape(@NotNull ImmutableSeq<ParamShape> tele) implements CodeShape
    {
    }
}

