/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.io.Serializable;
import java.util.EnumSet;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import kala.control.Option;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.repr.AyaShape;
import org.aya.core.serde.SerPat;
import org.aya.core.serde.SerTerm;
import org.aya.core.term.Term;
import org.aya.generic.Modifier;
import org.aya.generic.util.InternalException;
import org.aya.ref.DefVar;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SerDef
extends Serializable {
    @NotNull
    public GenericDef de(@NotNull SerTerm.DeState var1);

    public static class DeserializeException
    extends InternalException {
        public DeserializeException(@NotNull String reason) {
            super(reason);
        }

        @Override
        public void printHint() {
            System.out.println(this.getMessage());
        }

        @Override
        public int exitCode() {
            return 99;
        }
    }

    public static enum SerAyaShape implements Serializable
    {
        NAT;


        @NotNull
        public AyaShape de() {
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NAT: 
            }
            return AyaShape.NAT_SHAPE;
        }

        @NotNull
        public static SerAyaShape serialize(@NotNull AyaShape shape) {
            if (shape == AyaShape.NAT_SHAPE) {
                return NAT;
            }
            throw new InternalException("unexpected shape: " + String.valueOf(shape.getClass()));
        }
    }

    public record SerBind(@NotNull ImmutableSeq<QName> loosers, @NotNull ImmutableSeq<QName> tighters) implements Serializable
    {
        public static final SerBind EMPTY = new SerBind((ImmutableSeq<QName>)ImmutableSeq.empty(), (ImmutableSeq<QName>)ImmutableSeq.empty());
    }

    public record SerRenamedOp(@NotNull String name, @NotNull Assoc assoc, @NotNull SerBind bind) implements Serializable
    {
    }

    public record SerOp(@NotNull QName name, @NotNull Assoc assoc, @NotNull SerBind bind) implements Serializable
    {
    }

    public record SerOpDecl(@NotNull OpDecl.OpInfo opInfo) implements OpDecl
    {
    }

    public record Prim(@NotNull ImmutableSeq<String> module, @NotNull PrimDef.ID name) implements SerDef
    {
        @Override
        @NotNull
        public Def de(@NotNull SerTerm.DeState state) {
            DefVar<PrimDef, TeleDecl.PrimDecl> defVar = DefVar.empty(this.name.id);
            PrimDef def = state.primFactory().getOrCreate(this.name, defVar);
            state.putPrim(this.module, this.name, def.ref);
            return def;
        }
    }

    public record Struct(@NotNull QName name, @NotNull ImmutableSeq<SerTerm.SerParam> telescope, @NotNull SerTerm.Sort resultLift, @NotNull ImmutableSeq<Field> fields) implements SerDef
    {
        @Override
        @NotNull
        public Def de(@NotNull SerTerm.DeState state) {
            return new StructDef((DefVar<StructDef, TeleDecl.StructDecl>)state.newDef(this.name), (ImmutableSeq<Term.Param>)this.telescope.map(tele -> tele.de(state)), this.resultLift.de(state), (ImmutableSeq<FieldDef>)this.fields.map(field -> field.de(state)));
        }
    }

    public record Field(@NotNull QName struct, @NotNull QName self, @NotNull ImmutableSeq<SerTerm.SerParam> ownerTele, @NotNull ImmutableSeq<SerTerm.SerParam> selfTele, @NotNull SerTerm result, @NotNull Option<SerTerm> body, boolean coerce) implements SerDef
    {
        @Override
        @NotNull
        public FieldDef de(@NotNull SerTerm.DeState state) {
            return new FieldDef((DefVar<StructDef, TeleDecl.StructDecl>)state.resolve(this.struct), (DefVar<FieldDef, TeleDecl.StructField>)state.newDef(this.self), (ImmutableSeq<Term.Param>)this.ownerTele.map(tele -> tele.de(state)), (ImmutableSeq<Term.Param>)this.selfTele.map(tele -> tele.de(state)), this.result.de(state), (Option<Term>)this.body.map(serTerm -> serTerm.de(state)), this.coerce);
        }
    }

    public record Data(@NotNull QName name, @NotNull ImmutableSeq<SerTerm.SerParam> telescope, @NotNull SerTerm.Sort resultLift, @NotNull ImmutableSeq<Ctor> bodies) implements SerDef
    {
        @Override
        @NotNull
        public Def de(@NotNull SerTerm.DeState state) {
            return new DataDef((DefVar<DataDef, TeleDecl.DataDecl>)state.newDef(this.name), (ImmutableSeq<Term.Param>)this.telescope.map(tele -> tele.de(state)), this.resultLift.de(state), (ImmutableSeq<CtorDef>)this.bodies.map(body -> body.de(state)));
        }
    }

    public record Ctor(@NotNull QName data, @NotNull QName self, @NotNull ImmutableSeq<SerPat> pats, @NotNull ImmutableSeq<SerTerm.SerParam> ownerTele, @NotNull ImmutableSeq<SerTerm.SerParam> selfTele, @NotNull ImmutableSeq<SerPat.Matchy> clauses, @NotNull SerTerm result, boolean coerce) implements SerDef
    {
        @Override
        @NotNull
        public CtorDef de(@NotNull SerTerm.DeState state) {
            return new CtorDef((DefVar<DataDef, TeleDecl.DataDecl>)state.resolve(this.data), (DefVar<CtorDef, TeleDecl.DataCtor>)state.newDef(this.self), (ImmutableSeq<Pat>)this.pats.map(pat -> pat.de(state)), (ImmutableSeq<Term.Param>)this.ownerTele.map(tele -> tele.de(state)), (ImmutableSeq<Term.Param>)this.selfTele.map(tele -> tele.de(state)), (ImmutableSeq<Matching>)this.clauses.map(matching -> matching.de(state)), this.result.de(state), this.coerce);
        }
    }

    public record Fn(@NotNull QName name, @NotNull ImmutableSeq<SerTerm.SerParam> telescope, @NotNull Either<SerTerm, ImmutableSeq<SerPat.Matchy>> body, @NotNull EnumSet<Modifier> modifiers, @NotNull SerTerm result) implements SerDef
    {
        @Override
        @NotNull
        public Def de(@NotNull SerTerm.DeState state) {
            return new FnDef((DefVar<FnDef, TeleDecl.FnDecl>)state.newDef(this.name), (ImmutableSeq<Term.Param>)this.telescope.map(tele -> tele.de(state)), this.result.de(state), this.modifiers, (Either<Term, ImmutableSeq<Matching>>)this.body.map(term -> term.de(state), mischa -> mischa.map(matchy -> matchy.de(state))));
        }
    }

    public record QName(@NotNull ImmutableSeq<String> mod, @NotNull String name) implements Serializable
    {
        @Override
        public String toString() {
            return this.mod.joinToString((CharSequence)"::", (CharSequence)"", (CharSequence)("::" + this.name));
        }
    }
}

