/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.serde;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Either;
import kala.control.Option;
import kala.tuple.Tuple;
import org.aya.core.Matching;
import org.aya.core.def.ClassDef;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.GenericDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.serde.SerDef;
import org.aya.core.serde.SerPat;
import org.aya.core.serde.SerTerm;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.LitTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.generic.Arg;
import org.aya.generic.util.InternalException;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Serializer(@NotNull State state) {
    @NotNull
    public SerDef serialize(@NotNull GenericDef def) {
        GenericDef genericDef = def;
        Objects.requireNonNull(genericDef);
        GenericDef genericDef2 = genericDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDef.class, FnDef.class, FieldDef.class, StructDef.class, DataDef.class, PrimDef.class, CtorDef.class}, (Object)genericDef2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ClassDef classDef = (ClassDef)genericDef2;
                throw new UnsupportedOperationException("TODO");
            }
            case 1 -> {
                FnDef fn = (FnDef)genericDef2;
                yield new SerDef.Fn(this.state.def(fn.ref), this.serializeParams((ImmutableSeq<Term.Param>)fn.telescope), (Either<SerTerm, ImmutableSeq<SerPat.Matchy>>)fn.body.map(this::serialize, matchings -> matchings.map(this::serialize)), fn.modifiers, this.serialize(fn.result));
            }
            case 2 -> {
                FieldDef field = (FieldDef)genericDef2;
                yield new SerDef.Field(this.state.def(field.structRef), this.state.def(field.ref), this.serializeParams((ImmutableSeq<Term.Param>)field.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)field.selfTele), this.serialize(field.result), (Option<SerTerm>)field.body.map(this::serialize), field.coerce);
            }
            case 3 -> {
                StructDef struct = (StructDef)genericDef2;
                yield new SerDef.Struct(this.state.def(struct.ref()), this.serializeParams((ImmutableSeq<Term.Param>)struct.telescope), this.serialize((FormTerm.Sort)struct.result), (ImmutableSeq<SerDef.Field>)struct.fields.map(field -> (SerDef.Field)this.serialize((GenericDef)field)));
            }
            case 4 -> {
                DataDef data = (DataDef)genericDef2;
                yield new SerDef.Data(this.state.def(data.ref), this.serializeParams((ImmutableSeq<Term.Param>)data.telescope), this.serialize((FormTerm.Sort)data.result), (ImmutableSeq<SerDef.Ctor>)data.body.map(ctor -> (SerDef.Ctor)this.serialize((GenericDef)ctor)));
            }
            case 5 -> {
                PrimDef prim = (PrimDef)genericDef2;
                if (!$assertionsDisabled && prim.ref.module == null) {
                    throw new AssertionError();
                }
                yield new SerDef.Prim(prim.ref.module, prim.id);
            }
            case 6 -> {
                CtorDef ctor = (CtorDef)genericDef2;
                yield new SerDef.Ctor(this.state.def(ctor.dataRef), this.state.def(ctor.ref), this.serializePats(ctor.pats), this.serializeParams((ImmutableSeq<Term.Param>)ctor.ownerTele), this.serializeParams((ImmutableSeq<Term.Param>)ctor.selfTele), (ImmutableSeq<SerPat.Matchy>)ctor.clauses.map(this::serialize), this.serialize(ctor.result), ctor.coerce);
            }
        };
    }

    @NotNull
    private SerTerm.Sort serialize(@NotNull FormTerm.Sort term) {
        FormTerm.Sort sort = term;
        Objects.requireNonNull(sort);
        FormTerm.Sort sort2 = sort;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Type.class, FormTerm.Set.class, FormTerm.Prop.class, FormTerm.ISet.class}, (Object)sort2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                FormTerm.Type ty = (FormTerm.Type)sort2;
                yield new SerTerm.Type(ty.lift());
            }
            case 1 -> {
                FormTerm.Set set = (FormTerm.Set)sort2;
                yield new SerTerm.Set(set.lift());
            }
            case 2 -> {
                FormTerm.Prop prop = (FormTerm.Prop)sort2;
                yield new SerTerm.Prop();
            }
            case 3 -> {
                FormTerm.ISet iset = (FormTerm.ISet)sort2;
                yield new SerTerm.ISet();
            }
        };
    }

    @NotNull
    private SerTerm serialize(@NotNull Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LitTerm.ShapedInt.class, PrimTerm.Mula.class, PrimTerm.Str.class, RefTerm.class, RefTerm.Field.class, PrimTerm.Interval.class, FormTerm.Pi.class, FormTerm.Sigma.class, CallTerm.Con.class, CallTerm.Struct.class, CallTerm.Data.class, CallTerm.Prim.class, CallTerm.Access.class, CallTerm.Fn.class, ElimTerm.Proj.class, ElimTerm.App.class, IntroTerm.Tuple.class, IntroTerm.Lambda.class, IntroTerm.New.class, IntroTerm.PartEl.class, FormTerm.PartTy.class, FormTerm.Path.class, IntroTerm.PathLam.class, ElimTerm.PathApp.class, PrimTerm.Coe.class, CallTerm.Hole.class, RefTerm.MetaPat.class, ErrorTerm.class, FormTerm.Sort.class}, (Object)term3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                LitTerm.ShapedInt lit = (LitTerm.ShapedInt)term3;
                yield new SerTerm.ShapedInt(lit.repr(), SerDef.SerAyaShape.serialize(lit.shape()), this.serialize(lit.type()));
            }
            case 1 -> {
                PrimTerm.Mula end = (PrimTerm.Mula)term3;
                yield new SerTerm.Mula((Formula<SerTerm>)end.asFormula().fmap(this::serialize));
            }
            case 2 -> {
                PrimTerm.Str str = (PrimTerm.Str)term3;
                yield new SerTerm.Str(str.string());
            }
            case 3 -> {
                RefTerm ref = (RefTerm)term3;
                yield new SerTerm.Ref(this.state.local(ref.var()));
            }
            case 4 -> {
                RefTerm.Field ref = (RefTerm.Field)term3;
                yield new SerTerm.FieldRef(this.state.def(ref.ref()));
            }
            case 5 -> {
                PrimTerm.Interval interval = (PrimTerm.Interval)term3;
                yield new SerTerm.Interval();
            }
            case 6 -> {
                FormTerm.Pi pi = (FormTerm.Pi)term3;
                yield new SerTerm.Pi(this.serialize(pi.param()), this.serialize(pi.body()));
            }
            case 7 -> {
                FormTerm.Sigma sigma = (FormTerm.Sigma)term3;
                yield new SerTerm.Sigma(this.serializeParams(sigma.params()));
            }
            case 8 -> {
                CallTerm.Con conCall = (CallTerm.Con)term3;
                yield new SerTerm.ConCall(this.state.def(conCall.head().dataRef()), this.state.def(conCall.head().ref()), this.serializeCall(conCall.head().ulift(), conCall.head().dataArgs()), this.serializeArgs(conCall.args()));
            }
            case 9 -> {
                CallTerm.Struct structCall = (CallTerm.Struct)term3;
                yield this.serializeStructCall(structCall);
            }
            case 10 -> {
                CallTerm.Data dataCall = (CallTerm.Data)term3;
                yield this.serializeDataCall(dataCall);
            }
            case 11 -> {
                CallTerm.Prim prim = (CallTerm.Prim)term3;
                yield new SerTerm.PrimCall(this.state.def((DefVar<?, ?>)prim.ref()), prim.id(), this.serializeCall(prim.ulift(), prim.args()));
            }
            case 12 -> {
                CallTerm.Access access = (CallTerm.Access)term3;
                yield new SerTerm.Access(this.serialize(access.of()), this.state.def((DefVar<?, ?>)access.ref()), this.serializeArgs(access.structArgs()), this.serializeArgs(access.fieldArgs()));
            }
            case 13 -> {
                CallTerm.Fn fnCall = (CallTerm.Fn)term3;
                yield new SerTerm.FnCall(this.state.def((DefVar<?, ?>)fnCall.ref()), this.serializeCall(fnCall.ulift(), fnCall.args()));
            }
            case 14 -> {
                ElimTerm.Proj proj = (ElimTerm.Proj)term3;
                yield new SerTerm.Proj(this.serialize(proj.of()), proj.ix());
            }
            case 15 -> {
                ElimTerm.App app = (ElimTerm.App)term3;
                yield new SerTerm.App(this.serialize(app.of()), this.serialize(app.arg()));
            }
            case 16 -> {
                IntroTerm.Tuple tuple = (IntroTerm.Tuple)term3;
                yield new SerTerm.Tup((ImmutableSeq<SerTerm>)tuple.items().map(this::serialize));
            }
            case 17 -> {
                IntroTerm.Lambda lambda = (IntroTerm.Lambda)term3;
                yield new SerTerm.Lam(this.serialize(lambda.param()), this.serialize(lambda.body()));
            }
            case 18 -> {
                IntroTerm.New newTerm = (IntroTerm.New)term3;
                yield new SerTerm.New(this.serializeStructCall(newTerm.struct()), (ImmutableMap<SerDef.QName, SerTerm>)ImmutableMap.from((Iterable)newTerm.params().view().map((k, v) -> Tuple.of((Object)this.state.def((DefVar<?, ?>)k), (Object)this.serialize((Term)v)))));
            }
            case 19 -> {
                IntroTerm.PartEl el = (IntroTerm.PartEl)term3;
                yield new SerTerm.PartEl((Partial<SerTerm>)el.partial().fmap(this::serialize), this.serialize(el.rhsType()));
            }
            case 20 -> {
                FormTerm.PartTy ty = (FormTerm.PartTy)term3;
                yield new SerTerm.PartTy(this.serialize(ty.type()), (Restr<SerTerm>)ty.restr().fmap(this::serialize));
            }
            case 21 -> {
                FormTerm.Path path = (FormTerm.Path)term3;
                yield new SerTerm.Path(this.serialize(path.cube()));
            }
            case 22 -> {
                IntroTerm.PathLam path = (IntroTerm.PathLam)term3;
                yield new SerTerm.PathLam(this.serializeIntervals(path.params()), this.serialize(path.body()));
            }
            case 23 -> {
                ElimTerm.PathApp app = (ElimTerm.PathApp)term3;
                yield new SerTerm.PathApp(this.serialize(app.of()), this.serializeArgs(app.args()), this.serialize(app.cube()));
            }
            case 24 -> {
                PrimTerm.Coe coe = (PrimTerm.Coe)term3;
                yield new SerTerm.Coe(this.serialize(coe.type()), (Restr<SerTerm>)coe.restr().fmap(this::serialize));
            }
            case 25 -> {
                CallTerm.Hole hole = (CallTerm.Hole)term3;
                throw new InternalException("Shall not have holes serialized.");
            }
            case 26 -> {
                RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term3;
                throw new InternalException("Shall not have metaPats serialized.");
            }
            case 27 -> {
                ErrorTerm err = (ErrorTerm)term3;
                throw new InternalException("Shall not have error term serialized.");
            }
            case 28 -> {
                FormTerm.Sort sort = (FormTerm.Sort)term3;
                yield this.serialize(sort);
            }
        };
    }

    @NotNull
    private SerPat serialize(@NotNull Pat pat) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Absurd.class, Pat.Ctor.class, Pat.Tuple.class, Pat.Bind.class, Pat.End.class, Pat.Meta.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pat.Absurd absurd = (Pat.Absurd)pat3;
                yield new SerPat.Absurd(absurd.explicit());
            }
            case 1 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                yield new SerPat.Ctor(ctor.explicit(), this.state.def(ctor.ref()), this.serializePats(ctor.params()), this.serializeDataCall(ctor.type()));
            }
            case 2 -> {
                Pat.Tuple tuple = (Pat.Tuple)pat3;
                yield new SerPat.Tuple(tuple.explicit(), this.serializePats(tuple.pats()));
            }
            case 3 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                yield new SerPat.Bind(bind.explicit(), this.state.local(bind.bind()), this.serialize(bind.type()));
            }
            case 4 -> {
                Pat.End end = (Pat.End)pat3;
                yield new SerPat.End(end.isLeft(), end.explicit());
            }
            case 5 -> {
                Pat.Meta meta = (Pat.Meta)pat3;
                throw new InternalException(String.valueOf(meta) + " is illegal here");
            }
            case 6 -> {
                Pat.ShapedInt lit = (Pat.ShapedInt)pat3;
                yield new SerPat.ShapedInt(lit.repr(), lit.explicit(), SerDef.SerAyaShape.serialize(lit.shape()), this.serializeDataCall(lit.type()));
            }
        };
    }

    @NotNull
    private SerTerm.SerCube serialize(@NotNull FormTerm.Cube cube) {
        return new SerTerm.SerCube(this.serializeIntervals(cube.params()), this.serialize(cube.type()), (Partial<SerTerm>)cube.partial().fmap(this::serialize));
    }

    @NotNull
    private SerTerm.DataCall serializeDataCall( @NotNull CallTerm.Data dataCall) {
        return new SerTerm.DataCall(this.state.def((DefVar<?, ?>)dataCall.ref()), this.serializeCall(dataCall.ulift(), dataCall.args()));
    }

    @NotNull
    private SerTerm.StructCall serializeStructCall( @NotNull CallTerm.Struct structCall) {
        return new SerTerm.StructCall(this.state.def((DefVar<?, ?>)structCall.ref()), this.serializeCall(structCall.ulift(), structCall.args()));
    }

    @NotNull
    private SerPat.Matchy serialize(@NotNull Matching matchy) {
        return new SerPat.Matchy(this.serializePats(matchy.patterns()), this.serialize(matchy.body()));
    }

    private SerTerm.SerArg serialize(@NotNull @NotNull Arg<@NotNull Term> termArg) {
        return new SerTerm.SerArg(this.serialize(termArg.term()), termArg.explicit());
    }

    @Contract(value="_ -> new")
    private SerTerm.SerParam serialize(@NotNull Term.Param param) {
        return new SerTerm.SerParam(param.explicit(), this.serialize(param.ref()), this.serialize(param.type()));
    }

    @NotNull
    private SerTerm.SimpVar serialize(@NotNull LocalVar localVar) {
        return this.state.local(localVar);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerParam> serializeParams(ImmutableSeq<@NotNull Term.Param> params) {
        return params.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SimpVar> serializeIntervals(ImmutableSeq<LocalVar> params) {
        return params.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerTerm.SerArg> serializeArgs(@NotNull ImmutableSeq<Arg<Term>> args) {
        return args.map(this::serialize);
    }

    @NotNull
    private ImmutableSeq<SerPat> serializePats(@NotNull ImmutableSeq<Pat> pats) {
        return pats.map(this::serialize);
    }

    @NotNull
    private SerTerm.CallData serializeCall(int ulift, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args) {
        return new SerTerm.CallData(ulift, this.serializeArgs(args));
    }

    public record State(@NotNull MutableMap<LocalVar, Integer> localCache, @NotNull MutableMap<DefVar<?, ?>, Integer> defCache) {
        public State() {
            this((MutableMap<LocalVar, Integer>)MutableMap.create(), MutableMap.create());
        }

        @NotNull
        public SerTerm.SimpVar local(@NotNull LocalVar var) {
            return new SerTerm.SimpVar((Integer)this.localCache.getOrPut((Object)var, () -> this.localCache.size()), var.name());
        }

        @NotNull
        public SerDef.QName def(@NotNull DefVar<?, ?> var) {
            assert (var.module != null);
            return new SerDef.QName(var.module, var.name());
        }
    }
}

