/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.ref.AnyVar;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ElimTerm
extends Term {
    @NotNull
    public Term of();

    @Contract(pure=true)
    @NotNull
    public static Term proj(@NotNull Term of, int ix) {
        return ElimTerm.proj(new Proj(of, ix));
    }

    @Contract(pure=true)
    @NotNull
    public static Term proj(@NotNull Proj proj) {
        Term term = proj.of;
        if (term instanceof IntroTerm.Tuple) {
            IntroTerm.Tuple tup = (IntroTerm.Tuple)term;
            if (!(1.$assertionsDisabled || tup.items().sizeGreaterThanOrEquals(proj.ix) && proj.ix > 0)) {
                throw new AssertionError((Object)proj.of.toDoc(DistillerOptions.debug()).debugRender());
            }
            return (Term)tup.items().get(proj.ix - 1);
        }
        return proj;
    }

    @NotNull
    public static Term unapp(@NotNull Term term, MutableList<Arg<@NotNull Term>> args) {
        while (term instanceof App) {
            App app = (App)term;
            args.append(app.arg);
            term = app.of;
        }
        args.reverse();
        return term;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record Proj(@NotNull Term of, int ix) implements ElimTerm
    {
        @NotNull
        public static Subst projSubst(@NotNull Term term, int index, ImmutableSeq<Term.Param> telescope) {
            Subst subst = new Subst((MutableMap<AnyVar, Term>)MutableMap.create());
            telescope.view().take(index).reversed().forEachIndexed((i, param) -> subst.add(param.ref(), new Proj(term, i + 1)));
            return subst;
        }
    }

    public record App(@NotNull Term of, @NotNull @NotNull Arg<@NotNull Term> arg) implements ElimTerm
    {
    }

    public record PathApp(@NotNull Term of, @NotNull @NotNull ImmutableSeq<Arg<@NotNull Term>> args, @NotNull FormTerm.Cube cube) implements ElimTerm
    {
    }
}

