/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.StableWHNF;
import org.aya.core.term.Term;
import org.aya.core.visitor.Subst;
import org.aya.generic.Arg;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.ref.LocalVar;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FormTerm
extends Term {
    @NotNull
    public static Term unpi(@NotNull Term term, @NotNull MutableList<Term.Param> params) {
        while (term instanceof Pi) {
            Pi pi = (Pi)term;
            params.append((Object)pi.param);
            term = pi.body;
        }
        return term;
    }

    public record Pi(@NotNull Term.Param param, @NotNull Term body) implements FormTerm,
    StableWHNF
    {
        @NotNull
        public Term substBody(@NotNull Term term) {
            return this.body.subst(this.param.ref(), term);
        }

        @NotNull
        public Term parameters(@NotNull @NotNull MutableList<@NotNull Term.Param> params) {
            params.append((Object)this.param);
            Term t = this.body;
            while (t instanceof Pi) {
                Pi pi = (Pi)t;
                params.append((Object)pi.param);
                t = pi.body;
            }
            return t;
        }

        @NotNull
        public static Term make(@NotNull @NotNull SeqLike<@NotNull Term.Param> telescope, @NotNull Term body) {
            return (Term)telescope.view().foldRight((Object)body, Pi::new);
        }
    }

    public record Cube(@NotNull ImmutableSeq<LocalVar> params, @NotNull Term type, @NotNull Partial<Term> partial) {
        @NotNull
        public Pi computePi() {
            SeqView iTele = this.params().view().map(x -> new Term.Param((LocalVar)x, PrimTerm.Interval.INSTANCE, true));
            return (Pi)Pi.make((SeqLike<Term.Param>)iTele, this.type());
        }

        @NotNull
        public Term applyDimsTo(@NotNull Term innerMost) {
            SeqView args = this.params.view().map(RefTerm::new);
            if (innerMost instanceof IntroTerm.PathLam) {
                IntroTerm.PathLam lam = (IntroTerm.PathLam)innerMost;
                assert (lam.params().sizeEquals(this.params()));
                return lam.body().subst(new Subst((SeqLike<LocalVar>)lam.params(), (SeqLike<? extends Term>)args));
            }
            SeqView newArgs = args.map(x -> new Arg<RefTerm>((RefTerm)x, true));
            if (innerMost instanceof IntroTerm.Lambda) {
                return (Term)newArgs.foldLeft((Object)innerMost, CallTerm::make);
            }
            return new ElimTerm.PathApp(innerMost, (ImmutableSeq<Arg<Term>>)newArgs.toImmutableSeq(), this);
        }

        @NotNull
        public Cube map(@NotNull ImmutableSeq<LocalVar> params, @NotNull Function<Term, Term> mapper) {
            Term ty = mapper.apply(this.type);
            Partial par = this.partial.map(mapper);
            if (ty == this.type && par == this.partial) {
                return this;
            }
            return new Cube(params, ty, (Partial<Term>)par);
        }

        @NotNull
        public Cube map(@NotNull Function<Term, Term> mapper) {
            return this.map(this.params, mapper);
        }

        @NotNull
        public Term makeApp(@NotNull Term app, @NotNull Arg<Term> arg) {
            return CallTerm.make(this.makeLam(app), arg);
        }

        @NotNull
        public Term makeLam(@NotNull Term app) {
            ImmutableSeq xi = this.params().map(x -> new Term.Param((LocalVar)x, PrimTerm.Interval.INSTANCE, true));
            ElimTerm.PathApp elim = new ElimTerm.PathApp(app, (ImmutableSeq<Arg<Term>>)xi.map(Term.Param::toArg), this);
            return ((Term)xi.foldRight((Object)elim, IntroTerm.Lambda::new)).rename();
        }
    }

    public record Path(@NotNull Cube cube) implements FormTerm,
    StableWHNF
    {
    }

    public record PartTy(@NotNull Term type, @NotNull Restr<Term> restr) implements FormTerm
    {
    }

    public static final class ISet
    implements Sort {
        @NotNull
        public static final ISet INSTANCE = new ISet();

        private ISet() {
        }

        @Override
        public int lift() {
            return 0;
        }

        @Override
        @NotNull
        public SortKind kind() {
            return SortKind.ISet;
        }

        @Override
        @NotNull
        public Set succ() {
            return new Set(1);
        }
    }

    public static final class Prop
    implements Sort {
        @NotNull
        public static final Prop INSTANCE = new Prop();

        private Prop() {
        }

        @Override
        public int lift() {
            return 0;
        }

        @Override
        @NotNull
        public SortKind kind() {
            return SortKind.Prop;
        }

        @Override
        @NotNull
        public Type succ() {
            return new Type(0);
        }
    }

    public record Set(int lift) implements Sort
    {
        @NotNull
        public static final Set ZERO = new Set(0);

        @Override
        @NotNull
        public SortKind kind() {
            return SortKind.Set;
        }

        @Override
        @NotNull
        public Set succ() {
            return new Set(this.lift + 1);
        }
    }

    public record Type(int lift) implements Sort
    {
        @NotNull
        public static final Type ZERO = new Type(0);

        @Override
        @NotNull
        public SortKind kind() {
            return SortKind.Type;
        }

        @Override
        @NotNull
        public Type succ() {
            return new Type(this.lift + 1);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Sort
    extends FormTerm,
    StableWHNF {
        public int lift();

        @NotNull
        public SortKind kind();

        @NotNull
        public Sort succ();

        @NotNull
        public static Sort create(@NotNull SortKind kind, int lift) {
            return switch (kind) {
                default -> throw new IncompatibleClassChangeError();
                case SortKind.Type -> new Type(lift);
                case SortKind.Set -> new Set(lift);
                case SortKind.Prop -> Prop.INSTANCE;
                case SortKind.ISet -> ISet.INSTANCE;
            };
        }

        @NotNull
        default public Sort max(@NotNull Sort other) {
            return Sort.create(this.kind().max(other.kind()), Math.max(this.lift(), other.lift()));
        }
    }

    public static enum SortKind {
        Type,
        Set,
        Prop,
        ISet;


        public boolean hasLevel() {
            return this == Type || this == Set;
        }

        @NotNull
        public SortKind max(@NotNull SortKind other) {
            if (this == Set || other == Set) {
                return Set;
            }
            if (this == Type || other == Type) {
                return Type;
            }
            return this == other ? this : Type;
        }
    }

    public record Sigma(@NotNull @NotNull ImmutableSeq<@NotNull Term.Param> params) implements FormTerm,
    StableWHNF
    {
    }
}

