/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import org.aya.core.term.Term;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Restr;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PrimTerm
extends Term {

    public record Coe(@NotNull Term type, @NotNull Restr<Term> restr) implements PrimTerm
    {
    }

    public static final class Interval
    implements PrimTerm {
        public static final Interval INSTANCE = new Interval();

        private Interval() {
        }
    }

    public record Str(@NotNull String string) implements PrimTerm
    {
    }

    public record Mula(@NotNull Formula<Term> asFormula) implements PrimTerm
    {
        @NotNull
        public static final Mula LEFT = new Mula((Formula<Term>)new Formula.Lit(true));
        @NotNull
        public static final Mula RIGHT = new Mula((Formula<Term>)new Formula.Lit(false));

        @NotNull
        public static Mula inv(@NotNull Term term) {
            return new Mula((Formula<Term>)new Formula.Inv((Object)term));
        }

        @NotNull
        public static Mula and(@NotNull Term lhs, @NotNull Term rhs) {
            return Mula.conn(true, lhs, rhs);
        }

        @NotNull
        public static Mula or(@NotNull Term lhs, @NotNull Term rhs) {
            return Mula.conn(false, lhs, rhs);
        }

        @NotNull
        public static Mula conn(boolean isAnd, @NotNull Term lhs, @NotNull Term rhs) {
            return new Mula((Formula<Term>)new Formula.Conn(isAnd, (Object)lhs, (Object)rhs));
        }

        @NotNull
        public SeqView<Term> view() {
            Formula<Term> formula = this.asFormula;
            Objects.requireNonNull(formula);
            Formula<Term> formula2 = formula;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Formula.Conn.class, Formula.Inv.class, Formula.Lit.class}, formula2, n)) {
                default -> throw new RuntimeException(null, null);
                case 0 -> {
                    Formula.Conn cnn = (Formula.Conn)formula2;
                    yield SeqView.of((Object)((Term)cnn.l())).appended((Object)((Term)cnn.r()));
                }
                case 1 -> {
                    Formula.Inv inv = (Formula.Inv)formula2;
                    yield SeqView.of((Object)((Term)inv.i()));
                }
                case 2 -> {
                    Formula.Lit lit = (Formula.Lit)formula2;
                    yield SeqView.empty();
                }
            };
        }
    }
}

