/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.Map;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple;
import kala.tuple.Tuple3;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.DataDef;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.LitTerm;
import org.aya.core.term.PrimTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.visitor.EndoFunctor;
import org.aya.core.visitor.Expander;
import org.aya.core.visitor.MonoidalVarFolder;
import org.aya.core.visitor.Subst;
import org.aya.core.visitor.VarConsumer;
import org.aya.distill.BaseDistiller;
import org.aya.distill.CoreDistiller;
import org.aya.generic.Arg;
import org.aya.generic.AyaDocile;
import org.aya.generic.ParamLike;
import org.aya.generic.util.NormalizeMode;
import org.aya.guest0x0.cubical.Formula;
import org.aya.guest0x0.cubical.Partial;
import org.aya.guest0x0.cubical.Restr;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.tyck.LittleTyper;
import org.aya.tyck.TyckState;
import org.aya.tyck.env.LocalCtx;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Term
extends AyaDocile,
Restr.TermLike<Term> {
    @NotNull
    default public Term descent(@NotNull @NotNull Function<@NotNull Term, @NotNull Term> f) {
        Term term = this;
        Objects.requireNonNull(term);
        Term term2 = term;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Pi.class, FormTerm.Sigma.class, FormTerm.Sort.class, PrimTerm.Interval.class, PrimTerm.Mula.class, PrimTerm.Str.class, IntroTerm.Lambda.class, IntroTerm.Tuple.class, IntroTerm.New.class, ElimTerm.App.class, ElimTerm.Proj.class, CallTerm.Struct.class, CallTerm.Data.class, CallTerm.Con.class, CallTerm.Fn.class, CallTerm.Access.class, CallTerm.Prim.class, CallTerm.Hole.class, LitTerm.ShapedInt.class, FormTerm.PartTy.class, IntroTerm.PartEl.class, FormTerm.Path.class, IntroTerm.PathLam.class, ElimTerm.PathApp.class, PrimTerm.Coe.class, RefTerm.class, RefTerm.MetaPat.class, RefTerm.Field.class, ErrorTerm.class}, (Object)term2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                FormTerm.Pi pi = (FormTerm.Pi)term2;
                Param param = pi.param().descent(f);
                Term body = f.apply(pi.body());
                if (param == pi.param() && body == pi.body()) {
                    yield pi;
                }
                yield new FormTerm.Pi(param, body);
            }
            case 1 -> {
                FormTerm.Sigma sigma = (FormTerm.Sigma)term2;
                ImmutableSeq params = sigma.params().map(param -> param.descent(f));
                if (params.sameElements(sigma.params(), true)) {
                    yield sigma;
                }
                yield new FormTerm.Sigma((ImmutableSeq<Param>)params);
            }
            case 2 -> {
                FormTerm.Sort univ;
                yield univ = (FormTerm.Sort)term2;
            }
            case 3 -> {
                PrimTerm.Interval interval = (PrimTerm.Interval)term2;
                yield interval;
            }
            case 4 -> {
                PrimTerm.Mula mula = (PrimTerm.Mula)term2;
                Formula formula = mula.asFormula().fmap(f);
                if (formula == mula.asFormula()) {
                    yield mula;
                }
                yield new PrimTerm.Mula((Formula<Term>)formula);
            }
            case 5 -> {
                PrimTerm.Str str = (PrimTerm.Str)term2;
                yield str;
            }
            case 6 -> {
                IntroTerm.Lambda lambda = (IntroTerm.Lambda)term2;
                Param param = lambda.param().descent(f);
                Term body = f.apply(lambda.body());
                if (param == lambda.param() && body == lambda.body()) {
                    yield lambda;
                }
                yield new IntroTerm.Lambda(param, body);
            }
            case 7 -> {
                IntroTerm.Tuple tuple = (IntroTerm.Tuple)term2;
                ImmutableSeq items = tuple.items().map(f);
                if (items.sameElements(tuple.items(), true)) {
                    yield tuple;
                }
                yield new IntroTerm.Tuple((ImmutableSeq<Term>)items);
            }
            case 8 -> {
                IntroTerm.New neu = (IntroTerm.New)term2;
                Term struct = f.apply(neu.struct());
                ImmutableMap fields = ImmutableMap.from((Iterable)neu.params().view().map((k, v) -> Tuple.of((Object)k, (Object)((Term)f.apply((Term)v)))));
                if (struct == neu.struct() && fields.valuesView().sameElements((Iterable)neu.params().valuesView())) {
                    yield neu;
                }
                yield new IntroTerm.New((CallTerm.Struct)struct, (ImmutableMap<DefVar<FieldDef, TeleDecl.StructField>, Term>)fields);
            }
            case 9 -> {
                ElimTerm.App app = (ElimTerm.App)term2;
                Term function = f.apply(app.of());
                Arg<Term> arg = app.arg().descent(f);
                if (function == app.of() && arg == app.arg()) {
                    yield app;
                }
                yield CallTerm.make(function, arg);
            }
            case 10 -> {
                ElimTerm.Proj proj = (ElimTerm.Proj)term2;
                Term tuple = f.apply(proj.of());
                if (tuple == proj.of()) {
                    yield proj;
                }
                yield new ElimTerm.Proj(tuple, proj.ix());
            }
            case 11 -> {
                CallTerm.Struct struct = (CallTerm.Struct)term2;
                ImmutableSeq args = struct.args().map(arg -> arg.descent(f));
                if (args.sameElements(struct.args(), true)) {
                    yield struct;
                }
                yield new CallTerm.Struct((DefVar<StructDef, TeleDecl.StructDecl>)struct.ref(), struct.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 12 -> {
                CallTerm.Data data = (CallTerm.Data)term2;
                ImmutableSeq args = data.args().map(arg -> arg.descent(f));
                if (args.sameElements(data.args(), true)) {
                    yield data;
                }
                yield new CallTerm.Data((DefVar<DataDef, TeleDecl.DataDecl>)data.ref(), data.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 13 -> {
                CallTerm.Con con = (CallTerm.Con)term2;
                CallTerm.ConHead head = con.head().descent(f);
                ImmutableSeq args = con.conArgs().map(arg -> arg.descent(f));
                if (head == con.head() && args.sameElements(con.conArgs(), true)) {
                    yield con;
                }
                yield new CallTerm.Con(head, (ImmutableSeq<Arg<Term>>)args);
            }
            case 14 -> {
                CallTerm.Fn fn = (CallTerm.Fn)term2;
                ImmutableSeq args = fn.args().map(arg -> arg.descent(f));
                if (args.sameElements(fn.args(), true)) {
                    yield fn;
                }
                yield new CallTerm.Fn((DefVar<FnDef, TeleDecl.FnDecl>)fn.ref(), fn.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 15 -> {
                CallTerm.Access access = (CallTerm.Access)term2;
                Term struct = f.apply(access.of());
                ImmutableSeq structArgs = access.structArgs().map(arg -> arg.descent(f));
                ImmutableSeq fieldArgs = access.fieldArgs().map(arg -> arg.descent(f));
                if (struct == access.of() && structArgs.sameElements(access.structArgs(), true) && fieldArgs.sameElements(access.fieldArgs(), true)) {
                    yield access;
                }
                yield new CallTerm.Access(struct, (DefVar<FieldDef, TeleDecl.StructField>)access.ref(), (ImmutableSeq<Arg<Term>>)structArgs, (ImmutableSeq<Arg<Term>>)fieldArgs);
            }
            case 16 -> {
                CallTerm.Prim prim = (CallTerm.Prim)term2;
                ImmutableSeq args = prim.args().map(arg -> arg.descent(f));
                if (args.sameElements(prim.args(), true)) {
                    yield prim;
                }
                yield new CallTerm.Prim((DefVar<PrimDef, TeleDecl.PrimDecl>)prim.ref(), prim.ulift(), (ImmutableSeq<Arg<Term>>)args);
            }
            case 17 -> {
                CallTerm.Hole hole = (CallTerm.Hole)term2;
                ImmutableSeq contextArgs = hole.contextArgs().map(arg -> arg.descent(f));
                ImmutableSeq args = hole.args().map(arg -> arg.descent(f));
                if (contextArgs.sameElements(hole.contextArgs(), true) && args.sameElements(hole.args(), true)) {
                    yield hole;
                }
                yield new CallTerm.Hole(hole.ref(), hole.ulift(), (ImmutableSeq<Arg<Term>>)contextArgs, (ImmutableSeq<Arg<Term>>)args);
            }
            case 18 -> {
                LitTerm.ShapedInt shaped = (LitTerm.ShapedInt)term2;
                Term type = f.apply(shaped.type());
                if (type == shaped.type()) {
                    yield shaped;
                }
                yield new LitTerm.ShapedInt(shaped.repr(), shaped.shape(), type);
            }
            case 19 -> {
                FormTerm.PartTy ty = (FormTerm.PartTy)term2;
                Term type = f.apply(ty.type());
                Restr restr = ty.restr().map(f);
                if (type == ty.type() && restr == ty.restr()) {
                    yield ty;
                }
                yield new FormTerm.PartTy(type, (Restr<Term>)restr);
            }
            case 20 -> {
                IntroTerm.PartEl el = (IntroTerm.PartEl)term2;
                Partial partial = el.partial().map(f);
                if (partial == el.partial()) {
                    yield el;
                }
                yield new IntroTerm.PartEl((Partial<Term>)partial, el.rhsType());
            }
            case 21 -> {
                FormTerm.Path path = (FormTerm.Path)term2;
                FormTerm.Cube cube = path.cube().map(f);
                if (cube == path.cube()) {
                    yield path;
                }
                yield new FormTerm.Path(cube);
            }
            case 22 -> {
                IntroTerm.PathLam lam = (IntroTerm.PathLam)term2;
                Term body = f.apply(lam.body());
                if (body == lam.body()) {
                    yield lam;
                }
                yield new IntroTerm.PathLam(lam.params(), body);
            }
            case 23 -> {
                ElimTerm.PathApp app = (ElimTerm.PathApp)term2;
                Term of = f.apply(app.of());
                ImmutableSeq refs = app.args().map(a -> a.descent(f));
                FormTerm.Cube cube = app.cube().map(f);
                if (of == app.of() && cube == app.cube() && refs.sameElements(app.args(), true)) {
                    yield app;
                }
                yield new ElimTerm.PathApp(of, (ImmutableSeq<Arg<Term>>)refs, cube);
            }
            case 24 -> {
                PrimTerm.Coe coe = (PrimTerm.Coe)term2;
                Term type = f.apply(coe.type());
                Restr restr = coe.restr().map(f).normalize();
                if (type == coe.type() && restr == coe.restr()) {
                    yield coe;
                }
                yield new PrimTerm.Coe(type, (Restr<Term>)restr);
            }
            case 25 -> {
                RefTerm ref = (RefTerm)term2;
                yield ref;
            }
            case 26 -> {
                RefTerm.MetaPat metaPat = (RefTerm.MetaPat)term2;
                yield metaPat;
            }
            case 27 -> {
                RefTerm.Field field = (RefTerm.Field)term2;
                yield field;
            }
            case 28 -> {
                ErrorTerm error = (ErrorTerm)term2;
                yield error;
            }
        };
    }

    @NotNull
    default public Term subst(@NotNull AnyVar var, @NotNull Term term) {
        return this.subst(new Subst(var, term));
    }

    @NotNull
    default public Term subst(@NotNull Subst subst) {
        return new EndoFunctor.Substituter(subst).apply(this);
    }

    @NotNull
    default public Term subst(@NotNull Map<AnyVar, ? extends Term> subst) {
        return this.subst(new Subst((MutableMap<AnyVar, Term>)MutableMap.from(subst)));
    }

    @NotNull
    default public Term subst(@NotNull Subst subst, int ulift) {
        return this.subst(subst).lift(ulift);
    }

    @NotNull
    default public Term rename() {
        return new EndoFunctor.Renamer().apply(this);
    }

    default public int findUsages(@NotNull AnyVar var) {
        return (Integer)new MonoidalVarFolder.Usages(var).apply(this);
    }

    default public VarConsumer.ScopeChecker scopeCheck(@NotNull ImmutableSeq<LocalVar> allowed) {
        VarConsumer.ScopeChecker checker = new VarConsumer.ScopeChecker(allowed);
        checker.accept(this);
        if (!2.$assertionsDisabled && !checker.isCleared()) {
            throw new AssertionError((Object)"The scope checker is not properly cleared up");
        }
        return checker;
    }

    @NotNull
    default public Term normalize(@NotNull TyckState state, @NotNull NormalizeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case NormalizeMode.NULL -> this;
            case NormalizeMode.NF -> new Expander.Normalizer(state).apply(this);
            case NormalizeMode.WHNF -> new Expander.WHNFer(state).apply(this);
        };
    }

    @NotNull
    default public Term freezeHoles(final @Nullable TyckState state) {
        return new EndoFunctor(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public Term pre(@NotNull Term term) {
                Term term2;
                if (term instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)term;
                    if (state != null) {
                        term2 = (Term)state.metas().getOrDefault((Object)hole.ref(), (Object)term);
                        return term2;
                    }
                }
                term2 = term;
                return term2;
            }
        }.apply(this);
    }

    @Override
    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return new CoreDistiller(options).term(BaseDistiller.Outer.Free, this);
    }

    @NotNull
    default public Term lift(int ulift) {
        return new EndoFunctor.Elevator(ulift).apply(this);
    }

    @NotNull
    default public Term computeType(@NotNull TyckState state, @NotNull LocalCtx ctx) {
        return new LittleTyper(state, ctx).term(this);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class Param
    extends Record
    implements ParamLike<Term> {
        @NotNull
        private final LocalVar ref;
        @NotNull
        private final Term type;
        private final boolean explicit;

        public Param(@NotNull ParamLike<?> param, @NotNull Term type) {
            this(param.ref(), type, param.explicit());
        }

        public Param(@NotNull LocalVar ref, @NotNull Term type, boolean explicit) {
            this.ref = ref;
            this.type = type;
            this.explicit = explicit;
        }

        @NotNull
        public static @NotNull ImmutableSeq<@NotNull Param> fromBuffer(@NotNull MutableList<Tuple3<LocalVar, Boolean, Term>> buf) {
            return buf.view().map(tup -> new Param((LocalVar)tup._1, (Term)tup._3, (Boolean)tup._2)).toImmutableSeq();
        }

        @NotNull
        public Param descent(@NotNull @NotNull Function<@NotNull Term, @NotNull Term> f) {
            Term type = f.apply(this.type());
            if (type == this.type()) {
                return this;
            }
            return new Param(this, type);
        }

        @Contract(value=" -> new")
        @NotNull
        public Param implicitify() {
            return new Param(this.ref, this.type, false);
        }

        @Contract(value=" -> new")
        @NotNull
        public Param rename() {
            return new Param(this.renameVar(), this.type, this.explicit);
        }

        @Contract(value=" -> new")
        @NotNull
        public LocalVar renameVar() {
            return new LocalVar(this.ref.name(), this.ref.definition());
        }

        @Contract(value=" -> new")
        @NotNull
        public @NotNull Arg<@NotNull Term> toArg() {
            return new Arg<Term>(this.toTerm(), this.explicit);
        }

        @Contract(value=" -> new")
        @NotNull
        public RefTerm toTerm() {
            return new RefTerm(this.ref);
        }

        @NotNull
        public Pat toPat() {
            return new Pat.Bind(this.explicit, this.ref, this.type);
        }

        @NotNull
        public Param subst(@NotNull AnyVar var, @NotNull Term term) {
            return this.subst(new Subst(var, term));
        }

        @NotNull
        public Param subst(@NotNull Subst subst) {
            return this.subst(subst, 0);
        }

        @NotNull
        public static ImmutableSeq<Param> subst(@NotNull @NotNull ImmutableSeq<@NotNull Param> params, @NotNull Subst subst, int ulift) {
            return params.map(param -> param.subst(subst, ulift));
        }

        @NotNull
        public static ImmutableSeq<Param> subst(@NotNull @NotNull ImmutableSeq<@NotNull Param> params, int ulift) {
            return Param.subst(params, Subst.EMPTY, ulift);
        }

        @NotNull
        public Param subst(@NotNull Subst subst, int ulift) {
            return new Param(this.ref, this.type.subst(subst, ulift), this.explicit);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this, o);
        }

        @Override
        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }
}

