/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.range.primitive.IntRange;
import kala.tuple.Unit;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.ClassDecl;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.concrete.stmt.UseHide;
import org.aya.concrete.visitor.ExprTraversal;
import org.aya.distill.BaseDistiller;
import org.aya.generic.Arg;
import org.aya.generic.AyaDocile;
import org.aya.generic.Modifier;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.util.StringEscapeUtil;
import org.aya.util.binop.BinOpParser;
import org.aya.util.distill.DistillerOptions;
import org.jetbrains.annotations.NotNull;

public class ConcreteDistiller
extends BaseDistiller<Expr> {
    public ConcreteDistiller(@NotNull DistillerOptions options) {
        super(options);
    }

    @Override
    @NotNull
    public Doc term(@NotNull BaseDistiller.Outer outer, @NotNull Expr prexpr) {
        Expr expr = prexpr;
        Objects.requireNonNull(expr);
        Expr expr2 = expr;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.ErrorExpr.class, Expr.TupExpr.class, Expr.BinOpSeq.class, Expr.LitStringExpr.class, Expr.PiExpr.class, Expr.AppExpr.class, Expr.LamExpr.class, Expr.HoleExpr.class, Expr.ProjExpr.class, Expr.UnresolvedExpr.class, Expr.RefExpr.class, Expr.LitIntExpr.class, Expr.RawSortExpr.class, Expr.NewExpr.class, Expr.SigmaExpr.class, Expr.SortExpr.class, Expr.LiftExpr.class, Expr.MetaPat.class, Expr.PartEl.class, Expr.Path.class}, (Object)expr2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Expr.ErrorExpr error = (Expr.ErrorExpr)expr2;
                yield Doc.angled((Doc)error.description().toDoc(this.options));
            }
            case 1 -> {
                Expr.TupExpr expr = (Expr.TupExpr)expr2;
                yield Doc.parened((Doc)Doc.commaList((SeqLike)expr.items().view().map(e -> this.term(BaseDistiller.Outer.Free, (Expr)e))));
            }
            case 2 -> {
                Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr2;
                ImmutableSeq<Expr.NamedArg> seq = binOpSeq.seq();
                Expr first = ((Expr.NamedArg)seq.first()).expr();
                if (seq.sizeEquals(1)) {
                    yield this.term(outer, first);
                }
                yield this.visitCalls(false, this.term(BaseDistiller.Outer.AppSpine, first), seq.view().drop(1).map(e -> new Arg<Expr>(e.expr(), e.explicit())), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
            }
            case 3 -> {
                Expr.LitStringExpr expr = (Expr.LitStringExpr)expr2;
                yield Doc.plain((String)("\"" + StringEscapeUtil.unescapeStringCharacters((String)expr.string()) + "\""));
            }
            case 4 -> {
                Doc doc;
                final Expr.PiExpr expr = (Expr.PiExpr)expr2;
                final boolean[] data = new boolean[]{false, false};
                new ExprTraversal<Unit>(){

                    @Override
                    @NotNull
                    public Expr visitExpr(@NotNull Expr e, Unit unit) {
                        Expr expr3 = e;
                        Objects.requireNonNull(expr3);
                        Expr expr2 = expr3;
                        int n = 0;
                        block4: while (true) {
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.RefExpr.class, Expr.UnresolvedExpr.class}, (Object)expr2, n)) {
                                case 0: {
                                    Expr.RefExpr ref = (Expr.RefExpr)expr2;
                                    if (ref.resolvedVar() != expr.param().ref()) {
                                        n = 1;
                                        continue block4;
                                    }
                                    data[0] = true;
                                    break block4;
                                }
                                case 1: {
                                    Expr.UnresolvedExpr unresolved = (Expr.UnresolvedExpr)expr2;
                                    data[1] = true;
                                    break block4;
                                }
                            }
                            break;
                        }
                        return ExprTraversal.super.visitExpr(e, unit);
                    }
                }.visitExpr(expr.last(), Unit.unit());
                Doc last = this.term(BaseDistiller.Outer.Codomain, expr.last());
                if (!data[0] && !data[1]) {
                    Doc tyDoc = expr.param().type().toDoc(this.options);
                    doc = Doc.sep((Doc[])new Doc[]{Doc.bracedUnless((Doc)tyDoc, (boolean)expr.param().explicit()), Doc.symbol((String)"->"), last});
                } else {
                    doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), expr.param().toDoc(this.options), Doc.symbol((String)"->"), last});
                }
                yield ConcreteDistiller.checkParen(outer, doc, BaseDistiller.Outer.BinOp);
            }
            case 5 -> {
                Expr.RefExpr ref;
                AnyVar var16_27;
                Expr.AppExpr expr = (Expr.AppExpr)expr2;
                MutableList args = MutableList.of((Object)expr.argument());
                Expr head = Expr.unapp(expr.function(), (MutableList<Expr.NamedArg>)args);
                boolean infix = false;
                if (head instanceof Expr.RefExpr && (var16_27 = (ref = (Expr.RefExpr)head).resolvedVar()) instanceof DefVar) {
                    DefVar var = (DefVar)var16_27;
                    infix = var.isInfix();
                }
                yield this.visitCalls(infix, this.term(BaseDistiller.Outer.AppHead, head), args.view().map(arg -> new Arg<Expr>(arg.expr(), arg.explicit())), outer, (boolean)((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitArgs)));
            }
            case 6 -> {
                Expr.LamExpr expr = (Expr.LamExpr)expr2;
                if (!((Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats)).booleanValue() && !expr.param().explicit()) {
                    yield this.term(outer, expr.body());
                }
                MutableList prelude = MutableList.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")), (Object)this.lambdaParam(expr.param()));
                if (!(expr.body() instanceof Expr.HoleExpr)) {
                    prelude.append((Object)Doc.symbol((String)"=>"));
                    prelude.append((Object)this.term(BaseDistiller.Outer.Free, expr.body()));
                }
                yield ConcreteDistiller.checkParen(outer, Doc.sep((SeqLike)prelude), BaseDistiller.Outer.BinOp);
            }
            case 7 -> {
                Expr.HoleExpr expr = (Expr.HoleExpr)expr2;
                if (!expr.explicit()) {
                    yield Doc.symbol((String)"_");
                }
                Expr filling = expr.filling();
                if (filling == null) {
                    yield Doc.symbol((String)"{??}");
                }
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{?"), this.term(BaseDistiller.Outer.Free, filling), Doc.symbol((String)"?}")});
            }
            case 8 -> {
                Expr.ProjExpr expr = (Expr.ProjExpr)expr2;
                yield Doc.cat((Doc[])new Doc[]{this.term(BaseDistiller.Outer.ProjHead, expr.tup()), Doc.symbol((String)"."), Doc.plain((String)((String)expr.ix().fold(Objects::toString, QualifiedID::join)))});
            }
            case 9 -> {
                Expr.UnresolvedExpr expr = (Expr.UnresolvedExpr)expr2;
                yield Doc.plain((String)expr.name().join());
            }
            case 10 -> {
                Expr.RefExpr expr = (Expr.RefExpr)expr2;
                AnyVar ref = expr.resolvedVar();
                if (ref instanceof DefVar) {
                    DefVar defVar = (DefVar)ref;
                    yield ConcreteDistiller.defVar(defVar);
                }
                yield ConcreteDistiller.varDoc(ref);
            }
            case 11 -> {
                Expr.LitIntExpr expr = (Expr.LitIntExpr)expr2;
                yield Doc.plain((String)String.valueOf(expr.integer()));
            }
            case 12 -> {
                Expr.RawSortExpr e = (Expr.RawSortExpr)expr2;
                yield Doc.styled((Style)KEYWORD, (String)e.kind().name());
            }
            case 13 -> {
                Expr.NewExpr expr = (Expr.NewExpr)expr2;
                yield Doc.cblock((Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"new"), this.term(BaseDistiller.Outer.Free, expr.struct())}), (int)2, (Doc)Doc.vcat((SeqLike)expr.fields().view().map(t -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), Doc.styled((Style)FIELD_CALL, (String)((String)t.name().data())), Doc.emptyIf((boolean)t.bindings().isEmpty(), () -> Doc.sep((SeqLike)t.bindings().map(v -> ConcreteDistiller.varDoc((AnyVar)v.data())))), Doc.plain((String)"=>"), this.term(BaseDistiller.Outer.Free, t.body())}))));
            }
            case 14 -> {
                Expr.SigmaExpr expr = (Expr.SigmaExpr)expr2;
                yield ConcreteDistiller.checkParen(outer, Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele(expr.params().dropLast(1)), Doc.symbol((String)"**"), this.term(BaseDistiller.Outer.Codomain, ((Expr.Param)expr.params().last()).type())}), BaseDistiller.Outer.BinOp);
            }
            case 15 -> {
                Expr.SortExpr expr = (Expr.SortExpr)expr2;
                Doc fn = Doc.styled((Style)KEYWORD, (String)expr.kind().name());
                if (!expr.kind().hasLevel()) {
                    yield fn;
                }
                yield this.visitCalls(false, fn, (nc, l) -> l.toDoc(this.options), outer, SeqView.of(new Arg<AyaDocile>(o -> Doc.plain((String)String.valueOf(expr.lift())), true)), true);
            }
            case 16 -> {
                Expr.LiftExpr expr = (Expr.LiftExpr)expr2;
                yield Doc.sep((SeqLike)Seq.from((Iterator)IntRange.closed((int)1, (int)expr.lift()).iterator()).view().map($ -> Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"ulift"))).appended((Object)this.term(BaseDistiller.Outer.Lifted, expr.expr())));
            }
            case 17 -> {
                Expr.MetaPat metaPat = (Expr.MetaPat)expr2;
                yield metaPat.meta().toDoc(this.options);
            }
            case 18 -> {
                Expr.PartEl el = (Expr.PartEl)expr2;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{|"), Doc.join((Doc)Doc.spaced((Doc)Doc.symbol((String)"|")), (SeqLike)el.clauses().map(cl -> Doc.sep((Doc[])new Doc[]{((Expr)cl._1).toDoc(this.options), Doc.symbol((String)":="), ((Expr)cl._2).toDoc(this.options)}))), Doc.symbol((String)"|}")});
            }
            case 19 -> {
                Expr.Path path = (Expr.Path)expr2;
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"[|"), Doc.commaList((SeqLike)path.params().map(BaseDistiller::linkDef)), Doc.symbol((String)"|]"), path.type().toDoc(this.options), path.partial().toDoc(this.options)});
            }
        };
    }

    @NotNull
    public Doc pattern(@NotNull Pattern pattern, BaseDistiller.Outer outer) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Tuple.class, Pattern.Absurd.class, Pattern.Bind.class, Pattern.CalmFace.class, Pattern.Number.class, Pattern.Ctor.class, Pattern.BinOpSeq.class}, (Object)pattern3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                Doc tup = Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.patterns().view().map(p -> this.pattern((Pattern)p, BaseDistiller.Outer.Free))));
                if (tuple.as() == null) {
                    yield tup;
                }
                yield Doc.sep((Doc[])new Doc[]{tup, Doc.styled((Style)KEYWORD, (String)"as"), ConcreteDistiller.linkDef(tuple.as())});
            }
            case 1 -> {
                Pattern.Absurd absurd = (Pattern.Absurd)pattern3;
                yield Doc.bracedUnless((Doc)Doc.styled((Style)KEYWORD, (String)"()"), (boolean)absurd.explicit());
            }
            case 2 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern3;
                yield Doc.bracedUnless((Doc)ConcreteDistiller.linkDef(bind.bind()), (boolean)bind.explicit());
            }
            case 3 -> {
                Pattern.CalmFace calmFace = (Pattern.CalmFace)pattern3;
                yield Doc.bracedUnless((Doc)Doc.plain((String)"_"), (boolean)calmFace.explicit());
            }
            case 4 -> {
                Pattern.Number number = (Pattern.Number)pattern3;
                yield Doc.bracedUnless((Doc)Doc.plain((String)String.valueOf(number.number())), (boolean)number.explicit());
            }
            case 5 -> {
                Pattern.Ctor ctor = (Pattern.Ctor)pattern3;
                Doc name = ConcreteDistiller.linkRef((AnyVar)ctor.resolved().data(), CON_CALL);
                Doc ctorDoc = ctor.params().isEmpty() ? name : Doc.sep((Doc[])new Doc[]{name, this.visitMaybeCtorPatterns((SeqLike<Pattern>)ctor.params(), BaseDistiller.Outer.AppSpine, Doc.ALT_WS)});
                yield this.ctorDoc(outer, ctor.explicit(), ctorDoc, ctor.as(), ctor.params().isEmpty());
            }
            case 6 -> {
                Pattern.BinOpSeq seq = (Pattern.BinOpSeq)pattern3;
                ImmutableSeq<Pattern> param = seq.seq();
                if (param.sizeEquals(1)) {
                    yield this.pattern((Pattern)param.first(), outer);
                }
                Doc ctorDoc = this.visitMaybeCtorPatterns((SeqLike<Pattern>)param, BaseDistiller.Outer.AppSpine, Doc.ALT_WS);
                yield this.ctorDoc(outer, seq.explicit(), ctorDoc, seq.as(), param.sizeLessThanOrEquals(1));
            }
        };
    }

    private Doc visitMaybeCtorPatterns(SeqLike<Pattern> patterns, BaseDistiller.Outer outer, @NotNull Doc delim) {
        patterns = (Boolean)this.options.map.get(DistillerOptions.Key.ShowImplicitPats) != false ? patterns : patterns.view().filter(BinOpParser.Elem::explicit);
        return Doc.join((Doc)delim, (SeqLike)patterns.view().map(p -> this.pattern((Pattern)p, outer)));
    }

    public Doc matchy(@NotNull Pattern.Clause match) {
        Doc doc = this.visitMaybeCtorPatterns((SeqLike<Pattern>)match.patterns, BaseDistiller.Outer.Free, Doc.plain((String)", "));
        return (Doc)match.expr.map(e -> Doc.sep((Doc[])new Doc[]{doc, Doc.plain((String)"=>"), this.term(BaseDistiller.Outer.Free, (Expr)e)})).getOrDefault((Object)doc);
    }

    private Doc visitAccess(@NotNull Stmt.Accessibility accessibility, Stmt.Accessibility def) {
        if (accessibility == def) {
            return Doc.empty();
        }
        return Doc.styled((Style)KEYWORD, (String)accessibility.keyword);
    }

    @NotNull
    public Doc stmt(@NotNull Stmt prestmt) {
        Stmt stmt = prestmt;
        Objects.requireNonNull(stmt);
        Stmt stmt2 = stmt;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Import.class, Generalize.class, Remark.class, Command.Open.class, Command.Module.class}, (Object)stmt2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Decl decl = (Decl)stmt2;
                yield this.decl(decl);
            }
            case 1 -> {
                Command.Import cmd = (Command.Import)stmt2;
                MutableList prelude = MutableList.of((Object)Doc.styled((Style)KEYWORD, (String)"import"), (Object)Doc.symbol((String)cmd.path().join()));
                if (cmd.asName() != null) {
                    prelude.append((Object)Doc.styled((Style)KEYWORD, (String)"as"));
                    prelude.append((Object)Doc.plain((String)cmd.asName()));
                }
                yield Doc.sep((SeqLike)prelude);
            }
            case 2 -> {
                Generalize variables = (Generalize)stmt2;
                yield Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"variables"), this.visitTele(variables.toExpr())});
            }
            case 3 -> {
                Remark remark = (Remark)stmt2;
                Literate literate = remark.literate;
                if (literate != null) {
                    yield literate.toDoc();
                }
                yield Doc.plain((String)remark.raw);
            }
            case 4 -> {
                Command.Open cmd = (Command.Open)stmt2;
                Doc[] v2 = new Doc[5];
                v2[0] = this.visitAccess(cmd.accessibility(), Stmt.Accessibility.Private);
                v2[1] = Doc.styled((Style)KEYWORD, (String)"open");
                v2[2] = Doc.plain((String)cmd.path().join());
                String v3 = switch (cmd.useHide().strategy()) {
                    default -> throw new IncompatibleClassChangeError();
                    case UseHide.Strategy.Using -> "using";
                    case UseHide.Strategy.Hiding -> "hiding";
                };
                v2[3] = Doc.styled((Style)KEYWORD, (String)v3);
                v2[4] = Doc.parened((Doc)Doc.commaList((SeqLike)cmd.useHide().list().view().map(name -> name.asName().equals(name.id()) ? Doc.plain((String)name.id()) : Doc.sep((Doc[])new Doc[]{Doc.plain((String)name.id()), Doc.styled((Style)KEYWORD, (String)"as"), Doc.plain((String)name.asName())}))));
                yield Doc.sepNonEmpty((Doc[])v2);
            }
            case 5 -> {
                Command.Module mod = (Command.Module)stmt2;
                yield Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{this.visitAccess(mod.accessibility(), Stmt.Accessibility.Public), Doc.styled((Style)KEYWORD, (String)"module"), Doc.plain((String)mod.name()), Doc.symbol((String)"{")}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)mod.contents().view().map(this::stmt))), Doc.symbol((String)"}")});
            }
        };
    }

    private Stmt.Accessibility defaultAcc(@NotNull Decl.Personality personality) {
        return personality == Decl.Personality.NORMAL ? Stmt.Accessibility.Public : Stmt.Accessibility.Private;
    }

    @NotNull
    public Doc decl(@NotNull Decl predecl) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.StructDecl.class, TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.PrimDecl.class, TeleDecl.StructField.class, TeleDecl.DataCtor.class}, (Object)decl2, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                ClassDecl classDecl = (ClassDecl)decl2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1 -> {
                TeleDecl.StructDecl decl = (TeleDecl.StructDecl)decl2;
                MutableList prelude = MutableList.of((Object)this.visitAccess(decl.accessibility(), this.defaultAcc(decl.personality())), (Object)this.visitPersonality(decl.personality()), (Object)Doc.styled((Style)KEYWORD, (String)"struct"), (Object)ConcreteDistiller.linkDef(decl.ref, STRUCT_CALL), (Object)this.visitTele(decl.telescope));
                this.appendResult((MutableList<Doc>)prelude, decl.result);
                yield Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.fields.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.fields.view().map(this::decl)))})), this.visitBindBlock(decl.bindBlock)});
            }
            case 2 -> {
                TeleDecl.FnDecl decl = (TeleDecl.FnDecl)decl2;
                MutableList prelude = MutableList.of((Object)this.visitAccess(decl.accessibility(), this.defaultAcc(decl.personality())), (Object)this.visitPersonality(decl.personality()), (Object)Doc.styled((Style)KEYWORD, (String)"def"));
                prelude.appendAll((Iterable)Seq.from(decl.modifiers).view().map(this::visitModifier));
                prelude.append((Object)ConcreteDistiller.linkDef(decl.ref, FN_CALL));
                prelude.append((Object)this.visitTele(decl.telescope));
                this.appendResult((MutableList<Doc>)prelude, decl.result);
                yield Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), (Doc)decl.body.fold(expr -> Doc.cat((Doc[])new Doc[]{Doc.spaced((Doc)Doc.symbol((String)"=>")), this.term(BaseDistiller.Outer.Free, (Expr)expr)}), clauses -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Pattern.Clause>)clauses))})), this.visitBindBlock(decl.bindBlock)});
            }
            case 3 -> {
                TeleDecl.DataDecl decl = (TeleDecl.DataDecl)decl2;
                MutableList prelude = MutableList.of((Object)this.visitAccess(decl.accessibility(), this.defaultAcc(decl.personality())), (Object)this.visitPersonality(decl.personality()), (Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)ConcreteDistiller.linkDef(decl.ref, DATA_CALL), (Object)this.visitTele(decl.telescope));
                this.appendResult((MutableList<Doc>)prelude, decl.result);
                yield Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.body.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.body.view().map(this::decl)))})), this.visitBindBlock(decl.bindBlock)});
            }
            case 4 -> {
                TeleDecl.PrimDecl decl = (TeleDecl.PrimDecl)decl2;
                yield ConcreteDistiller.primDoc(decl.ref);
            }
            case 5 -> {
                TeleDecl.StructField field = (TeleDecl.StructField)decl2;
                MutableList doc = MutableList.of((Object)Doc.symbol((String)"|"), (Object)ConcreteDistiller.coe(field.coerce), (Object)ConcreteDistiller.linkDef(field.ref, FIELD_CALL), (Object)this.visitTele(field.telescope));
                this.appendResult((MutableList<Doc>)doc, field.result);
                if (field.body.isDefined()) {
                    doc.append((Object)Doc.symbol((String)"=>"));
                    doc.append((Object)this.term(BaseDistiller.Outer.Free, (Expr)field.body.get()));
                }
                yield Doc.sepNonEmpty((SeqLike)doc);
            }
            case 6 -> {
                TeleDecl.DataCtor ctor = (TeleDecl.DataCtor)decl2;
                Doc doc = Doc.cblock((Doc)Doc.sepNonEmpty((Doc[])new Doc[]{ConcreteDistiller.coe(ctor.coerce), ConcreteDistiller.linkDef(ctor.ref, CON_CALL), this.visitTele(ctor.telescope)}), (int)2, (Doc)this.visitClauses(ctor.clauses));
                if (ctor.patterns.isNotEmpty()) {
                    Doc pats = Doc.commaList((SeqLike)ctor.patterns.view().map(pattern -> this.pattern((Pattern)pattern, BaseDistiller.Outer.Free)));
                    yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.plain((String)"=>"), doc});
                }
                yield Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
            }
        };
    }

    @NotNull
    public Doc visitPersonality(@NotNull Decl.Personality personality) {
        return switch (personality) {
            default -> throw new IncompatibleClassChangeError();
            case Decl.Personality.NORMAL -> Doc.empty();
            case Decl.Personality.EXAMPLE -> Doc.styled((Style)KEYWORD, (String)"example");
            case Decl.Personality.COUNTEREXAMPLE -> Doc.styled((Style)KEYWORD, (String)"counterexample");
        };
    }

    private Doc visitClauses(@NotNull ImmutableSeq<Pattern.Clause> clauses) {
        if (clauses.isEmpty()) {
            return Doc.empty();
        }
        return Doc.vcat((SeqLike)clauses.view().map(this::matchy).map(doc -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc})));
    }

    private void appendResult(MutableList<Doc> prelude, Expr result) {
        if (result instanceof Expr.HoleExpr) {
            return;
        }
        prelude.append((Object)Doc.symbol((String)":"));
        prelude.append((Object)this.term(BaseDistiller.Outer.Free, result));
    }

    public Doc visitBindBlock(@NotNull BindBlock bindBlock) {
        if (bindBlock == BindBlock.EMPTY) {
            return Doc.empty();
        }
        ImmutableSeq loosers = (ImmutableSeq)bindBlock.resolvedLoosers().get();
        ImmutableSeq tighters = (ImmutableSeq)bindBlock.resolvedTighters().get();
        if (loosers.isEmpty() && tighters.isEmpty()) {
            return Doc.empty();
        }
        if (loosers.isEmpty()) {
            return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.styled((Style)KEYWORD, (String)"tighter"), Doc.commaList((SeqLike)tighters.view().map(BaseDistiller::defVar))}))});
        }
        if (tighters.isEmpty()) {
            return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.styled((Style)KEYWORD, (String)"looser"), Doc.commaList((SeqLike)loosers.view().map(BaseDistiller::defVar))}))});
        }
        return Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.hang((int)2, (Doc)Doc.cat((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.braced((Doc)Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"tighter"), Doc.commaList((SeqLike)tighters.view().map(BaseDistiller::defVar)), Doc.styled((Style)KEYWORD, (String)"looser"), Doc.commaList((SeqLike)loosers.view().map(BaseDistiller::defVar))}))}))});
    }

    @NotNull
    private Doc visitModifier(@NotNull Modifier modifier) {
        return Doc.styled((Style)KEYWORD, (String)modifier.keyword);
    }
}

