/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic;

import java.util.regex.Pattern;
import org.aya.concrete.Expr;
import org.aya.ref.LocalVar;
import org.aya.util.error.Global;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Constants {
    @NotNull
    @NonNls
    public static final String ANONYMOUS_PREFIX = "_";
    @NotNull
    @NonNls
    public static final String GENERATED_POSTFIX = "'";
    @NotNull
    @NonNls
    public static final String SCOPE_SEPARATOR = "::";
    @NotNull
    public static final Pattern SCOPE_SEPARATOR_PATTERN = Pattern.compile("::");
    @NotNull
    @NonNls
    public static final String AYA_POSTFIX = ".aya";
    @NotNull
    @NonNls
    public static final String AYA_LITERATE_POSTFIX = ".aya.md";
    @NotNull
    public static final Pattern AYA_POSTFIX_PATTERN = Pattern.compile("(\\.aya$)|(\\.aya\\.md$)");
    @NotNull
    @NonNls
    public static final String AYAC_POSTFIX = ".ayac";
    @NotNull
    @NonNls
    public static final String AYA_JSON = "aya.json";
    @NotNull
    @NonNls
    public static final String ALTERNATIVE_EMPTY = "empty";
    @NotNull
    @NonNls
    public static final String ALTERNATIVE_OR = "<|>";
    @NotNull
    @NonNls
    public static final String LIST_NIL = "nil";
    @NotNull
    @NonNls
    public static final String LIST_CONS = ":<";
    @NotNull
    @NonNls
    public static final String APPLICATIVE_APP = "<*>";
    @NotNull
    @NonNls
    public static final String FUNCTOR_PURE = "pure";
    @NotNull
    @NonNls
    public static final String MONAD_BIND = ">>=";

    @NotNull
    public static Expr alternativeOr(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, ALTERNATIVE_OR);
    }

    @NotNull
    public static Expr alternativeEmpty(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, ALTERNATIVE_EMPTY);
    }

    @NotNull
    public static Expr listNil(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, LIST_NIL);
    }

    @NotNull
    public static Expr listCons(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, LIST_CONS);
    }

    @NotNull
    public static Expr applicativeApp(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, APPLICATIVE_APP);
    }

    @NotNull
    public static Expr functorPure(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, FUNCTOR_PURE);
    }

    @NotNull
    public static Expr monadBind(@NotNull SourcePos pos) {
        return new Expr.UnresolvedExpr(pos, MONAD_BIND);
    }

    @NotNull
    public static LocalVar anonymous() {
        return new LocalVar(ANONYMOUS_PREFIX, SourcePos.NONE);
    }

    @NotNull
    public static LocalVar randomlyNamed(@NotNull SourcePos pos) {
        return new LocalVar(Constants.randomName(pos), pos);
    }

    @NotNull
    public static String randomName(@NotNull Object pos) {
        if (Global.NO_RANDOM_NAME) {
            return ANONYMOUS_PREFIX;
        }
        return ANONYMOUS_PREFIX + Math.abs(pos.hashCode()) % 10;
    }
}

