/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.module;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import org.aya.concrete.GenericAyaParser;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.PrimDef;
import org.aya.generic.util.AyaFiles;
import org.aya.generic.util.InternalException;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.ModuleLoader;
import org.aya.util.error.SourceFileLocator;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FileModuleLoader(@NotNull SourceFileLocator locator, @NotNull Path basePath, @NotNull Reporter reporter, @NotNull GenericAyaParser parser, @NotNull PrimDef.Factory primFactory,  @Nullable Trace.Builder builder) implements ModuleLoader
{
    @Override
    @Nullable
    public ResolveInfo load(@NotNull @NotNull ImmutableSeq<@NotNull String> path, @NotNull ModuleLoader recurseLoader) {
        Path sourcePath = AyaFiles.resolveAyaSourceFile(this.basePath, path);
        try {
            ImmutableSeq<Stmt> program = this.parser.program(this.locator, sourcePath);
            PhysicalModuleContext context = new EmptyContext(this.reporter, sourcePath).derive((Seq<String>)path);
            return this.tyckModule(this.builder, this.resolveModule(this.primFactory, context, program, recurseLoader), null);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void handleInternalError(@NotNull InternalException e) {
        e.printStackTrace();
        e.printHint();
        System.err.println("Please report the stacktrace to the developers so a better error handling could be made.\nDon't forget to inform the version of Aya you're using and attach your code for reproduction.");
    }
}

