/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableStack;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.concrete.Expr;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.GeneralizedVar;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.generic.util.InternalException;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.GeneralizedNotAvailableError;
import org.aya.tyck.error.FieldError;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ExprResolver(@NotNull Options options, @NotNull MutableMap<GeneralizedVar, Expr.Param> allowedGeneralizes, @NotNull MutableList<TyckOrder> reference, @NotNull MutableStack<Where> where, @Nullable Consumer<TyckUnit> parentAdd) {
    @NotNull
    public static final Options RESTRICTIVE = new Options(false, false);
    @NotNull
    public static final Options LAX = new Options(true, true);

    public ExprResolver(@NotNull Options options) {
        this(options, (MutableMap<GeneralizedVar, Expr.Param>)MutableLinkedHashMap.of(), (MutableList<TyckOrder>)MutableList.create(), (MutableStack<Where>)MutableStack.create(), null);
    }

    @NotNull
    public Expr resolve(@NotNull Expr expr, @NotNull Context ctx) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.LiftExpr.class, Expr.AppExpr.class, Expr.TupExpr.class, Expr.NewExpr.class, Expr.BinOpSeq.class, Expr.ProjExpr.class, Expr.LamExpr.class, Expr.SigmaExpr.class, Expr.PiExpr.class, Expr.HoleExpr.class, Expr.PartEl.class, Expr.Path.class, Expr.UnresolvedExpr.class}, (Object)expr3, n)) {
            case 0 -> {
                Expr.LiftExpr lift = (Expr.LiftExpr)expr3;
                Expr mapped = this.resolve(lift.expr(), ctx);
                if (mapped == lift.expr()) {
                    yield expr;
                }
                yield new Expr.LiftExpr(expr.sourcePos(), mapped, lift.lift());
            }
            case 1 -> {
                Expr.AppExpr app = (Expr.AppExpr)expr3;
                Expr function = this.resolve(app.function(), ctx);
                Expr.NamedArg argument = app.argument();
                Expr argExpr = this.resolve(argument.expr(), ctx);
                if (function == app.function() && argExpr == argument.expr()) {
                    yield app;
                }
                Expr.NamedArg newArg = new Expr.NamedArg(argument.explicit(), argument.name(), argExpr);
                yield new Expr.AppExpr(app.sourcePos(), function, newArg);
            }
            case 2 -> {
                Expr.TupExpr tup = (Expr.TupExpr)expr3;
                ImmutableSeq items = tup.items().map(item -> this.resolve((Expr)item, ctx));
                if (items.sameElements(tup.items(), true)) {
                    yield expr;
                }
                yield new Expr.TupExpr(expr.sourcePos(), (ImmutableSeq<Expr>)items);
            }
            case 3 -> {
                Expr.NewExpr newExpr = (Expr.NewExpr)expr3;
                Expr struct = this.resolve(newExpr.struct(), ctx);
                ImmutableSeq fields = newExpr.fields().map(t -> this.resolveField((Expr.Field)t, ctx));
                if (newExpr.struct() == struct && fields.sameElements(newExpr.fields(), true)) {
                    yield newExpr;
                }
                yield new Expr.NewExpr(newExpr.sourcePos(), struct, (ImmutableSeq<Expr.Field>)fields);
            }
            case 4 -> {
                Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr3;
                yield new Expr.BinOpSeq(binOpSeq.sourcePos(), (ImmutableSeq<Expr.NamedArg>)binOpSeq.seq().map(e -> new Expr.NamedArg(e.explicit(), e.name(), this.resolve(e.expr(), ctx))));
            }
            case 5 -> {
                Expr.ProjExpr proj = (Expr.ProjExpr)expr3;
                Expr tup = this.resolve(proj.tup(), ctx);
                if (proj.ix().isLeft()) {
                    yield new Expr.ProjExpr(proj.sourcePos(), tup, proj.ix(), proj.resolvedIx(), proj.theCore());
                }
                QualifiedID projName = (QualifiedID)proj.ix().getRightValue();
                AnyVar resolvedIx = ctx.getMaybe(projName);
                if (resolvedIx == null) {
                    ctx.reportAndThrow(new FieldError.UnknownField(proj, projName.join()));
                }
                yield new Expr.ProjExpr(proj.sourcePos(), tup, proj.ix(), resolvedIx, proj.theCore());
            }
            case 6 -> {
                Expr.LamExpr lam = (Expr.LamExpr)expr3;
                Tuple2<Expr.Param, Context> param = this.resolveParam(lam.param(), ctx);
                Expr body = this.resolve(lam.body(), (Context)param._2);
                yield new Expr.LamExpr(lam.sourcePos(), (Expr.Param)param._1, body);
            }
            case 7 -> {
                Expr.SigmaExpr sigma = (Expr.SigmaExpr)expr3;
                Tuple2<SeqView<Expr.Param>, Context> params = this.resolveParams((SeqLike<Expr.Param>)sigma.params(), ctx);
                yield new Expr.SigmaExpr(sigma.sourcePos(), sigma.co(), (ImmutableSeq<Expr.Param>)((SeqView)params._1).toImmutableSeq());
            }
            case 8 -> {
                Expr.PiExpr pi = (Expr.PiExpr)expr3;
                Tuple2<Expr.Param, Context> param = this.resolveParam(pi.param(), ctx);
                Expr last = this.resolve(pi.last(), (Context)param._2);
                yield new Expr.PiExpr(pi.sourcePos(), pi.co(), (Expr.Param)param._1, last);
            }
            case 9 -> {
                Expr h;
                Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                hole.accessibleLocal().set((Object)ctx.collect((MutableList<LocalVar>)MutableList.create()).toImmutableSeq());
                Expr v2 = h = hole.filling() != null ? this.resolve(hole.filling(), ctx) : null;
                if (h == hole.filling()) {
                    yield hole;
                }
                yield new Expr.HoleExpr(hole.sourcePos(), hole.explicit(), h, hole.accessibleLocal());
            }
            case 10 -> {
                Expr.PartEl el = (Expr.PartEl)expr3;
                yield this.partial(ctx, el);
            }
            case 11 -> {
                Expr.Path path = (Expr.Path)expr3;
                Context newCtx = this.resolveCubeParams(path.params(), ctx);
                Expr.PartEl par = this.partial(newCtx, path.partial());
                Expr type = this.resolve(path.type(), newCtx);
                if (type == path.type() && par == path.partial()) {
                    yield path;
                }
                yield new Expr.Path(path.sourcePos(), path.params(), type, par);
            }
            case 12 -> {
                Expr.UnresolvedExpr unresolved = (Expr.UnresolvedExpr)expr3;
                SourcePos sourcePos = unresolved.sourcePos();
                AnyVar v3 = ctx.get(unresolved.name());
                Objects.requireNonNull(v3);
                AnyVar var19_39 = v3;
                int var20_40 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, AnyVar.class}, (Object)var19_39, var20_40)) {
                    case 0: {
                        GeneralizedVar generalized = (GeneralizedVar)var19_39;
                        if (this.options.allowGeneralized) {
                            if (!this.allowedGeneralizes.containsKey((Object)generalized)) {
                                Generalize owner = generalized.owner;
                                if (!$assertionsDisabled && owner == null) {
                                    throw new AssertionError((Object)"Sanity check");
                                }
                                this.allowedGeneralizes.put((Object)generalized, (Object)owner.toExpr(false, generalized.toLocal()));
                                this.addReference(owner);
                            }
                        } else if (!this.allowedGeneralizes.containsKey((Object)generalized)) {
                            this.generalizedUnavailable(ctx, sourcePos, generalized);
                        }
                        yield new Expr.RefExpr(sourcePos, ((Expr.Param)this.allowedGeneralizes.get((Object)generalized)).ref());
                    }
                    case 1: {
                        DefVar ref = (DefVar)var19_39;
                        Object var23_44 = ref.concrete;
                        int var24_46 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class}, var23_44, var24_46)) {
                            case -1: {
                                if (!$assertionsDisabled && ref.core == null) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                            default: {
                                Object unit = var23_44;
                                this.addReference((TyckUnit)unit);
                            }
                        }
                        yield new Expr.RefExpr(sourcePos, ref);
                    }
                }
                AnyVar var = var19_39;
                yield new Expr.RefExpr(sourcePos, var);
            }
            default -> expr;
        };
    }

    @NotNull
    private Expr.PartEl partial(@NotNull Context ctx, Expr.PartEl el) {
        ImmutableSeq partial = el.clauses().map(e -> Tuple.of((Object)this.resolve((Expr)e._1, ctx), (Object)this.resolve((Expr)e._2, ctx)));
        if (partial.zipView(el.clauses()).allMatch(p -> ((Tuple2)p._1)._1 == ((Tuple2)p._2)._1 && ((Tuple2)p._1)._2 == ((Tuple2)p._2)._2)) {
            return el;
        }
        return new Expr.PartEl(el.sourcePos(), (ImmutableSeq<Tuple2<Expr, Expr>>)partial);
    }

    public void enterHead() {
        this.where.push((Object)Where.Head);
        this.reference.clear();
    }

    public void enterBody() {
        this.where.push((Object)Where.Body);
        this.reference.clear();
    }

    private void addReference(@NotNull TyckUnit unit) {
        if (this.parentAdd != null) {
            this.parentAdd.accept(unit);
        }
        if (this.where.isEmpty()) {
            throw new InternalException("where am I?");
        }
        if (this.where.peek() == Where.Head) {
            this.reference.append((Object)new TyckOrder.Head(unit));
            this.reference.append((Object)new TyckOrder.Body(unit));
        } else {
            this.reference.append((Object)new TyckOrder.Body(unit));
        }
    }

    @NotNull
    public ExprResolver member(@NotNull TyckUnit decl) {
        return new ExprResolver(RESTRICTIVE, this.allowedGeneralizes, (MutableList<TyckOrder>)MutableList.of((Object)new TyckOrder.Head(decl)), (MutableStack<Where>)MutableStack.create(), this::addReference);
    }

    @NotNull
    public ExprResolver body() {
        return new ExprResolver(RESTRICTIVE, this.allowedGeneralizes, this.reference, (MutableStack<Where>)MutableStack.create(), this::addReference);
    }

    private void generalizedUnavailable(Context ctx, SourcePos refExpr, AnyVar var) {
        ctx.reporter().report((Problem)new GeneralizedNotAvailableError(refExpr, var));
        throw new Context.ResolvingInterruptedException();
    }

    @NotNull
    private Tuple2<Expr.Param, Context> resolveParam(@NotNull Expr.Param param, Context ctx) {
        Expr type = this.resolve(param.type(), ctx);
        return Tuple2.of((Object)new Expr.Param(param, type), (Object)ctx.bind(param.ref(), param.sourcePos()));
    }

    @NotNull
    private Context resolveCubeParams(@NotNull ImmutableSeq<LocalVar> params, Context ctx) {
        return (Context)params.foldLeft((Object)ctx, (c, x) -> c.bind((LocalVar)x, x.definition()));
    }

    @Contract(pure=true)
    @NotNull
    public Tuple2<SeqView<Expr.Param>, Context> resolveParams(@NotNull SeqLike<Expr.Param> params, Context ctx) {
        if (params.isEmpty()) {
            return Tuple2.of((Object)SeqView.empty(), (Object)ctx);
        }
        Expr.Param first = (Expr.Param)params.first();
        Expr type = this.resolve(first.type(), ctx);
        Context newCtx = ctx.bind(first.ref(), first.sourcePos());
        Tuple2<SeqView<Expr.Param>, Context> result = this.resolveParams((SeqLike<Expr.Param>)params.view().drop(1), newCtx);
        return Tuple2.of((Object)((SeqView)result._1).prepended((Object)new Expr.Param(first, type)), (Object)((Context)result._2));
    }

    private @NotNull Expr.Field resolveField(@NotNull Expr.Field t, Context context) {
        for (WithPos binding : t.bindings()) {
            context = context.bind((LocalVar)binding.data(), binding.sourcePos());
        }
        Expr accept = this.resolve(t.body(), context);
        if (accept == t.body()) {
            return t;
        }
        return new Expr.Field(t.name(), t.bindings(), accept, t.resolvedField());
    }

    public record Options(boolean allowLevels, boolean allowGeneralized) {
    }

    static enum Where {
        Head,
        Body;

    }
}

