/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.value.MutableValue;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.AyaBinOpSet;
import org.aya.concrete.error.OperatorError;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.BindBlock;
import org.aya.concrete.stmt.ClassDecl;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.PrimDef;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.ref.LocalVar;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.visitor.ExprResolver;
import org.aya.tyck.order.TyckOrder;
import org.aya.tyck.order.TyckUnit;
import org.aya.util.binop.OpDecl;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StmtResolver {
    public static void resolveStmt(@NotNull @NotNull SeqLike<@NotNull Stmt> stmt, @NotNull ResolveInfo info) {
        stmt.forEach(s -> StmtResolver.resolveStmt(s, info));
    }

    public static void resolveStmt(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Module.class, Remark.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Decl decl = (Decl)stmt3;
                StmtResolver.resolveDecl(decl, info);
                break;
            }
            case 1: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveStmt(mod.contents(), info);
                break;
            }
            case 2: {
                Remark remark = (Remark)stmt3;
                info.depGraph().sucMut((Object)new TyckOrder.Body(remark)).appendAll(remark.doResolve(info));
                break;
            }
            case 3: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 4: {
                Generalize variables = (Generalize)stmt3;
                ExprResolver resolver = new ExprResolver(ExprResolver.RESTRICTIVE);
                resolver.enterBody();
                if (!1.$assertionsDisabled && variables.ctx == null) {
                    throw new AssertionError();
                }
                variables.type = resolver.resolve(variables.type, variables.ctx);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(variables), resolver);
            }
        }
    }

    private static void resolveDecl(@NotNull Decl predecl, @NotNull ResolveInfo info) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, TeleDecl.FnDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.PrimDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class}, (Object)decl2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                ClassDecl classDecl = (ClassDecl)decl2;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 1: {
                TeleDecl.FnDecl decl3 = (TeleDecl.FnDecl)decl2;
                Tuple2<ExprResolver, Context> local = StmtResolver.resolveDeclSignature(decl3, ExprResolver.LAX);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl3), (ExprResolver)local._1);
                ((ExprResolver)local._1).enterBody();
                ExprResolver bodyResolver = ((ExprResolver)local._1).body();
                bodyResolver.enterBody();
                decl3.body = decl3.body.map(expr -> bodyResolver.resolve((Expr)expr, (Context)local._2), pats -> pats.map(clause -> StmtResolver.matchy(clause, (Context)local._2, bodyResolver)));
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl3), (ExprResolver)local._1);
                break;
            }
            case 2: {
                TeleDecl.DataDecl decl4 = (TeleDecl.DataDecl)decl2;
                Tuple2<ExprResolver, Context> local = StmtResolver.resolveDeclSignature(decl4, ExprResolver.LAX);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl4), (ExprResolver)local._1);
                ((ExprResolver)local._1).enterBody();
                decl4.body.forEach(ctor -> {
                    ExprResolver bodyResolver = ((ExprResolver)local._1).member(decl4);
                    bodyResolver.enterHead();
                    MutableValue localCtxWithPat = MutableValue.create((Object)((Context)local._2));
                    ctor.patterns = ctor.patterns.map(pattern -> StmtResolver.subpatterns((MutableValue<Context>)localCtxWithPat, pattern));
                    Tuple2<SeqView<Expr.Param>, Context> ctorLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)ctor.telescope, (Context)localCtxWithPat.get());
                    ctor.telescope = ((SeqView)ctorLocal._1).toImmutableSeq();
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head((TyckUnit)ctor), (SeqView<TyckOrder>)bodyResolver.reference().view().appended((Object)new TyckOrder.Head(decl4)));
                    bodyResolver.enterBody();
                    ctor.clauses = ctor.clauses.map(clause -> StmtResolver.matchy(clause, (Context)ctorLocal._2, bodyResolver));
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)ctor), bodyResolver);
                });
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl4), (SeqView<TyckOrder>)((ExprResolver)local._1).reference().view().concat((SeqLike)decl4.body.map(TyckOrder.Body::new)));
                break;
            }
            case 3: {
                TeleDecl.StructDecl decl5 = (TeleDecl.StructDecl)decl2;
                Tuple2<ExprResolver, Context> local = StmtResolver.resolveDeclSignature(decl5, ExprResolver.LAX);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl5), (ExprResolver)local._1);
                ((ExprResolver)local._1).enterBody();
                decl5.fields.forEach(field -> {
                    ExprResolver bodyResolver = ((ExprResolver)local._1).member(decl5);
                    bodyResolver.enterHead();
                    Tuple2<SeqView<Expr.Param>, Context> fieldLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)field.telescope, (Context)local._2);
                    field.telescope = ((SeqView)fieldLocal._1).toImmutableSeq();
                    field.result = bodyResolver.resolve(field.result, (Context)fieldLocal._2);
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head((TyckUnit)field), (SeqView<TyckOrder>)bodyResolver.reference().view().appended((Object)new TyckOrder.Head(decl5)));
                    bodyResolver.enterBody();
                    field.body = field.body.map(e -> bodyResolver.resolve((Expr)e, (Context)fieldLocal._2));
                    StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body((TyckUnit)field), bodyResolver);
                });
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl5), (SeqView<TyckOrder>)((ExprResolver)local._1).reference().view().concat((SeqLike)decl5.fields.map(TyckOrder.Body::new)));
                break;
            }
            case 4: {
                TeleDecl.PrimDecl decl6 = (TeleDecl.PrimDecl)decl2;
                ExprResolver resolver = (ExprResolver)StmtResolver.resolveDeclSignature((TeleDecl)decl6, (ExprResolver.Options)ExprResolver.RESTRICTIVE)._1;
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Head(decl6), resolver);
                StmtResolver.addReferences(info, (TyckOrder)new TyckOrder.Body(decl6), (SeqView<TyckOrder>)SeqView.empty());
                break;
            }
            case 5: {
                TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)decl2;
                break;
            }
            case 6: {
                TeleDecl.StructField structField = (TeleDecl.StructField)decl2;
            }
        }
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, SeqView<TyckOrder> refs) {
        info.depGraph().sucMut((Object)decl).appendAll((Iterable)refs.filter(unit -> unit.unit().needTyck(info.thisModule().moduleName())));
        if (decl instanceof TyckOrder.Body) {
            info.depGraph().sucMut((Object)decl).append((Object)new TyckOrder.Head(decl.unit()));
        }
    }

    private static void addReferences(@NotNull ResolveInfo info, TyckOrder decl, ExprResolver resolver) {
        StmtResolver.addReferences(info, decl, (SeqView<TyckOrder>)resolver.reference().view());
    }

    @NotNull
    private static Tuple2<ExprResolver, Context> resolveDeclSignature(@NotNull TeleDecl decl, @NotNull ExprResolver.Options options) {
        ExprResolver resolver = new ExprResolver(options);
        resolver.enterHead();
        Tuple2<SeqView<Expr.Param>, Context> local = resolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.result = resolver.resolve(decl.result, (Context)local._2);
        decl.telescope = ((SeqView)local._1).prependedAll((Iterable)resolver.allowedGeneralizes().valuesView()).toImmutableSeq();
        return Tuple.of((Object)resolver, (Object)((Context)local._2));
    }

    public static void visitBind(@NotNull DefVar<?, ?> selfDef, @NotNull BindBlock bind, @NotNull ResolveInfo info) {
        AyaBinOpSet opSet = info.opSet();
        OpDecl self = selfDef.opDecl;
        if (self == null && bind != BindBlock.EMPTY) {
            opSet.reporter.report((Problem)new OperatorError.BadBindBlock(selfDef.concrete.sourcePos(), selfDef.name()));
            throw new Context.ResolvingInterruptedException();
        }
        StmtResolver.bind(bind, opSet, self);
    }

    private static void bind(@NotNull BindBlock bindBlock, AyaBinOpSet opSet, OpDecl self) {
        if (bindBlock == BindBlock.EMPTY) {
            return;
        }
        Context ctx = (Context)bindBlock.context().get();
        if (!1.$assertionsDisabled && ctx == null) {
            throw new AssertionError((Object)"no shallow resolver?");
        }
        bindBlock.resolvedLoosers().set((Object)bindBlock.loosers().map(looser -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Looser, looser)));
        bindBlock.resolvedTighters().set((Object)bindBlock.tighters().map(tighter -> StmtResolver.bind(self, opSet, ctx, OpDecl.BindPred.Tighter, tighter)));
    }

    @NotNull
    private static DefVar<?, ?> bind(@NotNull OpDecl self, @NotNull AyaBinOpSet opSet, @NotNull Context ctx, @NotNull OpDecl.BindPred pred, @NotNull QualifiedID id) throws Context.ResolvingInterruptedException {
        DefVar defVar;
        OpDecl opDecl;
        AnyVar anyVar = ctx.get(id);
        if (anyVar instanceof DefVar && (opDecl = (defVar = (DefVar)anyVar).resolveOpDecl(ctx.moduleName())) != null) {
            opSet.bind(self, pred, opDecl, id.sourcePos());
            return defVar;
        }
        opSet.reporter.report((Problem)new NameProblem.OperatorNameNotFound(id.sourcePos(), id.join()));
        throw new Context.ResolvingInterruptedException();
    }

    public static void resolveBind(@NotNull @NotNull SeqLike<@NotNull Stmt> contents, @NotNull ResolveInfo info) {
        contents.forEach(s -> StmtResolver.resolveBind(s, info));
        info.opRename().forEach((k, v) -> {
            if (v._2 == BindBlock.EMPTY) {
                return;
            }
            StmtResolver.bind((BindBlock)v._2, info.opSet(), (OpDecl)v._1);
        });
    }

    public static void resolveBind(@NotNull Stmt stmt, @NotNull ResolveInfo info) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.Module.class, ClassDecl.class, TeleDecl.DataDecl.class, TeleDecl.StructDecl.class, TeleDecl.DataCtor.class, TeleDecl.StructField.class, TeleDecl.FnDecl.class, TeleDecl.PrimDecl.class, Remark.class, Command.class, Generalize.class}, (Object)stmt3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                Command.Module mod = (Command.Module)stmt3;
                StmtResolver.resolveBind(mod.contents(), info);
                break;
            }
            case 1: {
                ClassDecl classDecl = (ClassDecl)stmt3;
                throw new UnsupportedOperationException("not implemented yet");
            }
            case 2: {
                TeleDecl.DataDecl decl = (TeleDecl.DataDecl)stmt3;
                decl.body.forEach(ctor -> StmtResolver.resolveBind(ctor, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 3: {
                TeleDecl.StructDecl decl = (TeleDecl.StructDecl)stmt3;
                decl.fields.forEach(field -> StmtResolver.resolveBind(field, info));
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 4: {
                TeleDecl.DataCtor ctor2 = (TeleDecl.DataCtor)stmt3;
                StmtResolver.visitBind(ctor2.ref, ctor2.bindBlock, info);
                break;
            }
            case 5: {
                TeleDecl.StructField field2 = (TeleDecl.StructField)stmt3;
                StmtResolver.visitBind(field2.ref, field2.bindBlock, info);
                break;
            }
            case 6: {
                TeleDecl.FnDecl decl = (TeleDecl.FnDecl)stmt3;
                StmtResolver.visitBind(decl.ref, decl.bindBlock, info);
                break;
            }
            case 7: {
                TeleDecl.PrimDecl decl = (TeleDecl.PrimDecl)stmt3;
                break;
            }
            case 8: {
                Remark remark = (Remark)stmt3;
                break;
            }
            case 9: {
                Command cmd = (Command)stmt3;
                break;
            }
            case 10: {
                Generalize generalize = (Generalize)stmt3;
            }
        }
    }

    public static Pattern.Clause matchy(@NotNull Pattern.Clause match, @NotNull Context context, @NotNull ExprResolver bodyResolver) {
        MutableValue ctx = MutableValue.create((Object)context);
        ImmutableSeq pats = match.patterns.map(pat -> StmtResolver.subpatterns((MutableValue<Context>)ctx, pat));
        return new Pattern.Clause(match.sourcePos, (ImmutableSeq<Pattern>)pats, (Option<Expr>)match.expr.map(e -> bodyResolver.resolve((Expr)e, (Context)ctx.get())));
    }

    @NotNull
    public static Pattern subpatterns(@NotNull MutableValue<Context> ctx, Pattern pat) {
        Tuple2<Context, Pattern> res = StmtResolver.resolve(pat, (Context)ctx.get());
        ctx.set((Object)((Context)res._1));
        return (Pattern)res._2;
    }

    public static Context bindAs(LocalVar as, Context ctx, SourcePos sourcePos) {
        return as != null ? ctx.bind(as, sourcePos) : ctx;
    }

    public static Tuple2<Context, Pattern> resolve(@NotNull Pattern pattern, Context context) {
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Tuple.class, Pattern.Bind.class, Pattern.BinOpSeq.class}, (Object)pattern3, n)) {
            case 0 -> {
                Pattern.Tuple tuple = (Pattern.Tuple)pattern3;
                MutableValue newCtx = MutableValue.create((Object)context);
                ImmutableSeq patterns = tuple.patterns().map(p -> StmtResolver.subpatterns((MutableValue<Context>)newCtx, p));
                yield Tuple.of((Object)StmtResolver.bindAs(tuple.as(), (Context)newCtx.get(), tuple.sourcePos()), (Object)new Pattern.Tuple(tuple.sourcePos(), tuple.explicit(), (ImmutableSeq<Pattern>)patterns, tuple.as()));
            }
            case 1 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern3;
                DefVar<?, ?> maybe = StmtResolver.findPatternDef(context, bind.sourcePos(), bind.bind().name());
                if (maybe != null) {
                    yield Tuple.of((Object)context, (Object)new Pattern.Ctor(bind, maybe));
                }
                yield Tuple.of((Object)context.bind(bind.bind(), bind.sourcePos(), var -> false), (Object)bind);
            }
            case 2 -> {
                Pattern.BinOpSeq seq = (Pattern.BinOpSeq)pattern3;
                MutableValue newCtx = MutableValue.create((Object)context);
                ImmutableSeq pats = seq.seq().map(p -> StmtResolver.subpatterns((MutableValue<Context>)newCtx, p));
                yield Tuple.of((Object)StmtResolver.bindAs(seq.as(), (Context)newCtx.get(), seq.sourcePos()), (Object)new Pattern.BinOpSeq(seq.sourcePos(), (ImmutableSeq<Pattern>)pats, seq.as(), seq.explicit()));
            }
            default -> Tuple.of((Object)context, (Object)pattern);
        };
    }

    @Nullable
    public static DefVar<?, ?> findPatternDef(Context context, SourcePos namePos, String name) {
        return context.iterate(c -> {
            AnyVar maybe = c.getUnqualifiedLocalMaybe(name, namePos);
            if (!(maybe instanceof DefVar)) {
                return null;
            }
            DefVar defVar = (DefVar)maybe;
            if (defVar.core instanceof CtorDef || defVar.concrete instanceof TeleDecl.DataCtor) {
                return defVar;
            }
            if (defVar.core instanceof PrimDef || defVar.concrete instanceof TeleDecl.PrimDecl) {
                return defVar;
            }
            return null;
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

