/*
 * Decompiled with CFR 0.152.
 */
package org.aya.terck;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.term.CallTerm;
import org.aya.generic.util.InternalException;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.terck.Relation;
import org.aya.terck.Selector;
import org.aya.util.ArrayUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="toDoc().debugRender()")
public record CallMatrix<Def, Param>(@NotNull CallTerm callTerm, @NotNull Def domain, @NotNull Def codomain, @NotNull ImmutableSeq<Param> domainTele, @NotNull ImmutableSeq<Param> codomainTele, @NotNull Relation[][] matrix) implements Docile,
Selector.Candidate<CallMatrix<Def, Param>>
{
    public CallMatrix(@NotNull CallTerm callTerm, @NotNull Def domain, @NotNull Def codomain, @NotNull ImmutableSeq<Param> domainTele, @NotNull ImmutableSeq<Param> codomainTele) {
        this(callTerm, domain, codomain, domainTele, codomainTele, new Relation[codomainTele.size()][domainTele.size()]);
        ArrayUtil.fill((Object[][])this.matrix, (Object)Relation.unk());
    }

    public int rows() {
        return this.codomainTele.size();
    }

    public int cols() {
        return this.domainTele.size();
    }

    public void set(@NotNull Param domain, @NotNull Param codomain, @NotNull Relation relation) {
        int row = this.codomainTele.indexOf(codomain);
        int col = this.domainTele.indexOf(domain);
        assert (row != -1);
        assert (col != -1);
        this.matrix[row][col] = relation;
    }

    @Override
    @NotNull
    public Selector.DecrOrd compare(@NotNull CallMatrix<Def, Param> other) {
        if (this.domain != other.domain || this.codomain != other.codomain) {
            return Selector.DecrOrd.Unk;
        }
        Selector.DecrOrd rel = Selector.DecrOrd.Eq;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                Relation m = this.matrix[i][j];
                Relation n = other.matrix[i][j];
                Selector.DecrOrd cmp = m.compare(n);
                rel = rel.mul(cmp);
            }
        }
        return rel;
    }

    @Contract(pure=true)
    @NotNull
    public static <Def, Param> CallMatrix<Def, Param> combine(@NotNull CallMatrix<Def, Param> A, @NotNull CallMatrix<Def, Param> B) {
        if (B.domain != A.codomain) {
            throw new InternalException("The combine cannot be applied to these two call matrices");
        }
        CallMatrix<Def, Param> BA = new CallMatrix<Def, Param>(B.callTerm, A.domain, B.codomain, A.domainTele, B.codomainTele);
        for (int i = 0; i < BA.rows(); ++i) {
            for (int j = 0; j < BA.cols(); ++j) {
                for (int k = 0; k < B.cols(); ++k) {
                    BA.matrix[i][j] = BA.matrix[i][j].add(B.matrix[i][k].mul(A.matrix[k][j]));
                }
            }
        }
        return BA;
    }

    @NotNull
    public Doc toDoc() {
        ImmutableSeq lines = ImmutableSeq.from((Object[])this.matrix).map(row -> Doc.stickySep((SeqLike)ImmutableSeq.from((Object[])row).map(Relation::toDoc)));
        return Doc.vcat((SeqLike)lines);
    }
}

