/*
 * Decompiled with CFR 0.152.
 */
package org.aya.terck;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.mutable.MutableSet;
import kala.tuple.Tuple2;
import kala.value.MutableValue;
import org.aya.core.Matching;
import org.aya.core.def.Def;
import org.aya.core.def.FnDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.LitTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.DefConsumer;
import org.aya.generic.Arg;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.terck.CallGraph;
import org.aya.terck.CallMatrix;
import org.aya.terck.Relation;
import org.jetbrains.annotations.NotNull;

public record CallResolver(@NotNull FnDef caller, @NotNull MutableSet<Def> targets, @NotNull MutableValue<Matching> currentMatching, @NotNull CallGraph<Def, Term.Param> graph) implements DefConsumer
{
    public CallResolver(@NotNull FnDef fn, @NotNull MutableSet<Def> targets, @NotNull CallGraph<Def, Term.Param> graph) {
        this(fn, targets, (MutableValue<Matching>)MutableValue.create(), graph);
    }

    private void resolveCall(@NotNull CallTerm callTerm) {
        AnyVar anyVar = callTerm.ref();
        if (!(anyVar instanceof DefVar)) {
            return;
        }
        DefVar defVar = (DefVar)anyVar;
        Def callee = (Def)defVar.core;
        if (!this.targets.contains((Object)callee)) {
            return;
        }
        CallMatrix<Def, Term.Param> matrix = new CallMatrix<Def, Term.Param>(callTerm, this.caller, callee, this.caller.telescope, callee.telescope());
        this.fillMatrix(callTerm, callee, matrix);
        this.graph.put(matrix);
    }

    private void fillMatrix(@NotNull CallTerm callTerm, @NotNull Def callee, CallMatrix<Def, Term.Param> matrix) {
        Matching matching = (Matching)this.currentMatching.get();
        if (matching == null) {
            return;
        }
        for (Tuple2 domThing : matching.patterns().zipView((SeqLike)this.caller.telescope)) {
            for (Tuple2 codomThing : callTerm.args().zipView(callee.telescope())) {
                Relation relation = this.compare((Term)((Arg)codomThing._1).term(), (Pat)domThing._1);
                matrix.set((Term.Param)domThing._2, (Term.Param)codomThing._2, relation);
            }
        }
    }

    @NotNull
    private Relation compare(@NotNull Term term, @NotNull Pat pat) {
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Ctor.class, Pat.Bind.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            case 0 -> {
                Pat.Ctor ctor = (Pat.Ctor)pat3;
                Term v1 = term;
                Objects.requireNonNull(v1);
                Term var8_6 = v1;
                int var9_8 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CallTerm.Con.class, LitTerm.ShapedInt.class}, (Object)var8_6, var9_8)) {
                    case 0: {
                        CallTerm.Con con = (CallTerm.Con)var8_6;
                        if (con.ref() != ctor.ref() || !con.conArgs().sizeEquals(ctor.params())) {
                            yield Relation.unk();
                        }
                        SeqView subCompare = con.conArgs().zipView(ctor.params()).map(sub -> this.compare((Term)((Arg)sub._1).term(), (Pat)sub._2));
                        yield (Relation)subCompare.foldLeft((Object)Relation.eq(), Relation::mul);
                    }
                    case 1: {
                        LitTerm.ShapedInt lit = (LitTerm.ShapedInt)var8_6;
                        yield this.compare((Term)lit.constructorForm(), ctor);
                    }
                }
                SeqView subCompare = ctor.params().view().map(sub -> this.compare(term, (Pat)sub));
                if (subCompare.anyMatch(r -> r != Relation.unk())) {
                    yield Relation.lt();
                }
                yield Relation.unk();
            }
            case 1 -> {
                Pat.Bind bind = (Pat.Bind)pat3;
                if (term instanceof RefTerm) {
                    RefTerm ref = (RefTerm)term;
                    if (ref.var() == bind.bind()) {
                        yield Relation.eq();
                    }
                    yield Relation.unk();
                }
                Term subCompare = this.headOf(term);
                if (subCompare instanceof RefTerm) {
                    RefTerm ref = (RefTerm)subCompare;
                    if (ref.var() == bind.bind()) {
                        yield Relation.lt();
                    }
                    yield Relation.unk();
                }
                yield Relation.unk();
            }
            case 2 -> {
                Pat.ShapedInt intPat = (Pat.ShapedInt)pat3;
                Term v3 = term;
                Objects.requireNonNull(v3);
                Term var12_18 = v3;
                int var13_19 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LitTerm.ShapedInt.class, CallTerm.Con.class}, (Object)var12_18, var13_19)) {
                    case 0: {
                        LitTerm.ShapedInt intTerm = (LitTerm.ShapedInt)var12_18;
                        if (intTerm.shape() != intPat.shape()) {
                            yield Relation.unk();
                        }
                        yield Relation.fromCompare(Integer.compare(intTerm.repr(), intPat.repr()));
                    }
                    case 1: {
                        CallTerm.Con con = (CallTerm.Con)var12_18;
                        yield this.compare(con, (Pat)intPat.constructorForm());
                    }
                }
                yield this.compare(term, (Pat)intPat.constructorForm());
            }
            default -> Relation.unk();
        };
    }

    @NotNull
    private Term headOf(@NotNull Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ElimTerm.App.class, ElimTerm.Proj.class, CallTerm.Access.class}, (Object)term3, n)) {
            case 0 -> {
                ElimTerm.App app = (ElimTerm.App)term3;
                yield this.headOf(app.of());
            }
            case 1 -> {
                ElimTerm.Proj proj = (ElimTerm.Proj)term3;
                yield this.headOf(proj.of());
            }
            case 2 -> {
                CallTerm.Access access = (CallTerm.Access)term3;
                yield this.headOf(access.of());
            }
            default -> term;
        };
    }

    @Override
    public void visitMatching(@NotNull Matching matching) {
        this.currentMatching.set((Object)matching);
        DefConsumer.super.visitMatching(matching);
        this.currentMatching.set(null);
    }

    @Override
    public void pre(@NotNull Term term) {
        if (term instanceof CallTerm) {
            CallTerm call = (CallTerm)term;
            this.resolveCall(call);
        }
        DefConsumer.super.pre(term);
    }
}

